
// POV-Ray 2.0 sample data file written by Alexander Enzmann
#include "colors.inc"           // Standard colors library
#include "shapes.inc"           // Commonly used object shapes
#include "textures.inc"         // LOTS of neat textures.  Lots of NEW textures.
#include "stones.inc"

global_settings {
  max_intersections 20
}
#declare AMB=.4;

// picture - in picture calculations:
#declare track_start=60;
#declare cyclic_length=4;
#declare cycle_at=73;
#declare cycle_off=80;
#declare fpc=15;

#declare pic_clock=clock+track_start+(.25/fpc);
#while ((pic_clock>cycle_at) & (pic_clock<cycle_off))
//#while (pic_clock>cycle_at)
  #declare pic_clock=pic_clock-cyclic_length;
#end

#declare pic_frame=(pic_clock*fpc);
#declare pic_name=concat("ufo_",str(pic_frame,-4,0),".tga")
#render pic_name

//#include "flight_macros.inc"
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end                          
#macro move_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock,default_val)
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock < start_clock )
    ( default_val )
  #end
  #if ( current_clock > end_clock )
    ( default_val )
  #end
  #if ( ( current_clock >= start_clock ) & ( current_clock <= end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end

#declare second=clock;
#declare scene_clock=clock;
#while (scene_clock>1)
  #declare scene_clock=scene_clock-1;
#end

#declare ufo_cam_pos=<0,5,-11.5>; 
//#declare ufo_lamp_slide=<0,0,0>;
#declare ufo_lamp_switch=0;

#declare f_clock=0;                                                          
#declare fish_mouth=0;
#declare shock=on;
#declare eyelid=1;  
#declare iris=1;
#declare eye_down=0;
#declare eye_right=0;
#declare head_dip=0;
#declare head_tilt_right=0;
#declare sympathy_twist=10; 
#declare blind_upperbreak=0;
#declare blind_lowerbreak=0;
#declare swim_power=0;
#declare view=1;
#declare fish_pos=<0,3,0>;
#declare fish_elevation=0;
#declare fish_downright=0;
#declare fish_right=0;
#declare rf_downplane=0;        // right fin downplane angle (sub-talk)
#declare lf_downplane=0;        // left fin downplane angle 
#declare rf_down=0;             // right fin 
#declare lf_down=0;             // left fin 
#declare rf_back=10;             // right fin rearward angle (swingwing) typ -10 to +20
#declare lf_back=10;             // left fin rearward angle (swingwing) typ -10 to +20
#declare fish_elevation=40;
#declare eye_down=40;
#declare head_dip=35;  
#declare head_rise=0;

#declare sf_clock=0;                                                          
#declare sfish_mouth=0;
#declare sshock=on;
#declare seyelid=1;  
#declare siris=1;
#declare shead_dip=0;
#declare shead_rise=0;
#declare shead_tilt_right=0;
#declare ssympathy_twist=10; 
#declare sblind_upperbreak=0;
#declare sblind_lowerbreak=0;
#declare sswim_power=0;
#declare sview=1;
#declare sfish_pos=<0,3,0>;
#declare sfish_elevation=0;
#declare sfish_downright=0;
#declare sfish_right=0;
#declare seye_down=0;
#declare srf_downplane=0;        // right fin downplane angle (sub-talk)
#declare slf_downplane=0;        // left fin downplane angle 
#declare srf_down=0;             // right fin 
#declare slf_down=0;             // left fin 
#declare srf_back=10;             // right fin rearward angle (swingwing) typ -10 to +20
#declare slf_back=10;             // left fin rearward angle (swingwing) typ -10 to +20

                        
#declare f_clock=clock/2;
#declare swim_power=.35;

#declare sf_clock=clock/2;
#declare sswim_power=.35;

#declare bp_freq=clock; //      flipper frequency
#declare bp_mag=5;

#declare sbp_freq=clock; //      flipper frequency
#declare sbp_mag=5;


#declare eyelid=(flight_spline(eyelid,1,0,0,7,7.25,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,7.25,7.5,clock) );         // cont.       

#declare fish_elevation=(flight_spline(50,45,35,30,8,10,clock) );
#declare head_dip=(flight_spline(head_dip,25,25,15,8,10,clock) );
#declare head_rise=(flight_spline(head_rise,0,-15,-20,8,10,clock) );

#declare fish_elevation=(flight_spline(fish_elevation,25,25,30,10,12,clock) );
#declare eye_down=fish_elevation;

#declare eye_right=(flight_spline(0,0,20,20,6.75,7.75,clock) );
#declare fish_right=(flight_spline(0,0,10,10,6.75,7.75,clock) );   
#declare eye_right=(flight_spline(eye_right,20,-20,-20,7.75,9.75,clock) );
#declare fish_right=(flight_spline(fish_right,10,-10,-10,7.75,9.75,clock) );
#declare eye_right=(flight_spline(eye_right,-20,0,0,9.75,10.75,clock) );
#declare fish_right=(flight_spline(fish_right,-10,-5,-5,9.75,10.75,clock) );
#declare eye_down=eye_down+(flight_spline(0,30,30,0,9.25,10.5,clock) );
                                                                                                                                 
#declare eye_right=(flight_spline(eye_right,0,-20,-20,11,12,clock) );
#declare fish_downright=(flight_spline(fish_downright,0,-20,-20,12,13,clock) );
#declare fish_right=(flight_spline(fish_right,-5,-45,-85,12,16,clock) );
#declare fish_downright=(flight_spline(fish_downright,-20,0,0,14,15,clock) );
#declare eye_right=(flight_spline(eye_right,-20,0,0,14,16,clock) );
//#declare fish_right=(flight_spline(fish_right,-25,-85,-85,14,16,clock) );                              

#declare head_tilt_right=(flight_spline(head_tilt_right,0,15,15,15.5,16,clock) );
#declare head_tilt_right=(flight_spline(head_tilt_right,15,0,0,16,17,clock) );
               
#declare fish_pos=(flight_spline(<0,3,0>,<0,3,0>,<0,3.25,.25>,<0,3.5,0>,5,10,clock) );
#declare fish_pos=(flight_spline(fish_pos,<0,3.75,-.25>,<0,3.5,0>,<0,3.75,0>,10,15,clock) );
#declare fish_pos=(flight_spline(fish_pos,<0,4,0>,<0,4,0>,<0,3.75,0>,15,20,clock) );
#declare fish_pos=(flight_spline(fish_pos,<0,3.5,0>,<.25,3.75,0>,<.25,4,0>,20,25,clock) );
#declare fish_pos=(flight_spline(fish_pos,<.25,4.25,0>,<0,4,0>,<0,3.75,0>,25,30,clock) );
#declare fish_pos=(flight_spline(fish_pos,<0,3.5,0>,<.25,3.75,0>,<.25,4,0>,30,35,clock) );
                         
// fish2 vars:  when t<=18, mimicks fish1 vars.
// from 18 to 19, transposes to own initiators.
// fish2 goes fully aware at t+19                         
#declare sfish_mouth=(flight_spline(fish_mouth,fish_mouth,0,0,17,18,clock) );
#declare sshock=shock;             
#declare seye_right=(flight_spline(eye_right,eye_right,0,0,17,28,clock) );
#declare seyelid=(flight_spline(eyelid,eyelid,1,1,17,18,clock) );
#declare siris=(flight_spline(iris,iris,1,1,17,18,clock) );
#declare shead_dip=(flight_spline(head_dip,head_dip,15,15,17,18,clock) );
#declare shead_rise=(flight_spline(head_rise,head_rise,-20,-20,17,18,clock) );
#declare shead_tilt_right=(flight_spline(head_tilt_right,head_tilt_right,0,0,17,18,clock) );
#declare ssympathy_twist=10; 
#declare sswim_power=(flight_spline(swim_power,swim_power,.35,.35,17,18,clock) );
//#declare sfish_pos=(flight_spline(fish_pos,fish_pos,<0,4,0>,<0,4,0>,17,18,clock) );
#declare sfish_pos=fish_pos;
#declare sfish_elevation=(flight_spline(fish_elevation,fish_elevation,25,25,17,18,clock) );
#declare sfish_downright=(flight_spline(fish_downright,fish_downright,0,0,17,18,clock) );
#declare sfish_right=(flight_spline(fish_right,fish_right,-85,-85,17,18,clock) );
#declare seye_down=(flight_spline(eye_down,eye_down,30,30,17,18,clock) );
                                 
#declare sfish_downright=(flight_spline(sfish_downright,5,15,20,18,19,clock) );
#declare seye_right=(flight_spline(seye_right,seye_right,20,20,18,19,clock) );
#declare sfish_right=(flight_spline(sfish_right,-75,75,80,18,21,clock) );
#declare sfish_downright=(flight_spline(sfish_downright,15,5,0,20,21,clock) );
#declare seye_right=(flight_spline(seye_right,seye_right,0,0,20,21,clock) );
                                                                         
#declare sfish_right=(flight_spline(sfish_right,75,135,140,23,25,clock) );

#declare sbp_mag=(flight_spline(sbp_mag,sbp_mag,1,1,25,26,clock) );
#declare sswim_power=(flight_spline(sswim_power,sswim_power,.25,.25,25,26,clock) );

#declare slf_down=(flight_spline(slf_down,-10,-10,0,26,32,clock) );
#declare slf_back=(flight_spline(slf_back,-20,-20,10,26,32,clock) );
#declare slf_downplane=(flight_spline(0,-50,-50,0,26,32,clock) );
#declare sfish_downright=(flight_spline(sfish_downright,10,10,sfish_downright,26,32,clock) );

#declare wave=10*sin(clock*4*pi);
#declare wave=(flight_spline(0,0,wave,wave,27,29,clock) );
#declare wave=(flight_spline(wave,wave,0,0,29,31,clock) );
#declare slf_down=slf_down+wave;
#declare slf_down=slf_down+wave;
                                                                         
#declare shead_dip=(flight_spline(shead_dip,-10,0,15,20,22,clock) );    // watch 
#declare seye_down=(flight_spline(seye_down,-10,-5,0,20,22,clock) );    // teleport
                                 
#declare t_p_v2=0;
#declare pc_pos=0;
#if (clock>14)
  #declare t_p_v2=6.5;
#end
#if (clock>=8 & clock<=18)
  //#declare sf_clock=clock;
  
  #declare pc_pos=1.1;
  #if (clock>=10)
    #declare pc_pos=1.1+(5.4*(clock-10)/3.5);
    #declare t_p_v2=pc_pos;
  #end
  #if (clock>=13.5)
    #declare pc_pos=6.5
    #declare t_p_v2=pc_pos;
  #end
  #if (clock>=14)
    #declare pc_pos=6.5-5.4*((clock-14)/3.5);
  #end
  #declare copy_beam=
    object {
      cylinder { <0,-.01,0>,<0,.01,0>,1 }
      texture { 
        pigment {
          cylindrical
          color_map {
            [ 0 color rgbf<1,1,1,.9> ]
            [ .25 color rgbf<.5,1,.5,0> ]
            [ .75 color rgbf<.5,1.0075,.5,.9> ]
            [ 1 color rgbf<1,1,1.0075,.9> ]
          } 
        } 
        finish { 
          ambient 1 
          diffuse 0 
        } 
      }
      scale 2.5
      hollow on
      no_shadow
    }
  object { copy_beam translate <-3,pc_pos,2> }
  object { copy_beam translate <3,pc_pos,2> }
  #render "copy on.\n"
#end
  
  
#declare lf_downplane=lf_downplane-bp_mag-bp_mag*cos(bp_freq*2*pi);
#declare lf_back=lf_back-2*bp_mag*sin(bp_freq*2*pi);
#declare rf_downplane=lf_downplane-bp_mag-bp_mag*cos(bp_freq*2*pi);
#declare rf_back=lf_back-2*bp_mag*sin(bp_freq*2*pi);

#declare slf_downplane=slf_downplane-sbp_mag-sbp_mag*cos(sbp_freq*2*pi);
#declare slf_back=slf_back-2*sbp_mag*sin(sbp_freq*2*pi);
#declare srf_downplane=slf_downplane-sbp_mag-sbp_mag*cos(sbp_freq*2*pi);
#declare srf_back=slf_back-2*sbp_mag*sin(sbp_freq*2*pi);
  
  

#declare c_pos=0;
#declare c_pos=(flight_spline(0,.01,.99,1,0,8,clock));
camera {
   location <0,0,0>
   direction <0, 0, 1.45>
   up <0,1,0>
   right <4/3,0,0>
   //look_at   <23, 15, -9>
   look_at <0,0,10>
   rotate <7,0,0> 
   translate <0,5,0>
   translate <0,0,-10*c_pos>
   //rotate <0,-5*c_pos,0>
}


light_source { <15,20,-10> color .7 }
light_source { <-15,4,-10> color .3 }

#render "\n"
                         
// set up fish vars                         
//#declare fish_right=90;
                                    
#declare panel_white=
  texture {
    pigment {
      color rgb<.85,.85,.85>
    }
    finish {
      ambient AMB
      diffuse .6
      //roughness 0.01
      //specular 0.4
    }  
  }
                                      
plane { y,0 texture { panel_white } }

union {
  difference {
    box { <0,0,-1>,<1,1,2> translate <-.5,-.5,0> translate <-1/1280,-1/1024,0> scale <32,24,1> scale <.4,.32,.15> }
    box { <0,0,-2>,<1,1,1.5> translate <-.5,-.5,0> translate <-1/1280,-1/1024,0> scale <32,24,1> scale .288 }
    texture {
      pigment {
        color rgb<.5,.5,.5>
      }
      finish {
        ambient AMB
        diffuse .6
        //roughness 0.01
        //specular 0.4
      }  
    }
  }
  box { <-20,-20,.01>,<20,20,1> texture { panel_white } }
  box { 
    <0,0,0>,<1,1,1>
    texture { 
      pigment {
        image_map {
          tga pic_name //"ufo_c525.tga"
          map_type 0 
          once
        }   
      }
      finish {
        ambient 1
        diffuse 0
      }
    }             
    translate <-.5,-.5,0>
    translate <-1/1280,-1/1024,0>
    scale <32,24,1>
    scale .288
  }
  translate <0,0,10>
  rotate <7,0,0>
  translate <0,5,0>
}
       
object {
  union {
    difference {
      box { <-6,0,-3>,<6,1,3> }
      box { <0,0,-4>,<1,1,4> rotate <0,0,-45> translate <5.5,1.1,0> }
      box { <0,0,-4>,<-1,1,4> rotate <0,0,45> translate <-5.5,1.1,0> }
      box { <-6.5,0,0>,<6,1,1> rotate <45,0,0> translate <0,1.1,2.5> }
      box { <-6.5,0,0>,<6,1,-1> rotate <-45,0,0> translate <0,1.1,-2.5> }
      texture {
        pigment {
          color rgb<0.5,0.5,0.5>
        }
        finish {
          ambient AMB
          diffuse .6
          //roughness .1
          //specular .8
        }
      }
    }
    cylinder { <0,0,0>,<0,.01,0>,1
      texture { 
        pigment {
          cylindrical
          color_map {
            [ 0 color rgb<1,1,1> ]
            [ .75 color rgb<0,0,0> ]
            [ 1 color rgb<0,0,0> ]
          } 
          //color rgb<1,1,1>
        } 
        finish { 
          ambient 1 
          diffuse 0 
        } 
      }
      scale 2.01
      translate <-3,1,0>
    }
    cylinder { <0,0,0>,<0,.01,0>,1
      texture { 
        pigment {
          cylindrical
          color_map {
            [ 0 color rgb<1,1,1> ]
            [ .75 color rgb<0,0,0> ]
            [ 1 color rgb<0,0,0> ]
          } 
          //color rgb<1,1,1>
        } 
        finish { 
          ambient 1 
          diffuse 0 
        } 
      }
      scale 2.01
      translate <3,1,0>
    }
  }
  translate <0,0,2>
}

#declare t_port_c1=0;                                        
#declare t_port_c1=(flight_spline(t_port_c1,0,1,1,3,8,clock) );
#declare t_port_c1=(flight_spline(t_port_c1,1,0,0,19,24,clock) );
#declare t_p_v1=t_port_c1*10-2;
  

#if (t_p_v1<1.02)
  #declare t_p_v1=1.02;
#else
  #if (t_p_v1>6.5)
    #declare t_p_v1=6.5;        
  #end
  object {
    cylinder { <0,t_p_v1,0>,<0,.9,0>,2 }
    texture {
      pigment { 
        color rgbf <0.94, 0.96, 0.99, 0.94>
      }
      finish  {
        ambient AMB
        diffuse 0.1
        //reflection 0.2
        specular 0.8
        roughness 0.001
        irid {
          0.2
          thickness .35
          turbulence .5        
        }
      }
    }
    interior { 
      ior 1.33                  //      water
      fade_distance 10
      fade_power 2
      caustics 1
    }
    hollow on
    translate <-3,0,2>
  }     
#end
                 
#if ( t_port_c1>0 & t_port_c1<1 )
  #declare t_port_bubble=
    intersection {
      box { <-3,.8,-3>,<3,6.6,3> }
      cylinder { <0,-.75,0>,<0,1.5,0>,2.01 translate <0,t_port_c1*10-2,0> }
      texture { 
        pigment { 
          gradient y
          color_map {
            [ 0 color rgbf<1,1,1,0> ]
            [ .05 color rgbf<1,1,1,0> ]
            [ .1 color rgbf<1,1,1,1> ]
            [ 1 color rgbf<1,1,1,1> ]
          }                   
          scale <1,10,1>
          translate <0,t_port_c1*10-2,0>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
      hollow on
      no_shadow  
    }    
  #render "teleport on\n"
  object { t_port_bubble translate <-3,0,2> }


#end
   
//object { cyl translate <-2.5,0,2> }    

#include "gf2.inc"

#if (t_port_c1>0)
  difference {
    object { 
      fish 
      scale .26       
      translate <-1,0,0>
      rotate <fish_downright,0,0>
      rotate <0,-90,0> 
      rotate <fish_elevation,0,0>
      rotate <0,fish_right,0>
      translate (fish_pos)
      translate <-3,0,2>
    }
    box { <-10,10,-10>,<10,t_p_v1+.01,10> texture { pigment { color rgb<1,1,1> } } }
  }
#end          

// right tank


#if (t_p_v2<1.02)
  #declare t_p_v2=1.02;
#else
  #if (t_p_v2>6.5)
    #declare t_p_v2=6.5;        
  #end
  object {
    cylinder { <0,t_p_v2,0>,<0,.9,0>,2 }
    texture {
      pigment { 
        color rgbf <0.96, 0.96, 0.99, 0.94>
      }
      finish  {
        ambient AMB
        diffuse 0.1
        //reflection 0.2
        specular 0.8
        roughness 0.001
        irid {
          0.2
          thickness .35
          turbulence .5        
        }
      }
    }
    interior { 
      ior 1.33                  //      water
      fade_distance 10
      fade_power 2
      caustics 1
    }
    hollow on
    translate <3,0,2>
  }     
#end  


#if (pc_pos>1.5)
  intersection {
    object { 
      sfish_bones
      scale .26       
      translate <-1,0,0>
      rotate <sfish_downright,0,0>
      rotate <0,-90,0> 
      rotate <sfish_elevation,0,0>
      rotate <0,sfish_right,0>
      translate (sfish_pos)
      translate <3,0,2>
    }
    box { <-10,0,-10>,<10,pc_pos+.01,10> texture { pigment { color rgb<1,1,1> } finish { ambient 1 diffuse 0 } } }
  }
#end
#if (clock>14)          
  difference {
    object { 
      sfish
      scale .26       
      translate <-1,0,0>
      rotate <sfish_downright,0,0>
      rotate <0,-90,0> 
      rotate <sfish_elevation,0,0>
      rotate <0,sfish_right,0>
      translate (sfish_pos)
      translate <3,0,2>
    }
    box { <-10,0,-10>,<10,pc_pos,10> texture { pigment { color rgb<1,1,1> } finish { ambient 1 diffuse 0 } } }
  }
#end                                        


#render concat( "Overall Scene clock value currently at " , str(clock,-1,5) , " seconds.\n" )