#render concat( "fish clock value currently " , str(f_clock,-1,5) ,".\n" )

#declare s1_a=f_clock+1;
#declare s2_a=s1_a-1/8;
#declare s3_a=s2_a-1/8;
#declare s4_a=s3_a-1/8;
#declare s5_a=s4_a-1/8;
#declare s6_a=s5_a-1/8;

#declare s1_a=sin(2*pi*s1_a)*5*swim_power;
#declare s2_a=sin(2*pi*s2_a)*6*swim_power;
#declare s3_a=sin(2*pi*s3_a)*7*swim_power;
#declare s4_a=sin(2*pi*s4_a)*8*swim_power;
#declare s5_a=sin(2*pi*s5_a)*9*swim_power;
#declare s6_a=sin(2*pi*s6_a)*10*swim_power;

    
  #declare fish_pigment=
    pigment { 
      colour rgb<1,.5,0>
    }
    #declare fish_finish=
    finish {
      ambient .4
      diffuse .6
      //reflection .1
      roughness 0.1
      specular 0.8
    }
    #declare fish_texture=
    texture {
      pigment { fish_pigment }
      finish { fish_finish }
    }   
    
#declare bone_texture=
  texture {
    pigment { color rgb<1,1,1> }
    finish { fish_finish }
  }     

#declare sphere_slice_f=
  intersection {
    sphere { 0,1 }
    box { <-2,2,2>,<0,-2,-2> rotate <0,0,-10> }
  }
#declare spliced_sphere_f=
  union {
    intersection {
      object { sphere_slice_f translate <0,0,-.2> }
      box { <-2,0,-0.0001>,<2,2,2> }
    }
    intersection {
      object { sphere_slice_f translate <0,0,.2> }
      box { <-2,0,0.0001>,<2,2,-2> }
    }
    matrix < 1,0,0,  .25,1,0,  0,0,1,  0,0,0 >
  }
#declare skull_splice_f=
  union {
    intersection {
      object { sphere_slice_f translate <0,0,-.2> }
      box { <-2,0,-0.0001>,<2,2,2> }
    }
    intersection {
      object { sphere_slice_f translate <0,0,.2> }
      box { <-2,0,0.0001>,<2,2,-2> }
    }                         
    scale .9
    matrix < 1,0,0,  .25,1,0,  0,0,1,  0,0,0 >
  }
#declare sphere_slice_fr=
  intersection {
    sphere { 0,1 }
    box { <-.01,2,2>,<2,-2,-2> rotate <0,0,-10> }
  }
#declare neck_repair=
  union {
    intersection {
      object { sphere_slice_fr translate <0,0,-.2> }
      box { <-2,0,-0.0001>,<2,2,2> }
    }
    intersection {
      object { sphere_slice_fr translate <0,0,.2> }
      box { <-2,0,0.0001>,<2,2,-2> }
    }
    scale .92
    //matrix < 1,0,0,  .25,1,0,  0,0,1,  0,0,0 >
  }
#macro sphere_slice_r (size)
  intersection {
    sphere { 0,1 scale <1.2,size,size> }
    box { <-.05,2,2>,<.5,-2,-2> rotate <0,0,-10> }
  }
#end
#macro spliced_sphere_r (size)
  union {
    intersection {
      object { sphere_slice_r (size) translate <0,0,-.2> }
      box { <-2,0,-0.0001>,<2,2,2> }
    }
    intersection {
      object { sphere_slice_r (size) translate <0,0,.2> }
      box { <-2,0,0.0001>,<2,2,-2> }
    }
    matrix < 1,0,0,  .23,1,0,  0,0,1,  0,0,0 >
  }
#end
#macro sphere_slice_t (size)
  intersection {
    sphere { 0,1 scale <1,size,size> }
    box { <-.05,2,2>,<2,-2,-2> rotate <0,0,-10> }
  }
#end
#macro spliced_sphere_t (size)
  union {
    intersection {
      object { sphere_slice_t (size) translate <0,0,-.2> }
      box { <-2,0,-0.0001>,<2,2,2> }
    }
    intersection {
      object { sphere_slice_t (size) translate <0,0,.2> }
      box { <-2,0,0.0001>,<2,2,-2> }
    }
    matrix < 1,0,0,  .25,1,0,  0,0,1,  0,0,0 >
  }
#end
#macro fish_body_upper (size)
  object {
    spliced_sphere_r (size)
  }
#end
#macro fish_body_lower (size)
  object {
    spliced_sphere_r (size)
    scale <1,-.5,1>
  }
#end
#macro fish_rib_seg_upper (size)
object {
    spliced_spine_r (size)
  }
#end
#macro fish_rib_seg_lower (size)
  object {
    spliced_spine_r (size)
    scale <1,-.5,1>
  }
#end
#declare fish_fin_v=
  union {    
    union {
      intersection {
        sphere { 0,1 }
        box { <0,0,-2>,<2,2,2> }
        scale <5,7,1>
      }              
      intersection {
        sphere { 0,1 }
        box { <-2,0,-2>,<0,2,2> }
        scale <2,7,1>
      }
      intersection {
        sphere { 0,1 }
        box { <0,-2,-2>,<2,0,2> }
        scale <5,1,1>
      }              
      intersection {
        sphere { 0,1 }
        box { <-2,-2,-2>,<0,0,2> }
        scale <2,1,1>
      }           
      matrix < 1,0,0,
              .6,1,0,
               0,0,1,
               0,0,0 >
    rotate <0,0,15>
    translate <1,1,0>
    }
    sphere { 0,1 }                 
    texture { fish_texture}
  }    
#declare fish_fin_b=
  union {    
    union {
      intersection {
        sphere { 0,1 }
        box { <-2,0,-2>,<2,2,2> }
        scale <.5,6,.5>
      }
      intersection {
        sphere { 0,1 }
        box { <-2,-2,-2>,<2,0,2> }
        scale <.5,1,.5>
      }           
      matrix < 1,0,0,
              .6,1,0,
               0,0,1,
               0,0,0 >
    rotate <0,0,15>
    translate <1,1,0>
    }
    sphere { 0,.9 }                 
    texture { bone_texture }
  }    
#macro fish_tail_upper (size)
  union {
    spliced_sphere_t (size)
    object { fish_fin_v scale size*.3 rotate <0,0,-15> translate <.1,0,0> }
  }
#end
#macro fish_tail_lower (size)
  union {
    spliced_sphere_t (size)
    object { fish_fin_v scale size*.3 rotate <0,0,-15> translate <.1,0,0> }
    scale <1,-.5,1>
  }
#end
#macro bone_tail_upper (size) 
object {
    object { fish_fin_b scale size*.3 rotate <0,0,-15> translate <.1,0,0> }
  }
#end
#macro bone_tail_lower (size)
  object {
    object { fish_fin_b scale size*.3 rotate <0,0,-15> translate <.1,0,0> }
    scale <1,-.5,1>
  }
#end
#declare fish_eyeball_r=
  object {
    sphere { 0,.4 }
    texture {
      pigment {
        gradient z
        pigment_map {
          [ 0 color rgb<1,1,1> ]
          [.38 color rgb<1,1,1> ]
          [.38 color rgb<0,0,0> ]          
          [ 1 color rgb<1,1,1> ]
        }          
      }
      finish {
        fish_finish
      }
      translate <0,0,.015-(iris*.015)>
    }
    rotate <0,-80,0>
    rotate <0,0,-10>
    rotate <0,0,eye_down-head_dip+head_rise>
    rotate <0,(s4_a)/2,0>      //      counter movement of head.
    rotate <0,eye_right,0>
  }
#declare fish_eyeball_l=
  object {
    sphere { 0,.4 }
    texture {
      pigment {
        gradient z
        pigment_map {
          [ 0 color rgb<1,1,1> ]
          [.38 color rgb<1,1,1> ]
          [.38 color rgb<0,0,0> ]
          [ 1 color rgb<1,1,1> ]
        }          
      }
      finish {
        fish_finish
      }
      translate <0,0,.015-(iris*.015)>
    }
    rotate <0,-100,0>
    rotate <0,0,-10>
    rotate <0,0,eye_down-head_dip+head_rise>
    rotate <0,s4_a/2,0>      //      counter movement of head.
    rotate <0,eye_right,0>
  }      
#declare eye_open=.7*eyelid;
#declare fish_eyelid=
  union {
    intersection {
      sphere { 0,.42 }
      box { <-1,0,-1>,<1,1,1> rotate <-45*eye_open,0,0> }
    }
    intersection {
      sphere { 0,.43 }
      box { <-1,0,-1>,<1,-1,1> rotate <40*eye_open-1,0,0> }
    }
    rotate <0,-55,0>
    rotate <sympathy_twist,0,0>
    texture { fish_texture }
  }
#declare fish_head_upper=
  union { 
    object { spliced_sphere_f texture { fish_texture } }
    object { neck_repair texture { fish_texture } }
    object { fish_eyeball_r translate <-.35,.35,.35> }
    object { fish_eyeball_l translate <-.35,.35,-.35> }
    object { fish_eyelid translate <-.35,.35,.35> }
    object { fish_eyelid scale <1,1,-1> translate <-.35,.35,-.35> }     
    rotate <0,0,-5*fish_mouth>
  }
#declare fish_skull_upper=
  difference {
    object { skull_splice_f }
    sphere { 0,.349 translate <-.35,.35,.35> }
    sphere { 0,.349 translate <-.35,.35,-.35> }
    rotate <0,0,-5*fish_mouth>
    texture { bone_texture }
  }        
#declare fish_head_lower=
  object { 
    difference {
      object { spliced_sphere_f texture { fish_texture } }
    //  object { spliced_sphere_f translate <0,-.2,0> texture { pigment { color rgb<0,0,0> } finish { ambient 0 } } }      
    }
    scale <1,-.5,1>
    rotate <0,0,20*fish_mouth>
  }
#declare fish_skull_lower=
  difference {
    object { spliced_sphere_f scale .85 }
    object { spliced_sphere_f scale <1,2,.8> translate <.2,-0.01,0> }      
    scale <1,-.5,1>
    rotate <0,0,20*fish_mouth>
    texture { bone_texture }
  }
#declare fish_head=
  union { 
    object { fish_head_upper }
    object { fish_head_lower translate <0,-.001,0> }
  }
#declare fish_skull=
  union { 
    object { fish_skull_upper }
    object { fish_skull_lower translate <0,.001,0> }
  }
#macro fish_body (size)
  union { 
    object { fish_body_upper (size) }
    object { fish_body_lower (size) translate <0,.001,0> }
    texture { fish_texture }
  }
#end
#macro spinal_bone (size)
  intersection { 
    sphere { 0,1 scale size scale <.1,1,.1> }
    box { <-1,0,-1>,<1,2,1> }                
    rotate <0,0,-18>  
    //translate <.5,0,0>
  } 
#end
#macro fish_rib_seg (size)
  union { 
    cylinder { <0,0,0>,<.5,0,0>,.08 }    
    sphere { 0,.12 }
    object { spinal_bone (size) scale .6 }
    object { spinal_bone (size) rotate <110,0,0> scale .65 }
    object { spinal_bone (size) rotate <-110,0,0> scale .65}    
    texture { bone_texture }                     
    translate <0,size/2-.16,0>
    rotate <0,0,-8>
  } 
#end
#macro fish_tail (size)
  union { 
    object { fish_tail_upper (size) }
    object { fish_tail_lower (size) translate <0,.001,0> }
    texture { fish_texture }
  }
#end                   
#macro bone_tail (size)
  union { 
    object { bone_tail_upper (size) }
    object { bone_tail_lower (size) translate <0,.001,0> }
    texture { bone_texture }
  }
#end                         
    
#declare fish=
  merge {
    object { fish_head rotate <head_tilt_right,0,0> rotate <0,0,-head_rise> translate <-.5,0,0> rotate <0,0,head_dip> translate <.5,0,0> }
    object { fish_body (.95) rotate <0,s1_a,0> }    
    
    //object { tail_upper scale <.5,.6,.35> translate <-.2,.1,0> rotate <0,0,-15> rotate <110,0,0> rotate <0,s1_a,0> }
    //object { tail_upper scale <.5,.6,.35> translate <-.2,.1,0> rotate <0,0,-15> rotate <-110,0,0> rotate <0,s1_a,0> }
    object { fish_fin_v scale .1 rotate <0,rf_downplane,0> rotate <110+rf_down,rf_back,0> translate <.2,0,.65> rotate <0,s1_a,0> }
    object { fish_fin_v scale .1 rotate <0,-lf_downplane,0> rotate <-110-lf_down,-lf_back,0> translate <.2,0,-.65> rotate <0,s1_a,0> }
            
    object { fish_body (.95*pow(.85,1)) rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_v scale <.1,.15,.1> rotate <0,0,-15> translate <.25,.4,0> scale (pow(.85,1)) rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_body (.95*pow(.85,2)) rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_body (.95*pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_v scale .1 rotate <0,0,-15> rotate <110,0,0> translate <.2,0,.65> scale (pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_v scale .1 rotate <0,0,-15> rotate <-110,0,0> translate <.2,0,-.65> scale (pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_body (.95*pow(.85,4)) rotate <0,s5_a,0> translate <.5,0,0> rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
                       
    object { fish_tail (.95*pow(.85,5)) rotate <0,s6_a,0> translate <.5,0,0> rotate <0,s5_a,0> translate <.5,0,0> rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    rotate <0,-(s4_a)/2,0>      //      counter moment of action in tail,
    translate <0,0,s3_a/160>    //      a case of the tail wagging the fish.
    scale 2.5          
    //translate <0,0,-s6_a/200>
    //translate <0,0,-sin(f_clock*pi*2)*.25>
  }

#declare fish_bones=
union {
    object { fish_skull rotate <head_tilt_right,0,0> rotate <0,0,-head_rise> translate <-.5,0,0> rotate <0,0,head_dip> translate <.5,0,0> }
    object { fish_rib_seg (.95) rotate <0,s1_a,0> }    
    
    //object { tail_upper scale <.5,.6,.35> translate <-.2,.1,0> rotate <0,0,-15> rotate <110,0,0> rotate <0,s1_a,0> }
    //object { tail_upper scale <.5,.6,.35> translate <-.2,.1,0> rotate <0,0,-15> rotate <-110,0,0> rotate <0,s1_a,0> }
    object { fish_fin_b scale .1 rotate <0,rf_downplane,0> rotate <110+rf_down,rf_back,0> translate <.2,0,.65> rotate <0,s1_a,0> }
    object { fish_fin_b scale .1 rotate <0,-lf_downplane,0> rotate <-110-lf_down,-lf_back,0> translate <.2,0,-.65> rotate <0,s1_a,0> }
            
    object { fish_rib_seg (.95*pow(.85,1)) rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_b scale <.1,.15,.1> rotate <0,0,-15> translate <.25,.4,0> scale (pow(.85,1)) rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_rib_seg (.95*pow(.85,2)) rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_rib_seg (.95*pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_b scale .1 rotate <0,0,-15> rotate <110,0,0> translate <.2,0,.65> scale (pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    object { fish_fin_b scale .1 rotate <0,0,-15> rotate <-110,0,0> translate <.2,0,-.65> scale (pow(.85,3)) rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    object { fish_rib_seg (.95*pow(.85,4)) rotate <0,s5_a,0> translate <.5,0,0> rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
                       
    object { bone_tail (.95*pow(.85,5)) rotate <0,s6_a,0> translate <.5,0,0> rotate <0,s5_a,0> translate <.5,0,0> rotate <0,s4_a,0> translate <.5,0,0> rotate <0,s3_a,0> translate <.5,0,0> rotate <0,s2_a,0> translate <.5,0,0> rotate <0,s1_a,0> }
    
    rotate <0,-(s4_a)/2,0>      //      counter moment of action in tail,
    translate <0,0,s3_a/160>    //      a case of the tail wagging the fish.
    scale 2.5          
    //translate <0,0,-s6_a/200>
    //translate <0,0,-sin(f_clock*pi*2)*.25>
  }

#declare goldfish=          
object { 
#if (shock=on)
  fish_bones
#else
  fish        
#end
  translate < 2.5,3,1>  
  rotate <0,-45,0>
  //translate <-2,3,0>
}


