// POV-Ray 2.0 sample data file written by Alexander Enzmann
#include "colors.inc"           // Standard colors library
#include "shapes.inc"           // Commonly used object shapes
#include "textures.inc"         // LOTS of neat textures.  Lots of NEW textures.
#include "stones.inc"

global_settings {
  max_intersections 200
}
#declare AMB=.2;

//#include "flight_macros.inc"
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end                          
#macro move_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock,default_val)
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock < start_clock )
    ( default_val )
  #end
  #if ( current_clock > end_clock )
    ( default_val )
  #end
  #if ( ( current_clock >= start_clock ) & ( current_clock <= end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end

#declare second=clock;
#declare scene_clock=clock;
#while (scene_clock>1)
  #declare scene_clock=scene_clock-1;
#end

#declare ufo_cam_pos=<0,6,-11.5>; 
//#declare ufo_lamp_slide=<0,0,0>;
#declare ufo_lamp_switch=0;

#declare head_rise=0
#declare f_clock=0;                                                          
 #declare fish_mouth=0;
 #declare shock=on;
 #declare eyelid=1;  
 #declare iris=1;
 #declare eye_down=0;
 #declare eye_right=0;
 #declare head_dip=0;
 #declare head_tilt_right=0;
 #declare sympathy_twist=0; 
 #declare blind_upperbreak=0;
 #declare blind_lowerbreak=0;
 #declare swim_power=0;
 #declare view=1;
 #declare fish_pos=<0,5.25,-3.75>;
 #declare fish_elevation=0;

#declare rf_downplane=0;        // right fin downplane angle (sub-talk)
#declare lf_downplane=0;        // left fin downplane angle 
#declare rf_down=0;             // right fin 
#declare lf_down=0;             // left fin 
#declare rf_back=10;             // right fin rearward angle (swingwing) typ -10 to +20
#declare lf_back=10;             // left fin rearward angle (swingwing) typ -10 to +20


#declare ufo_cam_pos=<0,6,-9.5>;// and reset position to re-run these frames from in ufo camera
#declare ufo_lamp_switch=1;
#declare ufo_lamp_slide=.4;

#declare head_dip=5;     
#declare fish_elevation=25;
#declare eye_down=15;

camera {
   //location  <23,15, -22>
   location <-10,6,-6>
   direction <0, 0, 1.45>
   up <0,1,0>
   right <4/3,0,0>
   //look_at   <23, 15, -9>
   look_at <0,5,-5> //<0,3,-2>
}

#declare tank_type=1;

light_source { <-10, 15, -7> color rgb<.5,.5,.5> }       //      dev- room light
light_source { <54.5,26,-25> color rgb<.6,.6,.4> }    //      sodium (street lamp)

#render "\n"
#include "room.inc"
object { room }                   

#declare weed_clock=-clock*360/4;
#include "fishbowl.inc"
object { fishbowl }

#include "goldfish.inc"
object { fish 
  scale .3
  rotate <0,-90,0> 
  rotate <fish_elevation,0,0> 
  translate (fish_pos)
}


#declare ufo_clock=24.4/4;
#include "ufo.inc"
object { ufo translate (ufo_cam_pos) }      

box { <100,-1000,-1000>,<101,1000,1000> texture { pigment { color rgb<.15,.15,.3> } finish { ambient 1 diffuse 0 } } }

#render concat( "Overall Scene clock value currently at " , str(clock,-1,5) , " seconds\n" )
