#declare b_angle=15;
#declare r_wall=box { <-21,-11,0>,<21,21,8> }
#declare batten=box { <-1,-1,-1>,<1,1,1> translate <0,0,4> }      
#declare r_window=
  union {
    union {
      object { batten scale <9.5,.5,.4> translate <9,17.25,.4> }
      object { batten scale <9.5,.5,.4> translate <9,12.75,.4> }
      object { batten scale <.5,2.5,.4> translate <0,15,.4> }
      object { batten scale <.5,2.5,.4> translate <18,15,.4> }
      translate <0,-19,0>
      rotate <-45,0,0>
      translate <0,19,27>
    }
    object { batten scale <11,1,1> translate <9,0,24> }
    object { batten scale <10.5,.5,1> translate <9,12.5,24> }
    object { batten scale <11,1,1> translate <9,18,24> }
    object { batten scale <1,17,1> translate <-1,0,24> }
    object { batten scale <1,17,1> translate <19,0,24> }
    texture { 
      pigment { 
        color rgb<1,1,1>
      }
      finish {
        ambient AMB
        diffuse .6
        roughness .1 
        specular 0.05
      }
    }
  }  
  
#declare r_blind=
  difference {
    cylinder { <-.8,0,2>,<18.8,0,2>,2 }
    cylinder { <-1,-1,2>,<19,-1,2>,2.9 }
      
    cylinder { <1,-1,2>,<1,20,2>,.2 }
    cylinder { <4.5,-1,2>,<4.5,20,2>,.2 }
    cylinder { <13.5,-1,2>,<13.5,20,2>,.2 }
    cylinder { <17,-1,2>,<17,20,2>,.2 }
    translate <0,-2,0>
    rotate <-b_angle,0,0>
    translate <0,0,21>
  }

#declare r_blind_shadow=
  /*difference {
    cylinder { <-.79,0,2>,<18.79,0,2>,1.99 }
    cylinder { <-1,-1,2>,<19,-1,2>,2.91 }
    translate <0,-2,0>*/
  object {
    box { <-.79,.0,-.8>,<18.79,.01,.8> translate <0,-.28,2> }
    rotate <-b_angle,0,0>
    translate <0,0,21>
  }

#declare r_blinds=
  union {
    #declare blind_y=18;
    #declare b_count=0;
    #while (blind_y>=0)
      #declare b_count=b_count+1;
      #if (b_count=5)
        union {
          intersection { 
            object { r_blind } 
            box { <-2,-2,19>,<9,2,25> }
            matrix < 1,blind_upperbreak/10,0,
                     0,1,0,
                     0,0,1,
                     0,0,0 >
          }
          intersection { 
            object { r_blind } 
            box { <-2,-2,19>,<9,2,25> }
            matrix < 1,blind_upperbreak/10,0,
                     0,1,0,
                     0,0,1,
                     0,0,0 >   
            translate <-9,0,0>
            scale <-1,1,1>
            translate <9,0,0>                     
          }
          translate <0,blind_y,0>
        }
      #else                                       
        #if (b_count=6)
          union {
            intersection { 
              object { r_blind } 
              box { <-2,-2,19>,<9,2,25> }
              matrix < 1,-blind_lowerbreak/10,0,
                       0,1,0,
                       0,0,1,
                       0,0,0 >
            }
            intersection { 
              object { r_blind } 
              box { <-2,-2,19>,<9,2,25> }
              matrix < 1,-blind_lowerbreak/10,0,
                       0,1,0,
                       0,0,1,
                       0,0,0 >   
              translate <-9,0,0>
              scale <-1,1,1>
              translate <9,0,0>                     
            }
            translate <0,blind_y,0>
          }
        #else
          object { r_blind translate <0,blind_y,0> }        
        #end
      #end
      #declare blind_y=blind_y-.8;
    #end
    union {
      cylinder { <1,-1,2>,<1,20,2>,.05 }
      cylinder { <4.5,-1,2>,<4.5,20,2>,.05 }
      cylinder { <13.5,-1,2>,<13.5,20,2>,.05 }
      cylinder { <17,-1,2>,<17,20,2>,.05 }
      translate <0,-2,21>
      texture { 
        pigment { rgb<.1,.1,.1> }
        finish { ambient AMB } 
      }
    }
  }
#declare r_blinds_shadow=
  union {             
    #declare b_count=0;
    #declare blind_y=18;
    #while (blind_y>=0)
      #declare b_count=b_count+1;
      #if (b_count=5)
        union {
          intersection { 
            object { r_blind_shadow } 
            box { <-2,-2,19>,<9,2,25> }
            matrix < 1,blind_upperbreak/10,0,
                     0,1,0,
                     0,0,1,
                     0,0,0 >
          }
          intersection { 
            object { r_blind_shadow } 
            box { <-2,-2,19>,<9,2,25> }
            matrix < 1,blind_upperbreak/10,0,
                     0,1,0,
                     0,0,1,
                     0,0,0 >   
            translate <-9,0,0>
            scale <-1,1,1>
            translate <9,0,0>                     
          }
          translate <0,blind_y,0>
        }
      #else                                       
        #if (b_count=6)
          union {
            intersection { 
              object { r_blind_shadow } 
              box { <-2,-2,19>,<9,2,25> }
              matrix < 1,-blind_lowerbreak/10,0,
                       0,1,0,
                       0,0,1,
                       0,0,0 >
            }
            intersection { 
              object { r_blind_shadow } 
              box { <-2,-2,19>,<9,2,25> }
              matrix < 1,-blind_lowerbreak/10,0,
                       0,1,0,
                       0,0,1,
                       0,0,0 >   
              translate <-9,0,0>
              scale <-1,1,1>
              translate <9,0,0>                     
            }
            translate <0,blind_y,0>
          }
        #else
          object { r_blind_shadow translate <0,blind_y,0> }
        #end
      #end
      #declare blind_y=blind_y-.8;
    #end
    union {
      cylinder { <1,-1,2>,<1,20,2>,.04 }
      cylinder { <4.5,-1,2>,<4.5,20,2>,.04 }
      cylinder { <13.5,-1,2>,<13.5,20,2>,.04 }
      cylinder { <17,-1,2>,<17,20,2>,.04 }
      translate <0,-2,21>
    }
    texture { 
      pigment { color rgbt<.6,.74,.62,.6> }
      finish {
        ambient AMB
        diffuse .6
        roughness 0.9
        specular 0.4
      }            
    }
  }
  
  
      
#declare r_walls=
  union {
    difference {
      object { r_wall }
      box { <-1,0,-2>,<19,18,20> }
      translate <0,0,20>
      texture { 
      pigment {
        color red 0.439216 green 0.858824 blue 0.858824
      }
      finish {
        ambient AMB-.1
        diffuse .6
        roughness 0.1
        specular 0.05
      }
      }
    } 
    object { r_wall rotate <0,90,0> translate <20,0,0> } 
    object { r_wall rotate <0,-90,0> translate <-6,0,0> }
    object { r_wall rotate <0,180,0> translate <0,0,-20> }
    texture { 
      pigment {
        color red 0.439216 green 0.858824 blue 0.858824
      }
      finish {
        ambient AMB
        diffuse .6
        roughness 0.1
        specular 0.05
      }
    }
  }           

#declare r_floor=
  object {
    box { <-20,-1,-20>,<20,0,20> }
    translate <0,-10,0>
    texture {
      pigment {
        color rgb<.4,.2,.2>
      }
      finish {
        ambient AMB
      }
    }
  }
  
#declare r_celing=
  object {
    box { <-20,0,-20>,<20,1,20> }
    translate <0,20,0>
    texture {
      pigment {
        color rgb<1,1,1>
      }
      finish {
        ambient AMB
      }
    }
  }

#declare r_room_vis=
union {  
    object { r_window }
    object { r_walls }
    object { r_floor }
    object { r_celing }
    object { r_blinds_shadow }  // semi-transparent
  }

#declare r_light_mask=
  object { r_blinds
    texture { 
      pigment { color rgb<.6,.74,.62> }
      finish {
        ambient AMB
        diffuse .6
        roughness 0.9
        specular 0.4
      }            
    }
    no_shadow
  }
  
#declare r_room=                                       
  union {
    object { r_room_vis }
    object { r_light_mask }
    rotate < 0,90,0 >
  }

#declare shelf =               
  union {
    box { <-10,0,-4.5>,<10,-1,10> }
    box { <-9,-9,-3>,<9,-1,9> }
    texture {
      pigment {
        color rgb<1,1,1>
      }
      finish { ambient AMB }
    }
  }
  
#declare room=
union {
  object { r_room }
  object { shelf }
}