/*	gfx.c  -  c portion of the gfx unit.  */

//	(C) 1996, 1999 Michael Devine

#include "gfx.h"
#include <dos.h>



void initltables(word xs)
{
	int i;

	xs = xs / 64;

	for (i=0; i<800; i++)
		lseg[i] = 0xa000 + i * xs;

	xs = xs * 16;

	for (i=0; i<800; i++)
		lofs[i] = i * xs;
}



void setmode3()
{
	sync();
	asm {
		mov	ax, 00003h
		int	10h
	}
}

byte far *scnbuf;
word far *wscnbuf;
word ylu[200];
void setmode13()
{
	int y;

	scnbuf = (byte far *)MK_FP(0xa000, 0);
	wscnbuf = (word far *)MK_FP(0xa000, 0);

	for (y=0;  y<200;  y++)
		ylu[y]=y*320;


	sync();
	asm {
		mov	ax, 00013h
		int	10h
	}
}
void clrscn()
{
	asm {
		mov	ax, 0a000h
		mov	es, ax

	db 0x66;xor	ax, ax
		xor	di, di
		mov	cx, 04000h
	db 0x66;rep	stosw

	}
}

// Now specialized for the sopwith ripoff game...
void setmodex()
{
	sync();
	asm {
		mov	ax, 00013h
		int	10h
	}
	sync();         /*  <- extra nice  */
	asm {

		/*  The following gets into unchained byte mode the nasty
		    way... previous reg vals are assumed.  Which should be
		    ok, given that we've just called int 10h, fn 0.  */

		mov	dx, 03c2h
		mov	al, 0e3h	/*  Sync polarity (480 lines)  */
		out	dx, al

		mov	dx, 03c4h	/*  Gfx ctrl'r...  */
		mov	ax, 00604h	/*  Mem mode  -  unchain  */
		out	dx, ax

		mov	ax, 00f02h	/*  all planes  */
		out	dx, ax

		mov	ax, 00604h	// Some 240 line thing.
		out	dx, ax


		mov	ax, 0a000h
		mov	es, ax
	db 0x66;xor	ax, ax
		xor	di, di
		mov	cx, 04000h
	db 0x66;rep	stosw

		mov	dx, 03d4h	/*  sequencer...  */
		mov	ax, 00014h	/*  Dword mode off  */
		out	dx, ax

		mov	ax, 0e317h	/*  byte mode on  */
		out	dx, ax

		// 240 lines stuff...
		mov	ax, 02c11h
		out	dx, ax

		mov	ax, 00d06h
		out	dx, ax
		mov	ax, 03e07h
		out	dx, ax
		mov	ax, 0ea10h
		out	dx, ax
		mov	ax, 0ac11h
		out	dx, ax
		mov	ax, 0df12h
		out	dx, ax
		mov	ax, 02f13h		// 2f=47 * 8 = 376 pixels, logical screen width
		out	dx, ax
		mov	ax, 00014h
		out	dx, ax
		mov	ax, 0e715h
		out	dx, ax
		mov	ax, 00616h
		out	dx, ax


//		mov	ax, 04009h	/*  repeat lines 0x  */
//		out	dx, ax



	// Now the LCR...
	// xxx LCR val = 240-32 = 208 = 128 + 64 + 16 = 11010000 = D0h
	// Oops!  208*2 = 416 = 256 + 128 + 32 = 1 10100000 = 1A0h + 1 (even?)
	// Here we'll use 100h since there are 400 lines, not 480.
//	asm {				// try to set LCR
		mov	dx, 0x3d4

		mov	al, 0x09	// bit d9
		out	dx, al
		inc	dx
		in	al, dx
		and	al, 0xBF	// clear bit 6
		out	dx, al

		dec	dx
		mov	al, 0x07	// bit d8
		out	dx, al
		inc	dx
		in	al, dx
		or	al, 0x10	// set bit 4
		out	dx, al

		dec	dx
		mov	ax, 0x9f18
		out	dx, ax
	}



	// Enhanced LCR... (no pan)
	asm {
		mov	dx, 0x3da		// Reset Attrib Ctrlr
		in	al, dx

		mov	dx, 0x3c0
		in	al, dx
		and	al, 0xE0
		or	al, 0x10		// H byte pan...
		out	dx, al

/*		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
*/

//		in	al, dx
//		or	al, 020h
//			    011r???1
		mov	al, 01100001b
		out	dx, al

	}
}
