//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/**********************************/
/*** Avion qui arrive sur l'ile ***/
/**********************************/

#include "colors.inc"
#include "skies.inc"

#include "ile_ar.inc"

#declare ClA=ppcl;

/*** Dfinition de la scne ***/
/******************************/
camera {
	location <-1200+ClA*1800,500,-1200>
	look_at <0,0,0>
}

light_source { <15000,33000,-10000> White }

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2
}

/*** Dfinition des objets ***/
/*****************************/

object { Ile }

/*** Fait l'ecran Noir au dbut ***/
/**********************************/
#if(ClA<0.1)
	box { <-1500,0,-1199> <1500,700,-1198>
		pigment { color White filter (ClA/0.1) }
		finish { specular 0 diffuse 0 ambient 0 }
	}
#end

/*** Fait l'arriv de l'avion ***/
/********************************/
#declare cloF=ClA*2;		// clock pour mouvement des reacteurs
#declare D_Missile = 150;	// Distance de fin du Missil
#declare C_Missile = 0; 	// Clock du missil pour arriver  D_Missil

#if(ClA<=0.6)
	#declare Aileron = 0.0;		// Angle des l'aileron +=Gauche (entre -1 et 1)
	#declare ADerive = 0.0; 	// Angle de la drive +=Haut (entre -1 et 1)
	#declare PReacteur = 0.3;	// Puissance du reacteur (0  1)

	#declare Px=-1205+ClA*1850;
	#declare Py=(ClA/0.6)*5+491;
	#declare Pz=-1190;

	#include "avion.inc"

	object { Avion
		rotate z*(sin(ClA*2*pi*5)*3) // Fait tanguer
		rotate y*-90
		translate <Px,Py,Pz>
	}

/*** Fait l'avion qui tourne ***/
/*******************************/
#else
	#declare ClL=(ClA-0.6)/0.4;

	#declare Aileron = 0.5;		// Angle des l'aileron +=Gauche (entre -1 et 1)
	#declare ADerive = -0.4; 	// Angle de la drive +=Haut (entre -1 et 1)
	#declare PReacteur = 0.5+ClL*ClL*0.5;	// Puissance du reacteur (0  1)

	#declare Px=-95+ClL*740-ClL*ClL*80;
	#declare Py=496-ClL*ClL*ClL*130;
	#declare Pz=-1190+300*ClL*ClL;

	#include "avion.inc"

	object { Avion
		rotate z*(sin(ClA*2*pi*5)*3) // Fait tanguer
		rotate y*-90
		rotate x*( sin(ClL*pi*0.8)*55 )
		rotate y*( (cos(ClL*0.75*pi)-1)/2*75 )
		translate <Px,Py,Pz>
	}
#end
