//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/****************************************/
/*** Dfinition de l'avion de chasse ***/
/***************************************/

#include "colors.inc"
#include "metals.inc"

#declare FontA="crystal.ttf"

/*** Dfinition des Variables ***/
/********************************/

//#declare Aileron = -0.49;	// Angle des l'aileron +=Gauche (entre -1 et 1)
//#declare ADerive = 0.4; 	// Angle de la drive +=Haut (entre -1 et 1)
//#declare PReacteur = 0.3;	// Puissance du reacteur (0  1)
//#declare D_Missile = 150;	// Distance de fin du Missil
//#declare C_Missile = 0.1; 	// Clock du missil pour arriver  D_Missil

//#declare cloF=clock*2;	// clock pour mouvement des reacteurs

/*** Dfinition des Textures ***/
/*******************************/

#local CCamou1= rgb <218/255,244/255,254/255>;
#local CCamou2= rgb <81/255,157/255,204/255>;

#local CM_Flamme = color_map {
		[0.0 rgb <0,0,0>]
		[0.61 rgb <239/255,239/255,0>]
		[1.0 rgb <244/255,65/255,4/255>]
}

#declare T_Metal_Avion = texture {
	pigment {
		bozo
		color_map { [ 0.0 CCamou1 ] [ 0.5 CCamou2 ] }
		turbulence 0.2
		scale 10
	}
	finish {
		metallic
		diffuse 0.6
		specular 0.5
		reflection 0.1
	}
}

#declare T_AntenneA = texture { T_Chrome_3B }

#declare T_CoPi = texture {
	pigment { color White*0.9
		filter 0.95
	}
	finish {
		specular 0.99
		diffuse 0.89
		reflection 0.6
	}
}

#declare T_Commande = texture {
	pigment { color Black }
	finish { specular 0.01
		diffuse 0.1
	}
}

#declare T_Text = texture {
	pigment { Black }
	finish { metallic
		diffuse 0.6
		specular 0.5
		reflection 0.1
	}
}

#declare T_Mi_Aile = texture { T_Chrome_4C }

#declare T_Flamme = texture { pigment { color rgbt 1 } }	

#declare T_Logo = texture {
	pigment { image_map { ppm "logo.ppm" }
		rotate y*90
		scale 2
	}
	finish { diffuse 0.8
		specular 0.45
		reflection 0.05
	}
}

#declare T_GBombe = texture { 
	pigment { color White }
	finish { metallic
		specular 0.3
		diffuse 0.95
		reflection 0.1
	}
}

#declare T_Glass_IR = texture {
	pigment { color Black filter 0.1 }
	finish { specular 0.9
		diffuse 0.6
		reflection 0.5
	}
}

/*** Dfinition des Objets ***/
/*****************************/

#declare Nez_Avion = union {
	cone {	<0,0,-35>,0.4 <0,0,-26>, 3.5 }
	cone {	<0,0,-26>,3.5 <0,0,-18>, 5.0 }
	cone {	<0,0,-18>,5.0 <0,0,0>, 7 }
	cylinder { <0,0,0> <0,0,85>, 7 }
	translate <0,0,35>
	texture { T_Metal_Avion }
}

#declare Haut_Avion = difference {
	object { Nez_Avion scale <1,0.8,1> }
	plane { y,-3 texture { T_Metal_Avion } }
}

#declare Dos_Haut = difference {
	cone {
		<0,4.5,31>,6 <0,4,95>,1
		texture { T_Metal_Avion }
	}
	plane { z,0 texture { T_Commande } rotate x*29 translate <0,0,38> }
} 

#declare AntenneAv = cone {
	<0,0,0>,0.4 <0,0,-8>,0
	texture { T_AntenneA }
}

#declare Commande = union {
	cone {
		<0,1,21>,1 <0,4.5,30>,3
		scale < 1.1,1,1>
		texture { T_Commande }
	}
	sphere {
		<0,6.5,35> 2.1
		texture { T_Commande }
	}
}

#declare CoPi = difference {
	sphere { <0,-14,39>,24
		texture { T_CoPi }
	}
	sphere { <0,-14,39>,23.9
		texture { T_CoPi }
	}
	plane { y, 3 texture { T_Metal_Avion } }
	interior { ior 1.51 }
	scale <0.32,1,1>
}

#declare Missile_B_Aile = union {
	cylinder { <0,0,0> <0,0,18> 0.9 texture { T_Mi_Aile } }
	sphere { <0,0,0> 0.9 scale <1,1,5> texture { T_Mi_Aile } }
	cone { <0,0,18>,0.9 <0,0,24.5>,0 texture { T_Mi_Aile } }
}

#declare Forme_Aile = difference {
	box { <0,0,0> <43,0.5,95> texture { T_Metal_Avion } }
	box { <0,-5,0> <50,5,-90> rotate y*13 translate <14,0,60>
		 texture { T_Metal_Avion } }
	box { <0,-5,0> <80,5,-85> rotate y*-41 translate <14,0,60>
		texture { T_Metal_Avion } }
	box { <11,-5,90> <38,5,100> texture { T_Metal_Avion } }
}

#declare Aileron_Aile = box {
	<11.2,0,0.2> <37.8,0.5,5> texture { T_Metal_Avion }
}

#declare Aile = union {
	object { Forme_Aile }
	object { Missile_B_Aile translate <43,0,78> }
}

#declare Queue_Forme = difference {
	box { <-0.20,0,82> <0.20,30,131> texture { T_Metal_Avion } }
	plane { z,0 inverse texture { T_Metal_Avion } rotate x*30 translate <0,0,115> }
	box { <-1,0,-70> <1,40,0> texture { T_Metal_Avion } rotate x*-20
		translate <0,12,99> }
	box { <-1,0,-70> <1,70,0> texture { T_Metal_Avion } rotate x*50
		translate <0,12,99> }
}

#declare Rond_Queue = difference {
	cylinder { <0,0,0> <0,0,-60>,2 texture { T_Metal_Avion } rotate y*5 }
	plane { x,0 pigment { color White } }
	translate <0,6.5,120>
}

#declare Queue = union {
	object { Queue_Forme }
	object { Rond_Queue }
	object { Rond_Queue scale <-1,1,1> }
}

#declare F_EAire = difference {
	difference {
		cylinder { <0,0,0> <0,0,40>,6 scale <1,0.9,1> texture { T_Metal_Avion } }
		plane { y,5.4/2-0.8 inverse texture { T_Metal_Avion } }
	}
	difference {
		cylinder { <0,0,-1> <0,0,41>,5.85 scale <1,0.9,1> texture { T_Metal_Avion } }
		plane { y,5.4/2-0.95 inverse texture { T_Metal_Avion } }
	}
}

#declare Moteur = union {
	cylinder { <0,0,0> <0,0,40> 6.8 }
	sphere { <0,0,0> 6.8 scale <1,1,1.5> }
	texture { T_Metal_Avion }
	rotate x*-3.8
	translate <0,-2.5,120-40>
}

#declare Reacteur = difference {
	cone { <0,0,0>,6.8 <0,0,8>,4
		texture { T_Chrome_4C }
	}
	cone { <0,0,-1>,6.5 <0,0,9>,3.1
		texture { T_Chrome_4C }
	}
	#local Nombre=18;
	#local Compt=0;
	#while(Compt<Nombre)
		cylinder { <0,0,0> <0,0,-9>,1 texture { T_Chrome_4C }
			rotate y*-23 translate <4.3,0,8.5>
			rotate z*(360/Nombre*Compt)
		}
		#local Compt=Compt+1;
	#end
}

#declare Derive = difference {
	box { <0,-0.05,0> <16,0.05,18> texture { T_Metal_Avion } }
	plane { z,0 rotate y*-40 texture { T_Metal_Avion } }
	translate <0,0,-4>
	rotate z*-18
	rotate x*-(ADerive*20)
	translate <6.8,0.6,130-18>
}

#declare Aileron1 = box {
	<0,-0.05,0> <10,0.05,11>
	texture { T_Metal_Avion }
	rotate y*-29
	rotate z*-50
	translate <4,-4,90>
}

#local CoR=4+PReacteur*30;
#declare FFlamme = sphere {
	<0,0,0> 4
	scale <1,1,CoR>
	texture { T_Flamme }
	hollow
	interior {
		media { emission 1
			density { spherical color_map { CM_Flamme } scale <4,4,CoR> }
			density { bozo poly_wave 0.25 color_map { CM_Flamme }
				phase cloF*1.76 scale <4,4,CoR> translate <0,0,60*cloF>
				turbulence 0.1
			}
			density { bozo poly_wave 0.31 color_map { CM_Flamme }
				phase cloF scale <4,4,CoR> translate <0,0,190*cloF>
				turbulence 0.1
			}
			density { bozo poly_wave 0.31 color_map { CM_Flamme }
				phase cloF*0.8 scale <4,4,CoR> translate <0,0,-200*cloF>
				turbulence 0.1
			}
		}
	}
}

#local IntLumiere=(PReacteur+sin(cloF*pi*4.764)/2);
#declare Lumiere_Reacteur = light_source {
	<0,0,0> color rgb <244/255,68/255,24/255>*IntLumiere
	shadowless
	fade_distance 30
	fade_power 2
}

#declare Flamme = union {
	object { FFlamme }
	object { Lumiere_Reacteur translate <0,0,PReacteur*11+5> }
}

#declare Texte_Avion = union {
	text { ttf FontA "DR",0.01,0
		rotate y*-90
		scale 8
		translate <0.201,18,4>
		texture  { T_Text }
	}
	text { ttf FontA "S99",0.01,0
		rotate y*-90
		scale 6
		translate <0.201,13,0>
		texture { T_Text }
	}
	text { ttf FontA "DR",0.01,0
		rotate y*90
		scale 8
		translate <-0.201,18,12>
		texture  { T_Text }
	}
	text { ttf FontA "S99",0.01,0
		rotate y*90
		scale 6
		translate <-0.201,13,8>
		texture { T_Text }
	}
}

#declare Logo1 = difference {
	cone {	<0,0,-18>,5.001 <0,0,0>, 7.001 texture { T_Logo translate <0,-0.5,0> } }
	plane { y,-0.5 texture { T_Metal_Avion } }
	plane { y,4-0.5 inverse texture { T_Metal_Avion } }
	plane { z,-14 texture { T_Metal_Avion } }
	plane { z,-10 inverse texture { T_Metal_Avion } }
	translate <0,0,35>
	scale <1,0.8,1>
}

#declare Logo2 = difference {
	cone {	<0,0,-18>,5.001 <0,0,0>, 7.001 texture { T_Logo translate <0,-0.5,0> } }
	plane { y,2-0.5 texture { T_Metal_Avion } }
	plane { y,4-0.5 inverse texture { T_Metal_Avion } }
	plane { z,-10 texture { T_Metal_Avion } }
	plane { z,-6 inverse texture { T_Metal_Avion } }
	translate <0,0,35>
	scale <1,0.8,1>
}

#declare Logo = union {
	object { Logo1 }
	object { Logo2 }
}

#declare P_Bombe = difference {
	box { <-0.1,-1.5,0> <0.1,3.5,20> }
	plane { z,0 rotate x*60 }
	plane { z,0 rotate x*-60 inverse translate <0,0,20> }
	translate <0,-3.5,0>
	texture { T_Metal_Avion }
}

#declare G_Bombe = union {
	difference { sphere { <0,0,0>, 3.5 scale <1,1,6.5> }
		plane { z,0 inverse }
	}
	cylinder { <0,0,0> <0,0,10>, 3.5 }
	sphere { <0,0,0>, 3.5 scale <1,1,2> translate <0,0,10> }
	texture { T_GBombe }
}

#declare Turb_Mystral = difference {
	cone { <0,0,0>,1.6 <0,0,3>,1.2 texture { T_Chrome_4C } }
	cylinder { <0,0,0.01> <0,0,4>,1.0 texture { T_Chrome_4C } }
	#local Nbre=12;
	#local Comp=0;
	#while(Comp<Nbre)
		cylinder { <0,0,0> <0,0,4>,0.4 texture { T_Chrome_4C }
			rotate y*-10 translate <2,0,0>
			rotate z*(360/Nbre*Comp)
		}
		#local Comp=Comp+1;
	#end
}

#declare Tete_Mystral = union {
	sphere { <0,0,0> 0.3 scale <1,1,4>
		translate <0,0,0.3*4>
		texture { T_Chrome_4C }
	}
	difference {
		box { <-1.6,-1.6,0> <1.6,1.6,6> }
		#local Nbre=16;
		#local Comp=0;
		#while(Comp<Nbre)
			plane { z,0 
				rotate x*75.06858282
				rotate z*(360/Nbre*Comp)
			}
			#local Comp=Comp+1;
		#end
		texture { T_Glass_IR }
	}
	cylinder { <0,0,5.9> <0,0,7>,1.621 texture { T_Chrome_4C } }
}

#declare Mystral = union {
	cylinder { <0,0,0> <0,0,25>, 1.6 texture { T_GBombe } }
	object { Turb_Mystral translate <0,0,25> }
	object { Tete_Mystral translate <0,0,-6> }
	box { <-3,0.05,8> <3,-0.05,11> texture { T_GBombe } }
}

#local PxM=28;
#local PyM=-1.6-6-sqrt(C_Missile)*D_Missile*0.1;
#local PzM=65-C_Missile*C_Missile*D_Missile;
#local MReacteur=sqrt(C_Missile)*10;
#if(MReacteur>1) #local MReacteur=1; #end

#local CoM=4+MReacteur*36;
#declare F_Mystral = sphere {
	<0,0,0> 1.2
	scale <1,1,CoM>
	texture { T_Flamme }
	hollow
	interior {
		media { emission 1
			density { spherical color_map { CM_Flamme } scale <4,4,CoM> }
			density { bozo poly_wave 0.25 color_map { CM_Flamme }
				phase cloF*1.76 scale <1,1,CoM> translate <0,0,60*cloF>
				turbulence 0.1
			}
			density { bozo poly_wave 0.31 color_map { CM_Flamme }
				phase cloF scale <1,1,CoM> translate <0,0,190*cloF>
				turbulence 0.1
			}
			density { bozo poly_wave 0.31 color_map { CM_Flamme }
				phase cloF*0.8 scale <1,1,CoM> translate <0,0,-200*cloF>
				turbulence 0.1
			}
		}
	}
}

#local MLumiere=(MReacteur+sin(cloF*pi*4.764)/2);
#declare Lumiere_Mystral = light_source {
	<0,0,0> color rgb <244/255,68/255,24/255>*MLumiere*0.8
	shadowless
	fade_distance 30
	fade_power 2
}

#if(MReacteur=0)
	#declare F_Mystral = object {
		object { Mystral }
	}
#else
	#declare F_Mystral = union {
		object { Mystral }
		object { F_Mystral translate <0,0,25> }
		object { Lumiere_Mystral translate <0,0,MReacteur*10+26> }
	}
#end

#declare Avion = union {
	object { Haut_Avion }
	object { AntenneAv }
	object { CoPi }
	object { Dos_Haut }
	object { Commande }
	object { Aile translate <0,-1,0> }
	object { Aile translate <0,-1,0> scale <-1,1,1> }
	object { Aileron_Aile rotate x*-(Aileron*30) translate <0,-1,90> }
	object { Aileron_Aile rotate x*(Aileron*30) translate <0,-1,90> scale <-1,1,1> }
	object { Queue }
	object { F_EAire scale <1,0.85,1> rotate x*-2 translate <0,-5.5,38> }
	object { Moteur }
	object { Reacteur translate <0,0,120> }
	object { Derive }
	object { Derive scale <-1,1,1> }
	object { Aileron1 }
	object { Aileron1 scale <-1,1,1> }
	object { Flamme translate <0,0,120> }
	object { Texte_Avion translate <0,0,110> }
	object { Logo }

	object { P_Bombe translate <15,-1,65> }
	object { P_Bombe translate <-15,-1,65> }
	object { G_Bombe translate <15,-3.5-6,75> }
	object { G_Bombe translate <-15,-3.5-6,75> }

	object { P_Bombe translate <28,-1,70> }
	object { P_Bombe translate <-28,-1,70> }
	object { F_Mystral translate <PxM,PyM,PzM> }
	object { Mystral translate <-28,-1.6-6,65> }
}
