//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/***********************************/
/*** Fait l'explosion du missile ***/
/***********************************/

#include "colors.inc"
#include "skies.inc"

#include "ile_ar.inc"

#declare cl1=ppcl;

/*** Dfinition de la scne ***/
/******************************/
camera {
	location <-430,10,-275>
	look_at <-220,70,-320>
}

light_source { <15000,33000,-10000> White }

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2
}

/*** Dfinition des textures ***/
/*******************************/

#declare DiaH=sin(cl1*pi*0.75)*180+0.0001;
#declare DiaL=sqrt(cl1)*280+0.0001;

#declare C_Blanc = rgb <1,1,1>;
#declare C_Jaune = rgb <252/255,252/255,184/255>;
#declare C_Aucre = rgb <232/255,196/255,80/255>;
#declare C_Marron = rgb <140/255,60/255,4/255>;
#declare C_Noir = rgb <0,0,0>;

#declare CM_Explose = color_map {
	[0.0 C_Noir]
	[0.3 C_Marron]
	[0.6 C_Aucre]
	[0.8 C_Jaune]
	[1.0 C_Blanc]
}

#declare T_Explose = texture {
	pigment { rgb 1 filter 1 }
	normal {
		bumps 0.7
		scale DiaL
		phase cl1*pi*2
	}
}


/*** Dfinition des objets ***/
/*****************************/

object { Ile }

#local PPou=<-220,84,-320>;

#if(cl1<0.2)
	#include "move_pou.inc"
	#include "poussin.inc"

	object { Poussin
		rotate y*90
		scale 2.0
		translate PPou
	}
#end

sphere { <0,0,0>,1
	scale <DiaL,DiaH,DiaL>
	texture { T_Explose }
	hollow
	interior {
		media { emission 0.08-cl1*0.07
			density { spherical color_map { CM_Explose }
				scale <DiaL,DiaH,DiaL>
				turbulence 0.2
			}
			density { bozo
				poly_wave 0.3
				color_map { CM_Explose }
				phase cl1*pi*2
				scale <DiaL,DiaH,DiaL>
				turbulence 0.15
			}
		}
	}
	rotate x*sin(cl1*pi*6)*6
	rotate y*cl1*50
	translate PPou
	translate <0,-DiaH/2,0>
}

light_source { PPou color C_Jaune*sin(cl1*pi*0.75)*(2-sin(cl1*pi*5))
	fade_distance 700
	fade_power 2
	jitter
	shadowless
	translate <0,DiaH/2,0>
}

/*** Fait l'cran noir  la fin ***/
#if(cl1>0.80)
	#local cl2=1-(cl1-0.80)/0.2;

	plane { z,0
		pigment { color White filter cl2 }
		finish { specular 0 diffuse 0 }
		rotate y*(90+45)
		translate <-420,0,-280>
	}
#end
