//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/******************************/
/*** Dfinition de la Marre ***/
/******************************/

#include "colors.inc"
#include "skies.inc"

#include "plantes.inc"

#declare CL_PO=ppcl;

/*** Dfinition des Mouvements ***/
/*********************************/

#local CP=2*pi;

#local C1=sin(CL_PO*6*CP)*2;
#local C2=sin((CL_PO+1)*5*CP)*1.5;
#local C3=sin((CL_PO+0.6)*3.8*CP)*0.9;
#local C4=cos((CL_PO+2.2)*7.2*CP)*1.8;
#local C5=sin((CL_PO+1.98)*2.9*CP)*3.5;
#local C6=cos((CL_PO+4)*6.3*CP)*2.35;

#local DecEx = -CL_PO*50;
#local DecEz = CL_PO*37;
#local DecEy = CL_PO*3;

/*** Dfinition de la scne ***/
/******************************/
camera {
	location <0,20,0>
	look_at <0,-10,50>
}

light_source { <150,330,-35> White
	fade_power 2
}

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2.5
}

/*** Dfinition des Textures ***/
/*******************************/

#declare T_Eau = texture {
	pigment { color White filter 0.95 }
	finish {
		reflection 0.9
		specular 0.99
		diffuse 0.99
	}
	normal {
		waves 0.1
		frequency 50
		scale <13,5.6,13>
		turbulence 0.15
	}
}

#declare C_FMarre = rgb <36/255,99/255,20/255>;
#declare C_CMarre = rgb <101/255,124/255,96/255>;
#declare C_Roche = rgb <130/255,130/255,142/255>;
#declare C_Gazon = rgb <47/255,119/255,21/255>;

#declare T_Marre = texture {
	pigment { marble
		color_map {
			[ 0.0 0.20 color C_FMarre color C_FMarre ]
			[ 0.20 0.25 color C_FMarre color C_CMarre ]
			[ 0.25 0.30 color C_CMarre color C_Roche ]
			[ 0.30 0.32 color C_Roche color C_Roche ] 
			[ 0.32 0.50 color C_Roche color C_Gazon ]
			[ 0.60 1.00 color C_Gazon color C_Gazon ]
		}
		turbulence 0.12
		rotate z*-90
		scale <1,1.4,1>
	}
	finish { specular 0.05
		diffuse 0.6
		roughness 0.995
		crand 0.26
		ambient 0.12
	}
	scale <10,50,10>
}

/*** Definition des Objets ***/
/*****************************/

#declare Marre = height_field {
	ppm "im_marre.ppm"
	smooth
	scale <300,50,300>
	texture { T_Marre }
	normal { bozo
		bump_size 3.8
		scale 2.5
		turbulence 0.35
		rotate x*30
		rotate z*12
	}

	translate <-160,-20,-155>
	rotate y*12
}

#declare Eau = plane {
	y,0
	texture { T_Eau translate <DecEx,DecEy,DecEz> }
	interior { ior 1.45
		fade_distance 60
		fade_power 1
	}
	translate <140,0,-110>
}

/*** Dfinition de la scne ***/
/******************************/

object { Marre }
object { Eau }
object { Nenuphare scale 1.4 translate <-12,0,37> }

// Arriere Plan
object { FleurR scale 1 translate <0,11,0>
	rotate x*(-15-C1) rotate y*(-30+C3) translate <-18,-2,75> }
object { FleurR scale 1.1 translate <0,9.9,0>
	rotate x*(-20+C5) rotate y*(35+C2) translate <-23,-2,72> }
object { FleurB scale 1.1 translate <0,8.5,0>
	rotate x*(-35-C6) rotate y*(15-C4) translate <-21,-2,66> }
object { FleurJ scale 1.0 translate <0,18,0>
	rotate x*(-45+C3) rotate y*(-40+C1) translate <-42,-2,71> }

// Premier Plan
object { Papier_Russe scale 0.50 translate <0,18,0>
	rotate x*(25+C2) rotate y*(69+C1) translate <-15,0,10> }
object { Papier_Russe scale 0.35 translate <0,14.5,0>
	rotate x*(40+C4) rotate y*(85+C3) translate <-17.5,0,12> }
object { Papier_Russe scale 0.42 translate <0,9.6,0>
	 rotate x*(50+C5) rotate y*(55+C6) translate <-16.6,0,19> }
object { FleurR scale 0.8 translate <0,6.5,0>
	 rotate z*(-16-C3) rotate x*(8+C4) translate <-6,-2,10> }

// Deuxieme Plan
object { FleurR scale 0.8 translate <0,10.5,0>
	 rotate z*(16+C2) rotate x*-8 translate <23,-4,37> }
object { FleurJ scale 0.85 translate <0,12.5,0>
	 rotate z*(32+C1) rotate x*-15 translate <22,-4,34> }
object { FleurB scale 0.65 translate <0,7.5,0>
	 rotate z*(-10+C5) rotate x*-10 translate <22,-4,35> }
object { FleurJ scale 0.9 translate <0,11.5,0>
	 rotate z*(-6+C6) rotate x*15 translate <26,-4,38> }
object { FleurR scale 0.76 translate <0,9.5,0>
	 rotate z*(7+C3) rotate x*-17.6 translate <22,-4,32> }

/*** Dfinition du Mouvement du Papillon ***/
/*******************************************/

#local F_Ar=0.2;
#local F_Pause=0.7;

#local PPapi=<-11,0.3,38.5>;
#local RPapi=<0,-180-6,0>;

/*** Fait l'arriv du Papillon ***/
#if(CL_PO<F_Ar)
	#declare clp=(1-CL_PO/F_Ar);
	#declare P_Aile=(clp*12);

	#include "papillon.inc"

	object { Papillon
		rotate RPapi
		rotate <0,sin(clp*4*CP)*5,0>
		translate PPapi
		translate <clp*36+sin(clp*CP*3)*-2.5,clp*15+sin(clp*CP*2),
			(cos(clp*pi/2)-1)*9>
	}
#end

/*** Fait la pose du Papillon ***/
#if(CL_PO>=F_Ar)
#if(CL_PO<=F_Pause)
	#declare clp=(CL_PO-F_Ar)/(F_Pause-F_Ar);
	#declare P_Aile=clp/4;

	#include "papillon.inc"

	object { Papillon
		rotate RPapi
		translate PPapi
	}
#end
#end

/*** Fait le depart du Papillon ***/
#if(CL_PO>F_Pause)
	#declare clp=(CL_PO-F_Pause)/(1-F_Pause);
	#declare P_Aile=(clp*12);

	#include "papillon.inc"

	object { Papillon
		rotate RPapi
		rotate <0,sqrt(clp)*180+sin(clp*2*CP)*2,0>
		translate PPapi
		translate <clp*25+sin(clp*CP*2)*-1.1,clp*7+sin(clp*CP*1)*1.8,
			(cos(clp*pi/2)-1)*50>
	}
#end

/*** Dfinit le mouvement du Poussin ***/
/***************************************/

#include "move_pou.inc"

#local TPous=<9,0,41>;
#local RPous=<0,60,0>;

#local TanguePoussin = sin(CL_PO*CP*6)*3.6;

#local FP_Ar=0.45;
#local FP_Et=0.55;
#local FP_Resp=0.62;
#local FP_Souffle=0.7;
#local FP_Regarde=0.85;

/*** Fait l'arrive du Papillon ***/
#if(CL_PO<FP_Ar)
	#declare clpo=(1-CL_PO/FP_Ar);
	Agite_Aile(clpo*3)
	Marche(clpo*3)

	#declare DistanceFixe=600*clpo*clpo+200;
	#declare TeteAngleX=-sin(clpo*2*pi)*25;
	#declare TeteAngleY=-sin(clpo*1.54*pi)*28;
	#declare AngleCoup=sin(clpo*pi)*15;

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		rotate <0,sqrt(clpo)*-25,0>

		translate TPous
		translate <(clpo*clpo*clpo)*60,sin(clpo*CP*2)*0.2,(clpo*clpo)*48>
	}
#end

/*** Fait l'etonnement du Poussin ***/
#if(CL_PO<FP_Et)
#if(CL_PO>=FP_Ar)
	#declare clpo=(CL_PO-FP_Ar)/(FP_Et-FP_Ar);

	#declare OuverturePaupiere=0.8;
	#declare Ouverture_Bec=(1-cos(clpo*pi))*0.4;
	#declare DistanceFixe=200;
	#declare TeteAngleX=clpo*clpo*-5;
	#declare TeteAngleY=clpo*clpo*-8;
	#declare AngleCoup=-1+sin(clpo*pi/2)*36;
	#declare FixeAngleY=-30+clpo*clpo*20;

	#if(clpo>=0)
	#if(clpo<=0.125)
		ClinYeux(clpo*4,0.8)
	#end
	#end

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		translate TPous
	}
#end
#end

/*** Fait le Poussin qui inspire ***/
#if(CL_PO<FP_Resp)
#if(CL_PO>=FP_Et)
	#declare clpo=(CL_PO-FP_Et)/(FP_Resp-FP_Et);

	#declare OuverturePaupiere=0.8;
	#declare Ouverture_Bec=0.4+sin(clpo*pi)*0.6;
	#declare DistanceFixe=200;
	#declare TeteAngleX=-5;
	#declare TeteAngleY=-8-clpo*clpo*5;
	#declare AngleCoup=35+(cos(clpo*pi)-1)/2*47;
	#declare FixeAngleY=-10-clpo*clpo*20;

	Agite_Aile(clpo/2)

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		translate TPous
	}
#end
#end

/*** Fait le Poussin qui souffle ***/
#if(CL_PO<FP_Souffle)
#if(CL_PO>=FP_Resp)
	#declare clpo=(CL_PO-FP_Resp)/(FP_Souffle-FP_Resp);

	#declare OuverturePaupiere=0.8;
	#declare Ouverture_Bec=0.1/(clpo+0.1);
	#declare DistanceFixe=200;
	#declare TeteAngleX=-5;
	#declare TeteAngleY=-13+clpo*clpo*5;
	#declare AngleCoup=-12+sin(clpo*pi/2)*45;
	#declare FixeAngleY=-30+clpo*clpo*20;
	#declare Grosseur_Joues=cos(clpo*pi)*0.5+0.5;

	Agite_Aile(clpo/2+0.5)

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		translate TPous
	}
#end
#end

/*** Fait le Poussin qui Regarde ***/
#if(CL_PO<FP_Regarde)
#if(CL_PO>=FP_Souffle)
	#declare clpo=(CL_PO-FP_Souffle)/(FP_Regarde-FP_Souffle);

	#declare OuverturePaupiere=clpo*0.1+0.8;
	#declare Ouverture_Bec=sin(clpo*pi)*0.8+0.1;
	#declare DistanceFixe=200+clpo*50;
	#declare TeteAngleX=-5-clpo*clpo*40;
	#declare TeteAngleY=-8+clpo*clpo*10;
	#declare AngleCoup=33+(cos(clpo*pi)-1)/2*43;
	#declare FixeAngleY=-10+clpo*clpo*10;
	#declare Grosseur_Joues=0.5+clpo*clpo*0.4;

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		translate TPous
	}
#end
#end

/*** Fait le Poussin qui Suit ***/
#if(CL_PO>=FP_Regarde)
	#declare clpo=(CL_PO-FP_Regarde)/(1-FP_Regarde);

	#declare OuverturePaupiere=0.8-sin(clpo*pi)*0.15;
	#declare DistanceFixe=250+clpo*100;
	#declare TeteAngleX=-45+sqrt(clpo)*40;
	#declare TeteAngleY=2+clpo*clpo*5;
	#declare AngleCoup=-10+(sin(clpo*2*pi*3)/2+0.5)*40;
	#declare FixeAngleY=clpo*clpo*3;
	#declare Grosseur_Joues=cos(clpo*2*pi*3)/2+0.5;
	#declare Ouverture_Bec=cos(clpo*pi*2.5*3)/2+0.5;

	Bas_Aile(clpo*3)
	Marche(clpo*3)

	#include "poussin.inc"

	object { Poussin
		translate <0,-0.4,0>
		scale 2		
		rotate <0,0,TanguePoussin>
		rotate RPous
		rotate <0,-sqrt(clpo)*70,0>
		translate TPous
		translate <((clpo-0.4)*(clpo-0.4)-(0.4*0.4))*10,sin(clpo*2*pi*3)*0.6,
			-clpo*clpo*25>
	}
#end
