//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/**********************************************/
/*** Dfinition de la Marre avec le panneau ***/
/**********************************************/

#include "colors.inc"
#include "skies.inc"
#include "divers.inc"

#include "plantes.inc"

#declare CL_MA=ppcl;

/*** Dfinition des Mouvements ***/
/*********************************/

#local CP=2*pi;

#local C1=sin(CL_MA*6*CP)*2;
#local C2=sin((CL_MA+1)*5*CP)*1.5;
#local C3=sin((CL_MA+0.6)*3.8*CP)*0.9;
#local C4=cos((CL_MA+2.2)*7.2*CP)*1.8;
#local C5=sin((CL_MA+1.98)*2.9*CP)*3.5;
#local C6=cos((CL_MA+4)*6.3*CP)*2.35;

#local DecEx = -CL_MA*50;
#local DecEz = CL_MA*37;
#local DecEy = CL_MA*3;

#local FDeplace = 0.6;

/*** Dfinition de la scne ***/
/******************************/

#local dxfoc=-7;
#local dyfoc=0.8;
#local dzfoc=38.5;

#if(CL_MA>=FDeplace)
	#local clo=(CL_MA-FDeplace)/(1-FDeplace);
	
	#local xfoc=dxfoc+(-80-dxfoc)*clo*clo;
	#local yfoc=dyfoc+(15-dyfoc)*clo*clo;
	#local zfoc=dzfoc+(30-dzfoc)*clo*clo;

	camera {
		location <5,4,35>
		look_at <-45,0,40>

		#if(clo<0.9)
			aperture (2.5-clo*clo*3.08619753)
			focal_point <xfoc,yfoc,zfoc>
			blur_samples 20
			confidence 0.975
			variance 1/200
		#end
	}
#else
	#local clo=CL_MA/FDeplace;
	camera {
		location< (cos(clo*pi)-1)*-2.5 , 20+(cos(clo*pi)-1)*8 ,
				(cos(clo*pi)-1)*-35/2 > 
		look_at< clo*-45 , -10+clo*clo*10 , 50-clo*10 >

		aperture (2.5*sqrt(clo))
		focal_point <dxfoc,dyfoc,dzfoc>
		blur_samples 20
		confidence 0.975
		variance 1/200
	}
#end

light_source { <150,330,-35> White
	fade_power 2
}

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2.5
}
/*** Dfinition des Textures ***/
/*******************************/

#declare T_Eau = texture {
	pigment { color White filter 0.95 }
	finish {
		reflection 0.9
		specular 0.99
		diffuse 0.99
	}
	normal {
		waves 0.1
		frequency 50
		scale <13,5.6,13>
		turbulence 0.15
	}
}

#declare C_FMarre = rgb <36/255,99/255,20/255>;
#declare C_CMarre = rgb <101/255,124/255,96/255>;
#declare C_Roche = rgb <130/255,130/255,142/255>;
#declare C_Gazon = rgb <47/255,119/255,21/255>;

#declare T_Marre = texture {
	pigment { marble
		color_map {
			[ 0.0 0.20 color C_FMarre color C_FMarre ]
			[ 0.20 0.25 color C_FMarre color C_CMarre ]
			[ 0.25 0.30 color C_CMarre color C_Roche ]
			[ 0.30 0.32 color C_Roche color C_Roche ] 
			[ 0.32 0.50 color C_Roche color C_Gazon ]
			[ 0.60 1.00 color C_Gazon color C_Gazon ]
		}
		turbulence 0.12
		rotate z*-90
		scale <1,1.4,1>
	}
	finish { specular 0.05
		diffuse 0.6
		roughness 0.995
		crand 0.26
		ambient 0.12
	}
	scale <10,50,10>
}

/*** Definition des Objets ***/
/*****************************/

#declare Marre = height_field {
	ppm "im_marre.ppm"
	smooth
	scale <300,50,300>
	texture { T_Marre }
	normal { bozo
		bump_size 3.8
		scale 2.5
		turbulence 0.35
		rotate x*30
		rotate z*12
	}

	translate <-160,-20,-155>
	rotate y*12
}

#declare Eau = plane {
	y,0
	texture { T_Eau translate <DecEx,DecEy,DecEz> }
	interior { ior 1.45
		fade_distance 60
		fade_power 1
	}
	translate <140,0,-110>
}

/*** Dfinition de la scne ***/
/******************************/

object { Marre }
object { Eau }
object { Nenuphare scale 1.4 translate <-12,0,37> }

// Arriere Plan
object { FleurR scale 1 translate <0,11,0>
	rotate x*(-15-C1) rotate y*(-30+C3) translate <-18,-2,75> }
object { FleurR scale 1.1 translate <0,9.9,0>
	rotate x*(-20+C5) rotate y*(35+C2) translate <-23,-2,72> }
object { FleurB scale 1.1 translate <0,8.5,0>
	rotate x*(-35-C6) rotate y*(15-C4) translate <-21,-2,66> }
object { FleurJ scale 1.0 translate <0,18,0>
	rotate x*(-45+C3) rotate y*(-40+C1) translate <-42,-2,71> }

// Premier Plan
object { Papier_Russe scale 0.50 translate <0,18,0>
	rotate x*(25+C2) rotate y*(69+C1) translate <-15,0,10> }
object { Papier_Russe scale 0.35 translate <0,14.5,0>
	rotate x*(40+C4) rotate y*(85+C3) translate <-17.5,0,12> }
object { Papier_Russe scale 0.42 translate <0,9.6,0>
	 rotate x*(50+C5) rotate y*(55+C6) translate <-16.6,0,19> }
object { FleurR scale 0.8 translate <0,6.5,0>
	 rotate z*(-16-C3) rotate x*(8+C4) translate <-6,-2,10> }

// Deuxieme Plan
object { FleurR scale 0.8 translate <0,10.5,0>
	 rotate z*(16+C2) rotate x*-8 translate <23,-4,37> }
object { FleurJ scale 0.85 translate <0,12.5,0>
	 rotate z*(32+C1) rotate x*-15 translate <22,-4,34> }
object { FleurB scale 0.65 translate <0,7.5,0>
	 rotate z*(-10+C5) rotate x*-10 translate <22,-4,35> }
object { FleurJ scale 0.9 translate <0,11.5,0>
	 rotate z*(-6+C6) rotate x*15 translate <26,-4,38> }
object { FleurR scale 0.76 translate <0,9.5,0>
	 rotate z*(7+C3) rotate x*-17.6 translate <22,-4,32> }

object { Panneau
	scale 1.2
	rotate x*-2
	rotate z*-3.95
	rotate y*-100
	translate <-80,-15,30>
}

/*** Affiche le nom ***/
#if(CL_MA>0.91)

#declare FontT="timrom.ttf"
text { ttf FontT "POUICPOUIC STORY",0.001,0
	scale 0.015
	rotate <0,6.34-90,0> 
	translate <4.8,3.911,34.895>
	pigment { White }
	finish { F_Peinture }
}

text { ttf FontT "Dominique Roux-Serret  1999",0.001,0
	scale 0.015
	rotate <0,6.34-90,0> 
	translate <4.8,3.894,34.895>
	pigment { White }
	finish { F_Peinture }
}

#end

/*** Dfinition du Mouvement du Papillon ***/
/*******************************************/

#local F_Pause=0.65;

#local PPapi=<-7,0.3,38.5>;
#local RPapi=<0,-180,0>;

/*** Fait la pose du Papillon ***/
#if(CL_MA<=F_Pause)
	#declare clp=CL_MA/F_Pause;
	#declare P_Aile=clp/6;

	#include "papillon.inc"

	object { Papillon
		rotate RPapi
		translate PPapi
	}
#end

/*** Fait le depart du Papillon ***/
#if(CL_MA>F_Pause)
	#declare clp=(CL_MA-F_Pause)/(1-F_Pause);
	#declare P_Aile=(clp*8);

	#include "papillon.inc"

	object { Papillon
		rotate RPapi
		rotate <0,sqrt(clp)*-90+sin(clp*2*CP)*2,0>
		translate PPapi
		translate <clp*-45+sin(clp*CP*2)*1.1,clp*26+sin(clp*CP*1)*1.8,
			(cos(clp*pi/2)-1)*20>
	}
#end
