//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/**********************************************/
/*** Dfinis tous les mouvements du Poussin ***/
/**********************************************/

/*** Dfinition des Variables ***/
/********************************/
#declare Grosseur_Joues=0.4; 	// Entre 0 et 1 (0=Pas de Joues)
#declare Dim_Pupille=0.3;    	// Entre 0 et 1 (0=Petit)
#declare Ouverture_Bec=0.1;  	// Entre 0 et 1 (1=ouvert)
#declare OuverturePaupiere=0.5; // Entre 0 et 1 (0=Ferme)
#declare DistanceFixe=700;	// Distance de l'object regard
#declare FixeAngleX=0;        	// Angle de l'objet regard en X (+ = Gauche)
#declare FixeAngleY=0;        	// Angle de l'objet regard en Y (+ = Haut)
#declare TeteAngleX=0;		// Angle de la teste en X (+ = Droite)
#declare TeteAngleY=0;		// Angle de la teste en Y (+ = Haut )
#declare AngleCoup=0;		// Angle du Coup (+ = Avant )
#declare Ouverture_Aile=0;  	// Entre 0 et 1 (0=ailes replies)
#declare PatteG=0;		// Entre -1 et 1 ( Angle de la patte Gauche )
#declare PatteD=0;		// Entre -1 et 1 ( Angle de la patte Droite )

/*** Definition des Macros pour les mouvements ***/
/*************************************************/

/*** Avance le coups en marchant ***/
#macro BougeCoup(clo)
	#declare AngleCoup=-(cos(clo*2*pi)/2-0.5)*55-5;
	#declare Ouverture_Bec=(cos(clo*2*pi)/2-0.5)*-0.8+0.2;
	#declare Grosseur_Joues=sin(clo*2*pi)*0.6+0.3;
#end

/*** Fait un clignement des yeux entre 0 et 1 ***/
#macro ClinYeux(clo,POuvert)
	#declare OuverturePaupiere=(cos(clo*2*pi)+1)/2*POuvert;
#end

/*** Fait un pas (entre 0 et 1) 0=pattes repos ***/
#macro Marche(clo)
	#declare PatteG=sin(clo*2*pi);
	#declare PatteD=-sin(clo*2*pi);
#end

/*** Bat des ailes ***/
#macro Bas_Aile(clo)
	#declare Ouverture_Aile=-(cos(clo*2*pi)/2-0.5);
#end

/*** Remus doucement des ailes ***/
#macro Agite_Aile(clo)
	#declare Ouverture_Aile=-0.2*(cos(clo*2*pi)/2-0.5);
#end
