//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

#include "colors.inc"
#include "glass.inc"

/*****************************/
/*** Dfinition des Objets ***/
/*****************************/
#declare T_JaunePoussin = texture {
	pigment {
		radial
		color_map {
			[1.999 rgb <204/255,204/255,24/255> ]
			[0.15 rgb <235/255,235/255,20/255> ]
		}
		frequency 30
		turbulence 0.2
		rotate x*90
	}
	finish {
		reflection 0.01
		specular 0.17
		diffuse 0.6
	}
	normal { bumps 0.2
		scale <0.001,0.001,0.001>
	}
}

#declare T_Langue = texture {
	pigment { color Red*0.5 }
	finish {
		reflection 0.1
		specular 0.6
		diffuse 1
	}
	normal { bumps 0.5
		scale <0.005,0.005,0.005>
	}
}

#declare T_BlancOeil = texture {
	pigment {
		color White
		filter 0
	}
	finish {
		reflection 0.1
		specular 0.42
		diffuse 1
		ambient 0.2
	}     
}

#declare T_Lentille = texture {
	pigment { color rgb <0.85,0.85,1.2>
		filter 0.99
	}
	finish {
		reflection 0.12
		ambient 0.00
		specular 0.6
		irid { 0.76 }
	}
}

#declare I_Lentille = interior {
	ior 1.30
}

#declare T_Pupille = texture {
	pigment { radial
		color_map { [0.5 Cyan*1.7] [0.8 Yellow*3.4] }
		frequency 45
		turbulence 0.02
	}
	normal {
		radial
		frequency 45
		bump_size -0.05
	}
	finish {
		reflection 0.08
		specular 0.005
	}
	rotate x*90
}

#declare T_FondOeil = texture {
	pigment { color rgbt <0,0,0,0>
		quick_color Black
		filter 0
	 }
	finish {
		reflection 0.0
		specular 0
		ambient 0
		diffuse 0
		roughness 0.000000001
	}
}

#declare T_Bec = texture {
	pigment { color rgb <224/255,210/255,168/255> }
	finish {
		reflection 0.01
		specular 0.85
		diffuse 0.7
	}
}

#declare T_Griffe = texture { T_Bec }

#declare T_Patte = texture {
	pigment { color rgb <188/255,170/255,135/255> }
	finish {
		specular 0.2
		diffuse 0.49
	}
	normal {
		marble 0.4
		rotate z*90
		scale <1,0.3,1>
		turbulence 0.3
	}
}

/*** Dfinition du Poussin ***/
/*****************************/
#declare R_Tete0 = blob {
	threshold 0.01
	sphere { <0,0,0>, 2,2 }
	sphere { <0.9,-0.4,-0.9>, Grosseur_Joues/4+0.68, Grosseur_Joues+0.68 }
	sphere { <-0.9,-0.4,-0.9>, Grosseur_Joues/4+0.68, Grosseur_Joues+0.68 }
}

#declare TrousOeil = sphere {
	<0,0,0>, 0.99
	translate <0.7,0.73,-2.6>
}

#declare R_Tete = difference {
	object { R_Tete0 }
	object { TrousOeil }
	object { TrousOeil scale <-1,1,1> }

	texture { T_JaunePoussin }
}

#declare Paupiere = intersection {
	sphere { <0,0,0>, 0.55 }
	plane { y, 0 inverse }
	texture { T_JaunePoussin }
}

#declare UnOeil = union {
	object { intersection { 
			sphere { <0,0,0>, 0.5 }
			plane { z,-0.4 inverse }
		}
		texture { T_BlancOeil }
	}
	object { intersection {
			sphere { <0,0,0>, 0.5 }
			plane { z,-0.4 }
		}
		translate <0,0,0.4>
		scale <1,1,1.3>
		translate <0,0,-0.405>
		texture { T_Lentille }
		interior { I_Lentille }
	}
	cylinder { <0,0,0> <0,0,0.1>, 0.3
		texture { T_Pupille }
		translate <0,0,-0.400001>
	}
	cylinder { <0,0,-0.4045> <0,0,-0.4005>, Dim_Pupille*0.22+0.05
		texture { T_FondOeil }
	}
	object { Paupiere
		rotate x*((OuverturePaupiere-0.5)*180)
	}
}

#declare Bec1 = difference {
	superellipsoid {
		<0.2,0.2>
		rotate z*45
		rotate x*45
		translate <0,-0.26,0>
	}
	plane { y,0 }
	scale <0.5,0.26,0.8>
}

#declare FBec = difference {
	object { Bec1 }
	object { Bec1 translate <0,-0.05,0> }
}

#declare BecBas = object {
	FBec
	scale <1,-1,-1>
	texture { T_Bec }
}

#declare BecHaut = object {
	FBec
	scale <1,1,-1>
	texture { T_Bec }
}

#declare Langue = sphere {
	<0,0,0>, 0.6
	scale <0.46,0.26,1.4>
	texture { T_Langue }
}

#declare Tete_Poussin = union {
	object { R_Tete }
	object { UnOeil
		rotate y*(atan2(0.38,DistanceFixe)*180/pi)
		rotate y*-FixeAngleX
		rotate x*FixeAngleY
		translate < 0.38,0.51,-1.41>
	}
	object { UnOeil
		rotate y*-(atan2(0.38,DistanceFixe)*180/pi)
		rotate y*-FixeAngleX
		rotate x*FixeAngleY
		translate < -0.38,0.51,-1.41>
	}
	object { BecHaut
		rotate x*(Ouverture_Bec*30)
		translate <0,-0.3,-1.8>
	}
	object { BecBas
		rotate x*-(Ouverture_Bec*50)
		translate <0,-0.3,-1.8>
	}
	object { Langue
		rotate x*-(Ouverture_Bec*30)
		translate <0,-0.3,-1.75>
	}

	rotate y*TeteAngleX
	rotate x*TeteAngleY
}

#declare Corps_Poussin = blob {
	threshold 0.801
	sphere { <0,0,0>, 0.5, 12   // Corps
		scale <8.5,6,12>
		texture { T_JaunePoussin }
	}
	cylinder { <0,0,0> <0,2.5,0>, 1.1, 2.2    // Coup
		texture { T_JaunePoussin rotate x*90 }
		rotate x*-AngleCoup
		translate <0,1.0,-4.3>
	}
	sphere { <0,0,0>, 3, 3   // Queue
		scale <1,0.4,1.2>
		texture { T_JaunePoussin }
		rotate x*(-40+(AngleCoup*0.7))
		translate <0,0.20,4.2>
	}
	sphere { <0,0,0>, 1, 1   // Patte 1
		texture { T_JaunePoussin }
		translate <1.4,-2.5,0>
	}
	sphere { <0,0,0>, 1, 1   // Patte 1
		texture { T_JaunePoussin }
		translate <-1.4,-2.5,0>
	}
	sphere { <0,0,0>, 1.5, 3  	// Aile 1
		scale <0.35,1.15,1.7>
		texture { T_JaunePoussin }
		translate <0,0,1.7>
		rotate x*30
		rotate z*30
		rotate z*(Ouverture_Aile*110)
		rotate x*-15
		translate <2.8,0.95,-1.8>
	}
	sphere { <0,0,0>, 1.5, 3  	// Aile 2
		scale <0.35,1.15,1.7>
		texture { T_JaunePoussin }
		translate <0,0,1.7>
		rotate x*30
		rotate z*-30
		rotate z*-(Ouverture_Aile*110)
		rotate x*-15
		translate <-2.8,0.95,-1.8>
	}
}

/*** Dfinition des Pattes du Poussin ***/
#declare Griffe = cone {
	<0,0,0>, 0.4  <0,-0.5,-1>, 0
	texture { T_Griffe }
}

#declare Cuisse = cylinder {
	<0,0,0> <0,8,0> 0.5
	texture { T_Patte }
}

#declare T_Pied = union {
	 cylinder {
		<0,0,0> <0,4,0> 0.4
		texture { T_Patte }
		rotate x*-90
	}
	object { Griffe 
		translate <0,0,-3.8>
	}
}

#declare Patte = union {
	object { T_Pied }
	object { T_Pied rotate y*-30 translate <0.1,0,0> }
	object { T_Pied rotate y*30 translate <-0.1,0,0>  }
	object { Griffe scale <1,1,-1> translate <0,0,0.3> }
	object { Cuisse }
	translate <0,-7.5,0>
}

/*** Assemblage du Poussin ***/
#declare Poussin = union {
	object { Tete_Poussin
		translate <0,1.8,-4.5>
		translate <0,(cos(AngleCoup/180*pi)*2.7),-(sin(AngleCoup/180*pi)*2.7)>
	}
	object { Corps_Poussin }
	object { Patte rotate x*(PatteG*50) scale <0.4,0.4,0.45> translate <1.4,-2.5,0> }
	object { Patte rotate x*(PatteD*50) scale <0.4,0.4,0.45> translate <-1.4,-2.5,0> }
}

