//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/***********************************/
/*** Regard le missil qui arrive ***/
/***********************************/

#include "colors.inc"
#include "skies.inc"

#include "ile_ar.inc"
#include "move_pou.inc"

#declare cl1=ppcl;

/*** Dfinition de la scne ***/
/******************************/
camera {
	ultra_wide_angle
	location <-160,92,-145>
	look_at <-180,97,-130>
	angle 110
}

light_source { <15000,33000,-10000> White }

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2
}

/*** Dfinition des objets ***/
/*****************************/

object { Ile }

#local PPou=<-180,84,-124>;

#declare Grosseur_Joues=0.3+0.1*cl1; 	// Entre 0 et 1 (0=Pas de Joues)
#declare OuverturePaupiere=0.7+cl1*0.1; // Entre 0 et 1 (0=Ferme)
#declare DistanceFixe=2700-2300*cl1;	// Distance de l'object regard
#declare FixeAngleX=0;
#declare FixeAngleY=4;
#declare TeteAngleX=0;
#declare TeteAngleY=8;
#declare AngleCoup=-4;
#declare PatteG=0;		// Entre -1 et 1 ( Angle de la patte Gauche )
#declare PatteD=0;		// Entre -1 et 1 ( Angle de la patte Droite )
Agite_Aile(cl1*2)

#declare Dim_Pupille=0.6-cl1*1.6;    	// Entre 0 et 1 (0=Petit)
#if(Dim_Pupille<0.21) #declare Dim_Pupille=0.21; #end

#declare Ouverture_Bec=0.40-cl1*0.40;
#if(cl1>0.5)
	#declare cl2=(cl1-0.5)/0.5;
	#declare Ouverture_Bec=(cos(cl2*2*pi*3)/2-0.5)*-0.80+0.2;
	#declare Grosseur_Joues=(cos(cl2*2*pi*3)/2-0.5)*-0.650+0.3;
	#declare TeteAngleX=sin(cl2*2*pi*2)*4;
	#declare TeteAngleY=8+sin(cl2*2*pi*2)*1;
	#declare FixeAngleX=sin(cl2*2*pi*2)*4;
	#declare FixeAngleY=4-sin(cl2*2*pi*2)*1;
#end

#if(cl1>0.25)
#if(cl1<0.40)
	ClinYeux( (cl1-0.25)/0.15 , 0.7+cl1*0.1 )
#end
#end

#include "poussin.inc"

object { Poussin
	rotate y*-32
	scale 2.5
	translate PPou
}
