//first clip - render 72 frames at 320x240, no antialiasing

#include "colors.inc"

camera {
       location 0
       right 2*x
       up 1.5*y
       look_at <clock,0,5>
       aperture .8
       blur_samples 7
       focal_point <clock*50-10,clock*6-5,clock*40+5>    
       }

light_source { <3000,0,-1200> color White }

#if (clock<.25)
        #declare textoffset = 0;
      #else
        #declare textoffset = (clock-.25)*2;
#end

#if (clock<.3)
        #declare textoffset2 = 0;
      #else
        #declare textoffset2 = (clock-.3)*2;
#end

text { ttf "c:\windows\fonts\comic.ttf" "it came from" 1,0 pigment {Yellow } finish { ambient .15 diffuse .7 specular .7 } rotate -10*y*clock translate <-4-textoffset*10,3+textoffset*10,10> }
text { ttf "c:\windows\fonts\impact.ttf" "BEYOND" .5,0 pigment {Yellow } finish { ambient .15 diffuse .7 specular .7 } scale 2 rotate (-15*clock-5)*y translate <-4-textoffset2*10,1+textoffset2*10,10> }

sphere{ 0,1000
        pigment {
            image_map { sys "i:/earth.bmp" map_type 1 }
         } 
        finish { ambient .1 diffuse .4 specular .5 roughness .2 }
        rotate -70*y 
        translate <1500,300,4000>
        }

box { <-20000,-10000,10000>,<20000,10000,10001>
        pigment {
            image_map { sys "i:/sky.bmp" map_type 0 } 
            scale <40000,40000,1>
         } 
        finish { ambient 1 diffuse 0 specular 0 }
        }

#declare Metal = texture{
        pigment { Gray85 }
        finish { diffuse .3 specular .9 roughness .03 metallic reflection .1}
        }

#declare Saucer = blob{
        threshold .5
                sphere { 0,2.5,1 scale <1,.7,1> }
                sphere { 0,.5,1 scale <12,.65,12> translate <0,-.15,0> }
                #declare Count = 0;
                #while (Count < 7)
                        cylinder { <0,-.04,0>,<2.5,-.14,0>,.6,.3 rotate y*51.4285*Count }
                        cylinder { <1.5,-.04,0>,<2.4,-.14,0>,.3,.3 rotate y*51.4285*(Count+.5) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.14,0>,.2,.3 rotate y*51.4285*(Count+.5) }
                        cylinder { <2.55,-.08,0>,<2.45,-.14,0>,.2,.8 rotate y*51.4285*(Count+.5) }
                        cylinder { 0,<1.5,.14,0>,.2,.55 rotate y*51.4285*(Count+.5) }
                        #declare Count = Count + 1;
                #end
        rotate clock*y*-1400 
        rotate -30*x
        texture {Metal}
        }

object{Saucer
  rotate (50*clock-50)*z
  translate <clock*50-10,clock*6-5,clock*40+5>}    
  
sky_sphere{
  pigment {Black}
      }