//second clip - render 72 frames at 320x240, no antialiasing

#include "colors.inc"

camera {
       location <0,2,0>
       right 2*x
       up 1.5*y
       #if (clock<0.4)
         look_at <0,(3.6-clock*4)*(3.6-clock*4)-1,10>
       #else
         look_at <0,3,10>
       #end
       aperture .8
       blur_samples 7
       #if (clock<.4) 
         focal_point <0,(3.6-clock*4)*(3.6-clock*4),10>
       #else
         focal_point <0,4-sin(clock*20-4)/8,10>
       #end  
       }  

light_source { <6000,10000,-12000> color White }

background { SkyBlue }

sphere { <0,-800000,0>,800000
        pigment {Green}
        normal { bumps turbulence .4 scale <.05,1,.05> }
        finish { ambient .1 diffuse .8 specular .2 }
        
        }

sphere { 0,800500
        hollow
        pigment { bozo turbulence .4
                color_map {
                        [0.0 rgbf 1.0]
                        [0.8 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 800
                }
        rotate -10*x
        rotate z*clock*.006 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

sphere { 0,800600
        hollow
        pigment { bozo turbulence .9
                color_map {
                        [0.0 rgbf 1.0]
                        [0.94 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 1000
                }
        rotate -60*x
        rotate z*clock*.005 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

#declare Shrub = blob {
        threshold .4
        #declare Count = 0;
        #while (Count < 18 )
                #declare Count2 = 0;
                #while (Count2 < 10)
                        cylinder { <0,3,0>,<3,.5,0>,1.5,1 rotate (Count2*34+Count*141)*y translate (Count-9)*5.7*x }
                        cylinder { <0,3.8,0>,<2.5,2,0>,1.5,1 rotate (Count2*37+Count*139)*y translate (Count-9)*5.7*x }
                        cylinder { <0,5,0>,<2.3,3.5,0>,1.1,1 rotate (Count2*31+Count*140)*y translate (Count-9)*5.7*x }
                        #declare Count2 = Count2 + 1;
                #end
                #declare Count = Count + 1;
        #end
        rotate 14*y
        pigment { agate turbulence .1
                color_map
                {[0.0 MediumForestGreen]
                [1.0 rgb <0,.2,0>] }
                scale .1
                 }
        normal { bumps scale .1}
        finish { diffuse .5 specular .4 roughness .8 }
        }
        
object { Shrub translate <-10,0,50> }

#declare Metal = texture{
        pigment { Gray85 }
        finish { diffuse .3 specular .9 roughness .03 metallic reflection .1}
        }

#declare Saucer = blob{
        threshold .5
                sphere { 0,2.5,1 scale <1,.7,1> }
                sphere { 0,.5,1 scale <12,.65,12> translate <0,-.15,0> }
                #declare Count = 0;
                #while (Count < 7)
                        cylinder { <0,-.04,0>,<2.5,-.14,0>,.6,.3 rotate y*51.4285*Count }
                        cylinder { <1.5,-.04,0>,<2.4,-.14,0>,.3,.3 rotate y*51.4285*(Count+.5) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.14,0>,.2,.3 rotate y*51.4285*(Count+.5) }
                        cylinder { <2.55,-.08,0>,<2.45,-.14,0>,.2,.8 rotate y*51.4285*(Count+.5) }
                        cylinder { 0,<1.5,.14,0>,.2,.55 rotate y*51.4285*(Count+.5) }
                        #declare Count = Count + 1;
                #end
        rotate clock*y*-864 
        rotate -30*x
        texture {Metal}
        }

object {
  Saucer
  #if (clock<.4) 
        translate <0,(3.6-clock*4)*(3.6-clock*4),10>
  #else
        translate <0,4-sin(clock*20-4)/8,10>
  #end
  }    


