//frames 325 - 408

//#declare cl = 3.4
camera {
location <2,2.5,3>
   look_at<.5,1.5,-2>}
light_source { <500,500,500> color rgb <1.2,1.2,1.2> }

#switch (cl)
//walking
#range (0,1)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = <20,0,cl*-720>    //back body rotation
#declare fbr = <20,0,cl*-720 +180>    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5-abs(cos(cl*pi*4))*.1,0> //head offset from body
#declare hr = <0,0,0 - abs(cos(cl*pi*4))*2 >   //head rotation
#declare rel = <0,0,40>  //eye lid opening
#declare lel = <0,0,40>
#declare rp = <-3+2.52*cl,1.7+abs(cos(cl*pi*4))*.2,-4>
#declare rr = <0,0,0>

//beatle
#declare lp1 = <cos(cl*pi*10)*10,sin(cl*pi*10)*15,0>
#if (lp1.x < 0)
#declare lp1 = lp1 - <lp1.x,0,0>
#end

#declare lp2 = <-cos(cl*pi*10)*10,-sin(cl*pi*10)*15,0>
#if (lp2.x < 0)
#declare lp2 = lp2 -<lp2.x,0,0>
#end
#declare br = <0,90,0>
#declare bp = <2,1,-10 + cl * 4>

#break
//jump
#range (1,2)

#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = <20*(2-cl),0,0>    //back body rotation
#declare fbr = <20*(2-cl),0,180>    //front body rotation
#declare fl = 1-cos(cl*pi*2)*1+1 - (cl-1)*.3   //length to foot

#if (fl > 1.5)
#declare fl = 1.5
#end

#declare ho = <1,.5 -(cl-1)*.5,0> //head offset from body
#declare hr = <-45+(cl-1)*45,45-(cl-1)*45,-45+(cl-1)*45>   //head rotation
#declare rel = <0,0,70>  //eye lid opening
#declare lel = <0,0,70>
#declare rp = <-.48,1.9-cos(cl*pi*2)*1+1 - (cl-1)*.4 ,-4>
#declare rr = <0,0,0>

//beatle
#declare lp1 = <cos(cl*pi*10)*10,sin(cl*pi*10)*15,0>
#if (lp1.x < 0)
#declare lp1 = lp1 - <lp1.x,0,0>
#end

#declare lp2 = <-cos(cl*pi*10)*10,-sin(cl*pi*10)*15,0>
#if (lp2.x < 0)
#declare lp2 = lp2 -<lp2.x,0,0>
#end

#declare br = <0,90+90*(cl-1),0>
#declare bp = vrotate(<-2.5,0,0>,<0,90*(cl-1),0>)+<4.5,1,-6> 

#break
//pause 

#range (2,2.5)


#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = <0,0,0>    //back body rotation
#declare fbr = <0,0,0>    //front body rotation
#declare fl = .7   //length to foot
#declare ho = <1,0,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,70>  //eye lid opening
#declare lel = <0,0,70>
#declare rp = <-.48,1.5 ,-4>
#declare rr = <0,0,0>

//beatle
#declare lp1 = <cos(cl*pi*10)*10,sin(cl*pi*10)*15,0>
#if (lp1.x < 0)
#declare lp1 = lp1 - <lp1.x,0,0>
#end

#declare lp2 = <-cos(cl*pi*10)*10,-sin(cl*pi*10)*15,0>
#if (lp2.x < 0)
#declare lp2 = lp2 -<lp2.x,0,0>
#end
#declare br = <0,180,0>
#declare bp = <4.5 +(cl-2)*4,1,-3.5>

#break

//looks to sky

#range (2.5,3)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = <0,0,0>    //back body rotation
#declare fbr = <0,0,0>    //front body rotation
#declare fl = .7   //length to foot
#declare ho = <1,cl-2.5,0> //head offset from body
#declare hr = <(cl-2.5)*90,(cl-2.5)*90,(cl-2.5)*90>   //head rotation
#declare rel = <0,0,70>  //eye lid opening
#declare lel = <0,0,70>
#declare rp = <-.48,1.5 ,-4>
#declare rr = <0,0,0>

//beatle
#declare lp1 = <cos(cl*pi*10)*10,sin(cl*pi*10)*15,0>
#if (lp1.x < 0)
#declare lp1 = lp1 - <lp1.x,0,0>
#end

#declare lp2 = <-cos(cl*pi*10)*10,-sin(cl*pi*10)*15,0>
#if (lp2.x < 0)
#declare lp2 = lp2 -<lp2.x,0,0>
#end
#declare br = <0,180,0>
#declare bp = <4.5 +(cl-2)*4,1,-3.5>

#break
//panning to ball


#range (3,3.5)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = <0,0,0>    //back body rotation
#declare fbr = <0,0,0>    //front body rotation
#declare fl = .7   //length to foot
#declare ho = <1,cl-2.5,0> //head offset from body
#declare hr = <45,45,45>   //head rotation
#declare rel = <0,0,70>  //eye lid opening
#declare lel = <0,0,70>
#declare rp = <-.48,1.5 ,-4>
#declare rr = <0,0,0>
//cannon ball
#declare cb = <(cl-3)*-50+50,(-(cl-3)*(cl-3)+2*(cl-3))*50, - 20>


camera {
location <2,2.5,3>
look_at <-.48+(cl-3)*50.96, 2.5+(cl-3)*70, -4 - (cl-3)*32>
}


#break




#end

#if (cl<=3)
camera {
location <2,2.5,3>
   look_at <rp.x,1,rp.z>}
#end


#if (cl>3)
sphere {cb,2 finish {specular .3}}

#end




#include "rockcreature.inc"
union {
object {creat rotate rr translate rp}

#if (cl<3)
#include "beatle1.inc"
object {beatle scale .1 rotate br translate bp}
#end

blob {
threshold .5
sphere {<0,0,0>,1,1 scale <50,1,50>}

//depretion
cylinder {<6,1.2,0>,<0,1.2,0>,1,-1}
//mound near depretion
cylinder {<6,.1,0>,<0,.1,0>,1.2,.4 }


pigment {rgb <1,1,0>}
normal {bumps .1 scale .02}
}
rotate <0,0,5>
}



//surf board
#include "surf board.inc"
object {surfboard
scale .15
rotate <0,00,5>
translate <-3,.4,-8>
finish {ambient 1}
}


//water

plane {<0,1,0>,.1113
pigment {rgb <.5,.75,1>}

finish {reflection .4 diffuse .6}
normal {
average 
normal_map {
[1 bumps .1 scale .2 translate <clock,0,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,80,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,63,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,255,0>]
}
}
}



//sky
#include "colors.inc"
#include "skies.inc"
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
} 
