/* leaf0.pov - POV-Ray 3.1 rendering of a leaf falling in Autumn
Created:     9/7/1999
Last edited: 10/5/1999
By:          William de Beaumont <amdebe1@ulster.net>
*/
#include "colors.inc"

#declare leafrot=
 texture
 {
#if (clock>.4)  
  normal {wrinkles (clock-.4)*2}
#end  
  pigment
  { bozo
    color_map
    { 
#if (clock<.25)     
     [0.0 rgb <3.2*clock,.8,0>]
     [1.0 rgb <0,.9,0>]
#else
#if (clock<.5)
     [0.0 rgb <.8,.8,1.6*(clock-.25)>]
     [1.0 rgb <3.2*(clock-.25),.9-.4*(clock-.25),0>]
#else
     [0.0 rgb <.8-.4*(clock-.5),.8-.4*(clock-.5),.4-.4*(clock-.5)>]
     [1.0 rgb <.8,.8,.8*(clock-.5)>]
#end   
#end   
   }
  }
 }

camera
{
 location <10,1,-10>
 look_at <0,0,0>
#if (clock>.4)
 location <10,1-(clock-.4)*20,-10>
 look_at <0,-(clock-.4)*40,0>
#end
}

#if (clock<.2)
 light_source {<50,100,-100> color rgb <clock*5,clock*5,clock*5>}
#else
 light_source {<50,100,-100> color White}
#end

plane 
{ -y,-50
  #if (clock<.2)
   finish {ambient .8*5*clock}
  #else
   finish {ambient .8}
  #end
  pigment
  {
   bozo
   color_map
   {
    [0.0 rgb <.2,.2,1>]
    [0.5 rgb <.8,.8,.9>]
    [1.0 rgb <1,1,1>]
   }
   translate x*clock*10
   rotate y*20
   scale 100
  }
  scale 10
} 

plane 
{ y,-30
 texture  
 { 
  #if (clock<.2)
   finish {ambient .3*5*clock}
  #else
   finish {ambient .3}
  #end
  pigment
  {
   bozo
   color_map
   {
/*    [0.0 rgb <.1,.5,.2>]
    [1.0 rgb <0,.8,.3>]*/
    [0.0 rgb <.4,.4,.2>]
    [1.0 rgb <.3,.3,.1>]
   }
  }
  //normal { bumps 1 scale 0.1 }
  //normal { bumps 1 scale 0.01 }
  normal {bumps 1 scale 0.05}
  scale 10
 } 
}

fog
{
 distance 300
 #if (clock<.2)
  color Gray75*5*clock
 #else
  color Gray75
 #end
 fog_type 2
 fog_offset 25
 fog_alt 25
}

#declare leaf=
 union
 {
  intersection
  {
   torus {4.92,.1 rotate z*90 translate y*-4.5}
   box {<-1,-1,-3>,<1,1,5>}
  }
  intersection
  {
   difference
   {
    cylinder {<-2,-4.5,0>,<2,-4.5,0>,5}
    cylinder {<-3,-4.5,0>,<3,-4.5,0>,4.95}
   }
   union
   {
    cone {<0,.5,0>,2,<0,-1,-4>,0}
    intersection
    {
     cylinder {<0,-3,0>,<0,3,0>,2}
     box {<-3,-4,0>,<3,4,3>}
    }
   }
  }
 }

#declare cs=seed(clock*10000);

object 
{leaf
 texture {leafrot}
#if (clock>.4)
 rotate z*(clock-.4)*-900
 translate -y*(clock-.4)*40
#else
 translate y
 rotate z*rand(cs)*-25
 translate -y
#end
} 

#declare s1=seed(46446);//44484313);//35458);

#declare leafx=0;
#while (leafx <50)
 #declare leafy=0;
 #while (leafy <50) 
  object 
  {leaf
   rotate <175+rand(s1)*10,rand(s1)*360,rand(s1)*90-45>
   translate <(leafx-45)*10-rand(s1)*5,-29,(leafy-5)*10+rand(s1)*5>
   texture
   {
    normal {wrinkles 1.2}
    pigment
    { bozo
      color_map
      { 
       [0.0 rgb <.8-.4*.5,.8-.4*.5,.4-.4*.5>]
       [1.0 rgb <.8,.8,.8*.5>]
      }
    }
   }
  }
  #declare leafy=leafy+1;
 #end
 #declare leafx=leafx+1;
#end

//some trees
#declare treecount=0;
#while (treecount <10)
 #declare treex=rand(s1)*-250;
 #declare treey=rand(s1)*250;
 #declare treewidth=5+rand(s1)*5;
 //trunks
 cone 
 {<treex,-30,treey>,treewidth,<treex+rand(s1)*5,100,treey+rand(s1)*5>,treewidth*.5
  normal {wrinkles 1 scale y*10}
  pigment {color rgb <.8,.8,.4>}
 }
 #declare branchcount=0;
 #while (branchcount <20)
  #declare branchheight=rand(s1)*90-5;
  //branches
  cone 
  {<treex,branchheight,treey>,treewidth*.25,<treex+rand(s1)*60-30,branchheight+rand(s1)*60+30,treey+rand(s1)*40-20>,0//treewidth*.125
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare branchcount=branchcount+1; 
 #end
 #declare rootcount=0;
 #while (rootcount <5)
  //roots
  cone 
  {<treex,-30,treey>,treewidth*.25,<treex+rand(s1)*40-20,-30,treey+rand(s1)*40-20>,treewidth*.125
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare rootcount=rootcount+1; 
 #end
 #declare treecount=treecount+1;
#end

//the tree the leaf is attached to
 #declare treex=0;
 #declare treey=20;
 #declare treewidth=5+rand(s1)*5;
 //trunk
 difference
 {
  cone 
  {<treex,-30,treey>,treewidth,<treex+rand(s1)*5,50,treey+rand(s1)*5>,treewidth*.5
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
  union
  {
   text { ttf "cyrvetic.ttf" "by William de Beaumont" 20,0 rotate z*-90}
   text { ttf "cyrvetic.ttf" "`Leaf'" 20,0 rotate z*-90 translate x*2}
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
 }
 #declare branchcount=0;
 #while (branchcount <20)
  //branches
  #declare branchheight=rand(s1)*90-5;
  cone 
  {<treex,branchheight,treey>,treewidth*.25,<treex+rand(s1)*60-30,branchheight+rand(s1)*20+10,treey+rand(s1)*60-30>,0//treewidth*.125
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare branchcount=branchcount+1; 
 #end
 #declare rootcount=0;
 #while (rootcount <5)
  //roots
  cone 
  {<treex,-30,treey>,treewidth*.25,<treex+rand(s1)*40-20,-30,treey+rand(s1)*40-20>,treewidth*.125
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare rootcount=rootcount+1; 
 #end
  //the branch the leaf is attached to
  #declare branchheight=-20;
  cone 
  {<treex,branchheight,treey>,.25,<0,-1,3.3>,.125
   normal {wrinkles 1 scale y*10}
   pigment {color rgb <.8,.8,.4>}
  }

//grass
#declare grasscount=0;
#while (grasscount<5000)
 #declare grassx=rand(s1)*-250+10;
 #declare grassy=rand(s1)*250-10;
  cone 
  { <grassx,-30,grassy>,.2,<grassx+rand(s1),-27,grassy+rand(s1)>,0
    pigment {color rgb <0,.7+rand(s1)*.1,rand(s1)*.3>}
  }
 #declare grasscount=grasscount+1;
#end
