#ifndef(SprayOn) #local SprayOn=0; #end
#ifndef(SprayCapOn) #local SprayCapOn=0; #end

union { // a spray can
  difference {
    cylinder { y*.3,y*10.3,3
      pigment {
        image_map { gif "spray.gif" map_type 2 interpolate 2}
        rotate y*270
        scale 10
        translate y*.3
      }
    }
    sphere { -3.7*y,5 texture { Alum } }
    torus { 2.8,.2 hollow translate y*10.3 texture { Alum } }
  }    
// the seams
  torus { 3,.075 scale <1,4,1> texture {Alum} translate y*.3 }
  torus { 3,.075 scale <1,4,1> texture {Alum} translate y*10.3 }

#if(SprayCapOn)
union { // the cap from the spray can
  cylinder { y*10.3,y*14.8,2.95 }
  cylinder { y*14.8,y*15.3,2.45 }
  torus { 2.45,.5 translate y*14.8 }
  texture { SprayCapTexture }
}
#else // the rest of the spray can

// the top part
  torus { 2.4,.2 texture {Alum} translate y*10.5 }
  torus { 0.9,.2 texture { Alum } translate y*12.0 }
  torus { 1.9,.2 texture { Alum } translate y*(11.5) }
  difference {
    cylinder { <0,-.3,0>,<0,0,0>,.7 }
    torus { .5,.2 }
    texture { Alum }
    translate y*11.8
  }
#local sA=.2/sqrt(5);
#local sB=.4/sqrt(5);  
  lathe { 9,<0.7,12.0>,
    <0.9+0+sA,12.0+0+sB>,
    <0.9+1+sA,10.5+1+sB>,
    <0.9+1+sB,10.5+1+sA>,
    <2.4+0+sB,10.5+0+sA>,
    <2.60,10.50>,<2.60,10.30>,<0.70,11.8>,<0.70,12.0>
    texture { Alum }
  }

#local sC=.4/sqrt(2);  
  intersection {
    union {
#local iI=0; #while (iI<89)
      box { <-sC,0,-sC>,<sC,1,sC> rotate y*iI }
#local iI=iI+90/7; #end
    }
    plane { <0,3,-1>,0 translate y*.8 }
    texture { Plastic }
    translate y*12
  }
  difference {
    cylinder { <0,12.6,0 >,<0,12.6,.4 >,.2 } 
    cylinder { <0,12.6,.2>,<0,12.6,.41>,.025 }
    texture { Plastic }
  }
#if (SprayOn)  
  cone { <0,12.6,.4>,0,<0,12.6,15.4>,3.5 hollow
    material {
      texture { pigment { rgbt 1 } }
      interior {
        media { emission .1
          density { granite translate z*clock*10 scale 15 }
        } 
      }
    }
  }
#end

#end // end of else if SprayCapOn=0
 
  Matrix(SprayX,SprayY,SprayZ,SprayL)
} // end of the spray can
