#include "colors.inc"
                       
//#if (clock < .1)  
#declare sky_vect = y;
#declare cam_loc = <0,0,60>;
#declare lookat = <0,0,0>;

camera { 
  location  cam_loc
  direction 1.5*z
  look_at   lookat
}


#macro Exp(R,B,S,E,Size) 
#declare Rand = rand(seed(R)) 

#if (clock > S)
#if (clock < E)
#local keyclock = mod((clock-S)/(E-S),1) 
#local Rate = pow(keyclock,.5)
 
#local Scale = 1*Rate+.25  
#local Fader = -1.5*keyclock+1.5

sphere {0,1 no_shadow hollow on
pigment {transmit 1}
interior {
media { 
intervals 45
//samples 1,1
/*confidence .9
variance .1*/
emission <1,.5,.1>/Size/Scale*Fader*B

density {bozo
color_map {
[0 rgb <1,.8,.7>]
[1 rgb 1]
} 
translate -2*clock+Rand
turbulence .5
omega .125
lambda 1
scale .35 
rotate (Rand*360)
}  

density {spherical
color_map {
[.1/2 rgb 1]
[.25/2 rgb (.25+(.25*Rand))*<.7,.2,0>]  
}
translate -1*clock+Rand 
rotate -2*clock
warp {turbulence .5+.5*(rand(seed(R))) omega .125 } 
rotate 2*clock
translate 1*clock-Rand

scale 8
translate 2*clock+Rand
rotate -20*clock
warp {turbulence 1 omega .125 }
rotate 20*clock
translate -2*clock-Rand
scale 1/8 
translate (1+(.8*Rand))*z 
rotate (-Rand*720) 
rotate 20*keyclock
} 

density {spherical
color_map {
[.15/2 rgb 0]
[.15/2 rgb <1,.125,0>]
[.15/2 rgb 3]  
[.25 rgb 1]
}
translate -1.5*clock+Rand 
rotate -2*clock
warp {turbulence 1*keyclock+.5 omega 0 lambda 0} 
rotate 2*clock
translate 1.5*clock-Rand  

scale 10*Rate+2
translate 4*clock+Rand
rotate 20*clock
warp {turbulence 1.5 omega 0}
rotate -20*clock
translate -4*clock-Rand
scale 1/(10*Rate+2)
rotate (Rand*360)

//omega 0 
scale .8  
}
density {spherical
color_map {
[.15/2 rgb 0]
[.15/2 rgb <1,.125,0>]
[.15/2 rgb 3]  
[.25 rgb 1]
}
translate -2*clock-Rand 
rotate -2*clock
warp {turbulence .5 omega 0 lambda 0} 
rotate 2*clock
translate 2*clock+Rand  

scale 10*Rate+2
translate -4*clock+Rand
rotate 20*clock
warp {turbulence 1.5 omega 0}
rotate -20*clock
translate 4*clock-Rand
scale 1/(10*Rate+2)
rotate (Rand*360) 
//omega 0 
scale .8  
}
#if (keyclock < .5)
#else
density { bozo
color_map{
[1.5*keyclock-1 rgb 0]
[2*keyclock-1 rgb 1]
[1.0 rgb 1]
}
scale 1
translate .25*keyclock
warp {turbulence .5 }
translate -.25*keyclock  

scale 6
translate 2*clock+Rand
rotate 20*clock
warp {turbulence .75 omega .125 lambda 1}
rotate -20*clock
translate -2*clock-Rand
scale 1/6

rotate 323456*Rand+567567
}
#end

}
}
scale Scale 
scale Size
}
#declare spark_count = 100
   #declare min_distance = (.75)*keyclock+.01
   #declare max_distance = (2)*keyclock+.01
   #declare star_size = (-2*keyclock+2)*rand(seed(R*R))
      #declare star_object = disc {<0, 0, 0>,x,1 no_shadow hollow
         pigment {onion color_map {[0 rgbt <1,1,0,.25*keyclock>] [1 rgbt <1,.25,0,1>]} scallop_wave scale 2.5 }
         finish {ambient 2 diffuse 0} scale <1,1,5*keyclock+1> scale .5/Size}

   #declare _SF_distdif = max_distance - min_distance
   #declare _SF_rand = seed(R)

   //**** Sparks ****//
   union {
   #declare _SF_count = 0 #while (_SF_count < spark_count)
     object {
     star_object
       scale star_size
       translate z * (min_distance + rand(_SF_rand) * _SF_distdif)
       rotate (<rand(_SF_rand),rand(_SF_rand),rand(_SF_rand)>-.5)*360
       }
   #declare _SF_count = _SF_count + 1
   #end 
   
   scale Size
   
   }
#end
#end

#end 

union {
//Exp(R,B,S,E,Size) 
Exp(9,1.5,0,1,20)
}
/*
#declare spark_count = 100
   #declare min_distance = 0
   #declare max_distance = 20*clock+.01
   #declare star_size = -2*clock+2
      #declare star_object = disc {<0, 0, 0>,x,1 no_shadow hollow
         pigment {onion color_map {[0 rgbt <1,1,0,.25*clock>] [1 rgbt <1,.25,0,1>]} scallop_wave scale 2.5 }
         finish {ambient 2 diffuse 0} scale <1,1,5*clock+1> scale .5}

   #declare _SF_distdif = max_distance - min_distance
   #declare _SF_rand = seed(134)

   union {
   #declare _SF_count = 0 #while (_SF_count < spark_count)
     object {
     star_object
       scale star_size
       translate z * (min_distance + rand(_SF_rand) * _SF_distdif)
       rotate (<rand(_SF_rand),rand(_SF_rand),rand(_SF_rand)>-.5)*360
       }
   #declare _SF_count = _SF_count + 1
   #end
   }
*/

light_source {0 rgb 0}                    
