#declare Start = .5;
#declare End = 1.0001; 
#declare keyclock = 0  
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#end
#end

#declare mclock = pow(keyclock,.5)
#declare mclock2 = sin((keyclock-.5)*pi)/2+.5

camera 
{
location  <40,40,-80>*15/3*1.125
direction 15*z
look_at <0,0,0>  
rotate 45*y*mclock2
}

box {<-20,0,-20>,<20,0,20> no_shadow hollow 
texture {
pigment {
image_map {
png "radar2.png"  
interpolate 2
}
} 
finish {ambient 2} 
scale <40,40,1> 
rotate 90*x
translate <-20,0,-20>     
} 
translate <0,-5,0> 
} 


declare GlowTex =
texture {pigment {slope x color_map {[0 rgb <1,.45,0>*1.5][1 rgb <1,.45,0>*.5]}}
finish {ambient 1}}

#declare TopTex1 =
texture {GlowTex }

#declare SideTex1 =
texture {GlowTex }

#declare SideTex2 =
texture {GlowTex }



#declare RBox = box {0,1}
#declare RBox2 = box {0,1}
#declare RBox2a = box {0,1}
#declare RBox3 = box {0,1}

#macro Cannon2CM(Fire,FireRepeat) 
#declare Clock = mod((clock - Fire)*(FireRepeat)/((1+Fire) - Fire), 1);  
#declare RClock = mod((clock - Fire)*(FireRepeat*3)/((1+Fire) - Fire), 1);
#declare mclock = (RClock<0.5?pow(RClock*2,.25/.5):pow(1-(RClock*2-1),4*.5));

#declare C_Tex =
texture {GlowTex }

#declare B_Tex =
texture {GlowTex }

#declare B_Tex2 =
texture {GlowTex }

#declare A_Tex =
texture {GlowTex }

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: Main Sheath
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: Base
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1.5, 4, 1.5 >

               texture
               {
                  B_Tex
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 4, 7.5, 11.75 >
                     translate < -2, 1, -6.25 >
                  }
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 6, 4.75, 8 >
                     translate < -3, 0, -10.25 >
                  }
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 3.5, 7.5, 11.75 >
                     translate < -1.75, 0.5, -13.5 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 4.5, 2.25, 8 >
               translate < -2.25, 5.75, -3 >
            }
         }
      }
      // Object type: Composite
      // Name: Recoiler
      object
      {
         union
         {
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -4.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -2.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -2.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -3.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -3.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -4.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -6.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -6.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -5.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -5.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -7.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -7.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -8.25 >
            }
         }

         texture
         {
            B_Tex
         }
     translate 2*z
     scale <1,1,-.5*mclock+1>    
     translate -2*z
      }
      // Object type: Composite
      // Name: Barrels & Nozzels
      object
      {
         union
         {
            
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < -1, 7.75, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < 0.75, 7.75, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < -1, 0.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < 0.75, 0.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < 1.5, 5, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < 1.5, 3.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < -1.25, 5, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < -1.25, 3.25, -15.75 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 2.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 6.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 4.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 2.25, -14.5 >

               texture
                     {
                        C_Tex
                        scale .5
                        rotate 45*z
                     }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 4.25, -14.5 >

               texture{B_Tex2}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 6.25, -14.5 >

               texture
                     {
                        C_Tex
                        scale .5
                        rotate 45*z
                     }
            }
            // Object type: Difference
            // Name: Nozzels
            object
            {
               difference
               {
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 2.5, 7.5, 2 >
                     translate < -1.25, 0.5, -16 >

                     texture
                     {
                        B_Tex
                        scale .5
                        rotate 45*z
                     }
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 6.25, -16.375 >
                     
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 4.25, -16.375 >
                     
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 2.25, -16.375 >
                     
                  }
               }

               texture
               {
                  B_Tex
                  translate < 0, 4.25, -15 >
               }
            }
            
         }

         texture
         {
            B_Tex
         }
         translate <0,0,4*mclock>
      }
// Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 1, 5, 1 >
         rotate < 90, 0, 0 >
         translate < 2, 4, -0.75 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         translate < 2, 4, 4.25 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 1, 1, 0.75 >
         translate < 2, 4, -0.75 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 3 >
         translate < -1.5, 8.25, -5.875 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 3 >
         translate < -1.5, 8.25, 2.25 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, -2.375 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, -0.875 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, 0.625 >
      }


#declare BR = 1-(3*RClock)



/*union {MFlash translate 6.25*y}  
union {MFlash translate 4.25*y}
union {MFlash translate 2.25*y}*/
}
texture {A_Tex}
scale 1
rotate -90*z
}
#end

#declare Fusalage =
object
{
   union
   {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.6  }

                     scale < 10, 12, 35 >
                     rotate < 0, 0, 90 >
                     translate < -6, 0, 0 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.55  }

                     scale < 9, 13, 33 >
                     rotate < 0, 0, 90 >
                     translate < -6, -2.0433e-21, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 0.75, 10, 0.75 >
                     translate < -8, 0, -16 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 14, 11, 37 >
               translate < -20, 0, -37 >
            }
         }
      }
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.6  }

                     scale < 10, 12, 35 >
                     rotate < 0, 0, -90 >
                     translate < 6, -3.7352e-22, 1.4694e-39 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.55  }

                     scale < 9, 13, 33 >
                     rotate < 0, 0, -90 >
                     translate < 6, 1.635e-24, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 0.75, 10, 0.75 >
                     translate < 8, 0, -16 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 14, 11, 37 >
               translate < 6, 0, -37 >
            }
         }
      } 
      difference {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 10, 12, 35 >
               rotate < 0, 0, -90 >
               translate < -6, -2.647e-23, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 12, 11, 50 >
               translate < -6, 0, -38 >
            }
         }
      } 
       // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8, 10.5, 19 >
         translate < -4, 1, -32 >
      }
      }
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 4.5, 12, 35 >
               rotate < 0, 0, 90 >
               translate < 6, -5.2454e-07, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 12, 4.95, 50 >
               rotate < 0, 0, 180 >
               translate < 6, -5.2454e-07, -38 >
            }
         }
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 14, 14, 27 >
         translate < -7, -4, 0 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

               scale < 6, 9, 25 >
               rotate < 0, 0, 90 >
               translate < -6, 2, 7.8886e-31 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 90, 0, 0 >
               translate < -6, 0, 0 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 10, 0.75 >
               translate < -10, 0, 1.5 >
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

               scale < -6, -9, -25 >
               rotate < 180, 0, -90 >
               translate < 6, 2, 0 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < -20, -1, -20 >
               rotate < -90, 0, 0 >
               translate < 6, 0, 0 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 10, 0.75 >
               translate < 10, 0, 1.5 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 5, 34, 5 >
         rotate < 0, 0, -90 >
         translate < -17, 2, 14 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 1 }

         rotate < 0, 0, -90 >
         translate < -17, 2, 14 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 1 }

         rotate < 0, 0, -90 >
         translate < 17, 2, 14 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

         scale < 4, 2, 4 >
         rotate < 0, 0, -90 >
         translate < 18, 2, 14 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

         scale < 4, 2, 4 >
         rotate < 0, 0, 90 >
         translate < -18, 2, 14 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 3, 1, 3 >
         rotate < 0, 0, -90 >
         translate < 20, 2, 14 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 3, 1, 3 >
         rotate < 0, 0, -90 >
         translate < -21, 2, 14 >
      }
            // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      union {
            // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      scale <-1,1,1>
      }

sphere_sweep{
linear_sphere_sweep,
7,
<-10,0,1.5>,.5 
<-10,9,1.5>,.5
<-10,8.75,-5.5>,.5
<-10,8.5,-11.75>,.5
<-10,8,-16>,.5 
<-8,8.5,-16>,.5
<-8,0,-16>,.5
} 
sphere_sweep{
linear_sphere_sweep,
7,
<10,0,1.5>,.5 
<10,9,1.5>,.5
<10,8.75,-5.5>,.5
<10,8.5,-11.75>,.5
<10,8,-16>,.5 
<8,8.5,-16>,.5
<8,0,-16>,.5
}
// Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8, 4, 6 >
         rotate < 6.6592, 0, 0 >
         translate < -4, 7.5, -15.5 >
      }
      union {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      
      }
      union {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      scale <-1,1,1>
      }
       
 
   }
} 

#declare TestEngine =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 6, 38, 47 >
                     translate < -6, -19, -50 >
                  }
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 5, 16.364, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, 8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                     }
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 36, 1 >
               translate < 0, -18, -29 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 40, 1 >
               translate < 0, -20, -9 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 28, 1 >
               translate < 0, -14, -44 >
            }
         }              
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -10, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 6, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 1, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -5, -5 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 12, 20, 50 >
                           translate < 0, -10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, 10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, -10, 0 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 13, 46, 50 >
                     translate < 0, -23, -50 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 6, 18, 53 >
               translate < 1, -9, -51 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 9, 18, 17 >
               translate < 1, -9, -51 >
            }
         }
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -8.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 8, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -5.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 3.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -2.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 6.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -4, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -7, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 2, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -1, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 0.5, -33 >
      }
            // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -24.5 >        
               texture {GlowTex }
               
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 4.5, 15.5, 14 >
                     translate < -7.5, -7.5, -24.5 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 7, 3, 2000 >
                     rotate < 0, 0, 90 >
                     translate < -3.5, 0, -17.5 >
                  }
               }
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -10.5 >
            }
         }
         scale <1,2,1> 
         texture {SideTex2}
      }
      // Object type: HeightField
      // Name: NOZZLE~1.TGA
      object
      {
         height_field { tga "C:\NOZZLE~1.TGA" smooth water_level .01 translate -.01*y }

         scale < -13.5, -24, -40 >
         rotate < -90, 0, 0 >
         translate < 12.5, 20, 2.8541e-21 >

      }

      
      
sphere_sweep{
linear_sphere_sweep,
7, 
< -.5, 0, -9 >,.5
< -.5, -20, -9 >,.5
< -.5, -18, -29 >,.5 
< -.5, 0, -29 >,.5  
< -.5, -18, -29 >,.5
< -.5, -14, -44 >,.5
< -.5, 0, -44 >,.5
}
sphere_sweep{
linear_sphere_sweep,
7,
< -.5, 0, -9 >,.5
< -.5, 20, -9 >,.5
< -.5, 18, -29 >,.5 
< -.5, 0, -29 >,.5  
< -.5, 18, -29 >,.5
< -.5, 14, -44 >,.5
< -.5, 0, -44 >,.5
}
}
translate 24*z  
scale <1,.75,1>
}
#declare TestEngine2 =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 6, 38, 47 >
                     translate < -6, -19, -50 >
                  }
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 5, 16.364, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, 8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                     }
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 36, 1 >
               translate < 0, -18, -29 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 40, 1 >
               translate < 0, -20, -9 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 28, 1 >
               translate < 0, -14, -44 >
            }
         }              
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -10, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 6, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 1, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -5, -5 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 12, 20, 50 >
                           translate < 0, -10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, 10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, -10, 0 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 13, 46, 50 >
                     translate < 0, -23, -50 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 6, 18, 53 >
               translate < 1, -9, -51 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 9, 18, 17 >
               translate < 1, -9, -51 >
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -24.5 >        
              texture {GlowTex }
               
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 4.5, 15.5, 14 >
                     translate < -7.5, -7.5, -24.5 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 7, 3, 2000 >
                     rotate < 0, 0, 90 >
                     translate < -3.5, 0, -17.5 >
                  }
               }
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -10.5 >
            }
         }
         scale <1,2,1> 
         texture {SideTex2}
      }
      // Object type: HeightField
      // Name: NOZZLE~1.TGA
      object
      {
         height_field { tga "C:\NOZZLE~1.TGA" smooth water_level .01 translate -.01*y }

         scale < -13.5, -24, -40 >
         rotate < -90, 0, 0 >
         translate < 12.5, 20, 2.8541e-21 >
           
         
         
}

}
texture {SideTex1} 
}



#macro TiltFighter(Loc,Rot,ERot)
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot 
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
union {Fusalage} 
union {Cannon2CM(1,1) scale <-1,1,1> translate <15,-2.25,-26>}   
union {Cannon2CM(1,1) scale <1,1,1> translate <-15,-2.25,-26>}

union {TestEngine rotate <EngRot1,0,0>  translate <25,2,14>}
union {TestEngine rotate <EngRot2,0,0>  translate <25,2,14> scale <-1,1,1>} 

//union {TestEngine2 scale <.75,.35,.75> rotate 90*z translate <0,13,32> }   
union {TestEngine2 scale <.75,.35,.75> rotate -80*z translate <8,-4,26>}  
union {TestEngine2 scale <.75,.35,.75> rotate -100*z translate <-8,-4,26>}

#declare CocShield = 
height_field { 
tga "c:\cocp3"
smooth 
water_level .01      
translate <-.5,-.01,-.5>
scale<13,9,25>
texture {GlowTex}
scale <1.1,1,1>
rotate <-20,0,0>
translate <0,5.5,-24.125>
} 

union {CocShield}
union {CocShield translate -.25*y}
 

translate <0,0,-16> 
texture {GlowTex }
   
scale .33
rotate Rot
translate Loc
} 
#end

#declare Rclock = sin(clock*2*pi)


TiltFighter(<0,0,0>,<90*mclock2,0,15*Rclock>,0)



global_settings {
max_trace_level 120
}