#include "colors.inc"
                       
#declare sky_vect = y;
#declare cam_loc = <80,40,225/2>*1.5;
#declare lookat = <0,0,((2000*clock)/1.5)+250>;
camera { 
  location  cam_loc
  direction 1.5*z
  look_at   lookat
}


                             

light_source {
<-250,300,50>*10000
color rgb 4
//area_light 25,25,10,10
//adaptive 0
}
light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}

background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 

#macro FFTest(Loc,Rot,ERot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

//#declare RotZ = ((Rot.z/clock)*clock_delta)/2
//#declare RotX = ((Rot.x/clock)*clock_delta)/2
 
#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate 15*y }  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <-37.5,0,50> rotate <EngRot2,0,0>} 

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <37.5,0,50> rotate <EngRot1,0,0>}

scale .75 
rotate Rot 
translate Loc
}
#end



                  
#declare Start = 0;
#declare End = .25; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
                                  
#if (clock < .25)                                  
#declare Tilt = sin((keyclock-.5)*pi)/2+.5 
#else                                      
#declare Tilt = 1
#end          

#declare Barrelc3 = pow(keyclock,.5)

#declare Speedc1 = pow(keyclock,2)
#declare Rclock = sin(clock*2*pi)            


 
//#include "COM Fighter.inc"  
//TiltFighter(<-60,0,2080*clock>,<0,180,15*Rclock>,-20*Tilt+20,false,1)
//TiltFighter(<50,0,2080*clock-80>,<0,180,-10*Rclock>,-20*Tilt+20,false,2)

FFTest(<-60,0,2080*clock>,<0,180,0>,-20*Tilt+20)
FFTest(<50,0,2080*clock-80>,<0,180,0>,-20*Tilt+20)
//FFTest(<0,0,0>,<90,0,0>,0)


                       
#declare Start = 05;
#declare End = .25; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare BRC = 1-pow(abs(keyclock*2-1),2)



#declare Start = .25;
#declare End = 1; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare Distc1 = pow((1-keyclock),2)  

#declare Distc2 = pow((1-keyclock),2)*.75


#if (clock < .5)

                                 
#declare flare_size = <1,1,1>*Distc2;
#declare flare_brightness = (<.5,.33,1.25>*.5)*Distc1;   
#declare light_loc = vrotate(<5,0,23>,-20*Tilt+20*x)+<25,2,14>
#declare light_loc = vrotate(light_loc,<0,180,15*Rclock>)+<-60,0,2080*clock>
#include "CAMCORDR.flr"   
#include "nkflare.inc"    

#declare flare_brightness = (<.5,.33,1.25>*.75)*Distc1;   
#declare light_loc = vrotate(<-5,0,23>,-20*Tilt+20*x)+<-25,2,14>
#declare light_loc = vrotate(light_loc,<0,180,15*Rclock>)+<-60,0,2080*clock>
#include "CAMCORDR.flr"              
#include "nkflare.inc"   

#declare flare_brightness = (<.5,.33,1.25>*1)*Distc1;    
#declare light_loc = vrotate(<5,0,23>,-20*Tilt+20*x)+<25,2,14>
#declare light_loc = vrotate(light_loc,<0,180,-10*Rclock>)+<50,0,2080*clock-80>
#include "CAMCORDR.flr"
#include "nkflare.inc"    

#declare flare_brightness = (<.5,.33,1.25>*2)*Distc1;   
#declare light_loc = vrotate(<0,0,23>,-20*Tilt+20*x)+<-25,2,14>
#declare light_loc = vrotate(light_loc,<0,180,-10*Rclock>)+<50,0,2080*clock-80>
#include "CAMCORDR.flr" 
#include "nkflare.inc"                   
#end 


#declare Start = 0;
#declare End = .66; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end   

#declare Spd = pow(keyclock,.5)

#declare Start = .5;
#declare End = 1; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#if (clock > .5) 
#declare Spd2 = pow(1-keyclock,2)
#else                          
#declare Spd2 = 0
#end


#declare Start = .33;
#declare End = 1; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end 

                                          
#macro EFTest(Loc,Rot) 

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate -30*z }  

scale .75 
rotate Rot 
translate Loc
}
#end                                          


 
#include "Pirate Fighter.inc" 

FixedFighter(vrotate(<50,0,150>,-180*x*keyclock)+<0,20*clock,750+(3050*Spd)+(-1500*Spd2)>,<180*keyclock,180,(25*Rclock)+(180*clock)+12.5>,1) 
FixedFighter(vrotate(<-40,0,250>,-180*x*keyclock)+<0,20*clock-30,750+(3000*Spd)+(-1550*Spd2)>,<180*keyclock,180,(25*Rclock)+(-30*clock)>,2) 
 //EFTest(vrotate(<50,0,150>,-180*x*keyclock)+<0,20*clock,500+(2050*Spd)+(-1000*Spd2)>,<180*keyclock,180,(25*Rclock)+(180*clock)+12.5>) 
 //EFTest(vrotate(<-40,0,250>,-180*x*keyclock)+<0,20*clock-30,500+(2000*Spd)+(-1050*Spd2)>,<180*keyclock,180,(25*Rclock)+(-30*clock)>) 




global_settings {max_trace_level 100000}  