#include "colors.inc"

#macro CM(S,E)
#if (clock >= S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end

CM(0,.33) 
#declare keyclock = pow(keyclock,.5)

#declare sky_vect = y;
#declare cam_loc = <-50*clock+30,10,-200*keyclock+220+20*clock>*10;
#declare lookat = <0.01,0.01,-2000*keyclock+2000.01>;
camera { 
  location  cam_loc
  direction 1.5*z
  look_at   lookat
}
#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#declare Scarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .875][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .667][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}



light_source {
<-250,120,-50>*10000
color rgb 2
//area_light 25,25,10,10
//adaptive 0
}
  
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 
  
#macro GateWay(St,Ed,Loc)   
CM(St,Ed)
#declare keyclock = pow(keyclock,.5)
sor {8,
<20,-15>, 
<15,0>,
<6,5>,
<1.5,5.25+4.75*keyclock>,
<.5,5.5+7*keyclock>,
<.25,5.75+9*keyclock>,
<.125,6+10*keyclock>,
<0,6.25+11*keyclock>
open
rotate 90*x

//interior {ior 1.2}
texture {
finish {ambient 1.5 diffuse 0}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.875 
radial triangle_wave frequency 6
//onion triangle_wave
color_map{
[0 rgb <.125,.125,.5> transmit .5]
[1 rgb <.5,.5,.75>*1.5]
}
scale 3
translate -20*z*clock
warp {turbulence 1 omega 0}
translate 20*z*clock     
scale 1/3

warp {turbulence .75 omega 0 lambda 1
}

scale 1/8
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20
rotate 90*x 
rotate (10*clock)*z
}
}               

texture {
finish {ambient 2 diffuse 0}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.925 onion triangle_wave
color_map{
[0 rgb <.5,.5,.75> transmit .125]
[1 rgb <.5,.5,1>*1.25]
}
scale 6
translate -2*z*clock
warp {turbulence 2}
translate 2*z*clock     
scale 1/6


phase 6*clock
warp {turbulence .5
}
scale 1/12
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20 
rotate 90*x
}
}                      
translate -16*z   
rotate -90*z*clock
scale <1*keyclock+.0001,1*keyclock+.0001,1*keyclock+.0001> 
translate 16*z*keyclock 
translate Loc
} 
#if (clock > St)
#declare flare_size = (1.5*keyclock+.5)/2;
#declare flare_brightness = <.5,.5,1>*2;   
#declare light_loc = <0,0,-130*keyclock>+Loc
#include "CAMCORDR.flr"   

light_source {<0,0,13*keyclock>+Loc rgb 3 shadowless fade_distance 150 fade_power 1} 
#declare C=0; 
#while(C<360) 
light_source {<0,5,13*keyclock>+Loc rgb 1 shadowless fade_distance 150 fade_power 1 rotate 60*keyclock*z rotate -C*z}
#declare C=C+90
#end

#declare C=0; 
#while(C<360) 
light_source {<0,20,8*keyclock>+Loc rgb <.5,.5,1>/2 shadowless fade_distance 150 fade_power 1 rotate 60*keyclock*z rotate C*z}
#declare C=C+45
#end 
#end

#end


#declare GateFin =
difference {
intersection {
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 20, 13.362, 2.015 >
rotate < 8.673, 0, 0 >
translate < -12, -6.5, -2 >
}
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 20, 13.362, 2.0148 >
rotate < -8.6732, 0, 0 >
translate < -12, -6.75, 0 >
}
object {
torus { 12, 0.06125 }
scale < 1, 12, 1 >
rotate < 90, 0, 0 >
translate < -12, 0, 0 >
}
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 2.75, 4.75, 2.5 >
translate < -2, 1.3531e-17, -1.25 >
}
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 0.75, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 3, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 2.25, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 1.5, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}
scale < 0.25, 2, 0.25 >
rotate < 90, 0, 0 >
translate < 0, 0, -1 >
}      
texture {pigment {rgb .6} finish {ambient .1 diffuse .6}}
texture {Scarring scale 1/2}
texture {Scarring scale 1}
texture {Scarring scale 2}
}
#macro GateFins(GteOpn,Flip) 
union {
union {GateFin rotate (-75*GteOpn+75)*z}
union {GateFin scale <1,-1,1> rotate (75*GteOpn-75)*z}
object {
RBox2
scale<0.375,0.875,2>
translate<0,-0.375,-1>
}
object {
RBox2
scale<0.25,0.125,1.75>
translate<0.25,-0.25,-0.875>
}
object {
RBox2 
scale<0.25,0.125,1.75>
translate<0.25,0.25,-0.875>
}
object {
RBox2
scale<0.25,0.125,1.75>
translate<0.25,0,-0.875>
}
scale <Flip,1,1>
texture {pigment {rgb .6} finish {ambient .1 diffuse .6}}
texture {Scarring scale 1/2}
texture {Scarring scale 1}
texture {Scarring scale 2}
 
//scale <1,1,1.5>
}
#end 

#macro Gate(St,Ed,Loc)
CM(St,Ed)
#declare keyclock = sin((keyclock-.5)*pi)/2+.5

union {GateFins(keyclock,1) translate <3+10*keyclock,.25-.25*keyclock,0>} 
union {GateFins(keyclock,-1) translate <-3-10*keyclock,-.25+.25*keyclock,0>}

union {GateFins(keyclock,1) translate <3+10*keyclock,.25-.25*keyclock,5-5*keyclock> rotate 90*z} 
union {GateFins(keyclock,-1) translate <-3-10*keyclock,-.25+.25*keyclock,5-5*keyclock> rotate 90*z}
#end

union {
GateWay(.5,.75,0) 
Gate(0,.5,0) 
rotate 180*y
scale 10
}

#if (clock > .75)
#include "Pirate Fighter.inc"
//EFTest(<0,0,-3500*clock>,<0,0,(-20*Rclock)+(90*clock)-(90*Clock3)-(100*clock)>) 
#if (clock > .935)
difference {
#end
FixedFighter(<0,0,-3200*clock+3000>,<0,0,0>,2,2,2) 
#if (clock > .935)
disc {0,z,400 translate -75*z pigment {transmit 1}}
}  
#end
#end
//sphere {0,500 scale <1,1,.1> translate -80*z pigment {rgb .5}}






#if (clock > .5)
#include "nkflare.inc"  
#end 

#if (clock > .9475)      
CM(.9475,.9875)
#declare flare_size = (1.5-1*keyclock);
#declare flare_brightness = <.75,.75,1>*(4-3*keyclock);   
#declare light_loc = <0,0,-130*keyclock>
#include "50mm.flr" 

#include "nkflare.inc"  
#end

global_settings {max_trace_level 100000}  
