#include "colors.inc"

//#if (clock < .1)  
#declare cam_loc = <10,0,-20>; 
#declare sky_vect = y;
#declare lookat = <0,0,0>;
camera 
{
location  cam_loc
direction 1.5*z
look_at lookat 
}





#macro Exp(R,B,S,E,Size) 
#declare Rand = rand(seed(R)) 

#if (clock > S)
#if (clock < E)
#local keyclock = mod((clock-S)/(E-S),1) 
#local Rate = pow(keyclock,.375)
 
#local Scale = 1*Rate  
#local Fader = -1.5*keyclock+1.5

sphere {0,1 no_shadow hollow on
pigment {transmit 1}
interior {
media { 
intervals 25
/*samples 1,1
confidence .9999
variance .0001*/
emission <1,.5,.2>/Size/Scale*Fader*B//*3.5
//absorption .5 
density {spherical
color_map {
[0 rgb 0]
[.2 rgb <1,.375,0>] 
[.2 rgb 5]
[.2125 rgb 5]  
[.25 rgb 2]
}
translate -2.5*Rate+Rand*z 
warp {turbulence .5 omega 0} 
translate 2.5*Rate-Rand*z  


scale 4
translate 6*Rate-Rand
rotate 20*Rate
warp {turbulence 1*(Rate/2+1/2) omega .125}
rotate -20*Rate
translate -6*Rate+Rand
scale 1/(4)
rotate (Rand*360)

scale 10
translate -6*Rate+Rand
rotate 20*Rate
warp {turbulence .75*(Rate/2+1/2) omega .125}
rotate -20*Rate
translate 6*Rate-Rand
scale 1/(10)
rotate (Rand*36)
 
scale .8  
}
#if (keyclock < .5)
#else
density { bozo
color_map{
[1.5*keyclock-(1.5/2) rgb 0]
[2*keyclock-1 rgb <1,.375,0>*2]
[2*keyclock-1 rgb 1]
[1.0 rgb 1]
}
scale 1/4
translate 2.5*Rate+Rand
warp {turbulence .5 }
translate -2.5*Rate+Rand  

scale 6
translate 2*clock+Rand+Rand
rotate 20*clock
warp {turbulence .2 omega 0}
rotate -20*clock
translate -2*clock-Rand+Rand
scale 1/6

rotate 323456*Rand+567567
}
#end


}
}
scale Scale 
scale Size
}
#end
#end

#end


#macro Streamer(Rand)
#declare S = rand(seed(Rand+Rand))*.125
#declare E = .85-(.35*rand(seed(Rand*Rand)))
#local SC = mod((clock-S)/(E-S),1)
#local SC = pow(SC,.5) 

#if (clock < E)
#declare C=0
#while (C<20)
#declare Max = 2.675
#declare Dist = (Max*rand(seed(C*C+Rand)))+Max/3
#declare Rot = ((10-5*SC)*rand(seed(C+Rand)))-(5-2.5*SC)  
#declare Rot2 = (-20*rand(seed(C*C*Rand))) 



disc {0,z,1 hollow on no_shadow
#declare Emis = ((<.5,.25,0>+(<1,.675,.675>*Dist/Max))-(<0,.5,.9>*SC))
#if (Emis.x < 0)
#declare EX = 0 
#else           
#declare EX = Emis.x 
#end
 
#if (Emis.y < 0)
#declare EY = 0
#else           
#declare EY = Emis.y
#end 

#if (Emis.z < 0)
#declare EZ = 0 
#else           
#declare EZ = Emis.z
#end
 
#declare Color =  <EX,EY,EZ>

pigment { onion
color_map {
[.5+.5*SC rgb (Color*2.5)*(rand(seed(C+Rand)))+(Color*2.5)/4 transmit 1*SC]
[1 transmit 1]
}
}
scale .5
scale (.125/2)*SC+.125  
scale <1+(1*rand(seed(Rand*C))),1+(.25*rand(seed(C+Rand*C))),1>
rotate 9000*(rand(seed(Rand+C)))*z
rotate 900*SC*(rand(seed(Rand*C)))*z

translate Dist*SC rotate Rot*z
scale .5*rand(seed(Rand))+.75 
rotate 4576567*Rand*z
rotate (-1767*rand(seed(Rand)))*z   
rotate (8767*rand(seed(Rand*Rand)))*z 
translate (.2*rand(seed(C*C*Rand))-.1)*z  
translate -(.2*rand(seed(C*Rand*Rand))-.1)*z 
translate -(.4*rand(seed(C))-.2)*z
} 

#declare C=C+1
#end           
#end                   

#end

  

#declare RandomNumber = 45799;

//Exp(R,B,S,E,Size) 
Exp(RandomNumber,1.25,0,1,5)

#declare B=0
#while (B<15)
Streamer(RandomNumber*B) 
#declare B=B+1
#end      

//sphere {1.5*z,1.5 pigment {rgb .5}}


global_settings {max_trace_level 100}  

light_source {<20,20,-20> rgb 1}
//background {rgb .125}