                   
default {
  texture {
    pigment { rgb <0,1,0> }
  }
}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

sky_sphere
{
  pigment
  {
    gradient z
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

background { color <0.000,0.000,0.000> }
         
#include "campath1.pov"
//#declare   cam_location  = <         0,      -120.0,     40.8000>;
//#declare   look_location = <         0,       0  ,      20.0>; 
//#declare   cam_location  = cam_end;
//#declare   look_location = look_end;
                                                                   
camera {  
  location  cam_location
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   look_location
}

//
// *******  L I G H T S *******
//

#declare i =0;
#while (i < 16)  


light_source
{
  vrotate(vrotate(<298,0,0>,-15*y), 360 * (i/16) * z) 
  color rgb <1,1,1>
  spotlight              
  point_at vrotate(<270, 0, 0>, 360 * (i/16) * z)
  radius 15        
  tightness 25     
  falloff 45       
}  

         
#declare i = i +1;
#end                        

#declare i =0;
#while (i < 4)  

light_source
{                    
  #declare light_x = i / 3 * 150 -75;
  #if (mod(i,2) = 0)
      #declare light_y = 50;
  #else
      #declare light_y = -50;
  #end
  <light_x, light_y, 50> 
  color rgb <1,1,1>        // light's color
/*  spotlight              
  point_at <light_x, 0, 0>
  radius 15                // hotspot (inner, in degrees)
  tightness 25            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 45  */             // intensity falloff radius (outer, in degrees)
}   
#declare i = i + 1;
#end

                        

light_source {
  <-600.000, -600.000, 600.000>
  color rgb <1.000, 1.000, 1.000>
}
light_source {
  <0.000, 200.000, 200.000>
  color rgb <1.000, 1.000, 1.000>
}
light_source {
  <00.000, -800.000, -100.000>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  MATERIALS  *******
//

// ----------------------------------------            


cylinder
{ -1*z,  0.1*z,  300
      material
   {   
      texture
      {      
         pigment
         {
            color rgb 0.1
            //color rgb 1
            
         }      
         normal
         {
            wrinkles , 0.5
         }      
         finish
         {
            ambient 0.3
            phong 0.5
            phong_size 10.0
            roughness 0.9
         }
      }
   }      
}


difference {
   sphere { <0, 0, 0> 300 }
   sphere { <0, 0, 0> 299 }
   box { <-10,-10,30> <10,10,70> 
         translate -300*y
       }     
   plane { z, 0}
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 8
            color_map
            {
               [ 0.0     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   rotate 90*x
   }
}

#declare turn_multiplier = 6;
#declare main_degree = clock * 360 * turn_multiplier; 


#include "robot1.inc"       
#declare numrobot1 = 6;       
#declare i =0;
#while (i < numrobot1)    
   #if (mod(i,2))
      #declare wdegree = main_degree;
      #declare y_robot_pos = 7.5;
      #declare z_robot_rot = 0;
   #else
      #declare wdegree = 360 - main_degree;
      #declare y_robot_pos = -7.5;
      #declare z_robot_rot = 180;      
   #end
       
   
   #declare wdegree = mod(wdegree,360); 
   #if (wdegree < 0)
       #declare wdegree = wdegree + 360;
   #end
   
   #declare x_robot_pos = i * 10 -77.5;
   #declare z_robot_pos = 20;
   
   #include "robot1.pov"
   cylinder {
       <-5,4,0>, <5,4,0>, .8 
       rotate (main_degree + z_robot_rot) * x
       translate <0 + x_robot_pos, 0, 33.8> 
       material {
         Brass_Metal
       }            
   }
   cylinder {
       <-5,4,0>, <-5,0,0>, .8 
       rotate (main_degree + z_robot_rot) * x
       translate <0 + x_robot_pos, 0, 33.8> 
       material {
         Brass_Metal
       }            
   }  
   cylinder {
       <5,4,0>, <5,0,0>, .8 
       rotate (main_degree + z_robot_rot) * x
       translate <0 + x_robot_pos, 0, 33.8> 
       material {
         Brass_Metal
       }            
   }
   sphere {
       <-5, 4, 0> 0.8
       rotate (main_degree + z_robot_rot) * x
       translate <0 + x_robot_pos, 0, 33.8> 
       material {
         Brass_Metal
       }            
   } 
   sphere {
       <5, 4, 0> 0.8
       rotate (main_degree + z_robot_rot) * x
       translate <0 + x_robot_pos, 0 , 33.8> 
       material {
         Brass_Metal
       }            
   } 

  
   #declare i = i +1;
#end       
cylinder {
    <-5,0,0>, <5,0,0>, .8                      
    translate <-10 - 77.5, 0, 33.8> 
    material {
      Brass_Metal
    }            
}
sphere {
    <5, 0, 0> 0.8
    translate <-10 -77.5, 0, 33.8> 
    material {
      Brass_Metal
    }            
} 
cylinder {
    <-5,0,0>, <5,0,0>, .8                      
    translate <60 -77.5, 0, 33.8> 
    material {
      Brass_Metal
    }            
}
sphere {
    <0, 0, 0> 0.8
    translate <55 -77.5, 0, 33.8> 
    material {
      Brass_Metal
    }            
} 
#include "axlehold.pov"
object {
   Axle_Handle            
   rotate 90*z
   translate <-7.5 -77.5, 0 ,20>
}

object {
   Axle_Handle            
   rotate 90*z
   translate <57.5 -77.5, 0 ,20>
}


#declare gear_m = 1;
#declare gear_z = 15;
#declare gear_flank = 2;
#declare gear_alpha = 20;                                  
#version 3.0;
#include "gear.inc"
#version 3.1;
                        
object {       
   difference {
      object {GEAR_OBJ}
      difference {   
         cylinder{ 4.5*y, 0.25*y, 5}      
         sphere { <0, -.5, 0> 2}
      }                           
      difference {   
         cylinder{ -4.5*y, -0.25*y, 5}      
         sphere { <0, .5, 0> 2}
      }
   }                              
   material {
      Aluminum
   }
 bounded_by { cylinder {-2*y, 2*y, 8}} 
 rotate <0,-main_degree,90>
 translate <65 -77.5, 0, 33.8> 
}                                                                            
                          

#declare gear_m = 1;
#declare gear_z = 25;
#declare gear_flank = 2;
#declare gear_alpha = 20;                                  
#version 3.0;
#include "gear.inc"
#version 3.1;
                        
object {       
   difference {
      object {GEAR_OBJ}
      difference {   
         cylinder{ 4.5*y, 0.25*y, 9}      
         sphere { <0, -.5, 0> 3}
      }                           
      difference {   
         cylinder{ -4.5*y, -0.25*y, 9}      
         sphere { <0, .5, 0> 3}
      }
   }                              
   material {
      Aluminum
   }                                  
 bounded_by { cylinder {-2*y, 2*y, 15}} 
 rotate <90,0,90+main_degree*15/25>
 translate <0, 0, 41.3> }  


cylinder // Main post
{
  0*z,  350*z,  2       
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 2
            color_map
            {
               [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   rotate 90*x
   }

   rotate z * main_degree*15/25 
}

superellipsoid { 
  <1.0, 5.0> 
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 1
            color_map
            {
               [ 0.0     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   rotate 90*x        
   rotate 90*z
   }

  scale <10.0, 1.0, 1.0>
  scale 20 
  translate z*350
  rotate z * main_degree*15/25
}    

    
#declare gear_m = 1;
#declare gear_z = 25;
#declare gear_flank = 2;
#declare gear_alpha = 20;                                  
#version 3.0;
#include "gear.inc"
#version 3.1;
                        
object {       
   difference {
      object {GEAR_OBJ}
      difference {   
         cylinder{ 4.5*y, 0.25*y, 9}      
         sphere { <0, -.5, 0> 2}
      }                           
      difference {   
         cylinder{ -4.5*y, -0.25*y, 9}      
         sphere { <0, .5, 0> 2}
      }
   }                              
   material {
      Aluminum
   }                                  
 bounded_by { cylinder {-2*y, 2*y, 15}} 
 rotate <90,0,90-main_degree*15/25>
 translate <25, 0, 41.3> }  
                   
#declare R2Degree = main_degree;

cylinder {
   -12.5*x, 12.5*x, 0.4 
   material {Brass_Metal}
   rotate -R2Degree * z
   translate 27.9 * z
   translate 25*x
}                            
cylinder {
    0*z, 21.3*z , .8                      
    translate 25*x 
    translate 20*z
    material {Brass_Metal}            
}
#include "Robot2.pov"

object { Robot2     
         scale <-1, 1, 1> 
         translate 25*x
         translate 20*z
       }                         
       
#declare R2Degree = main_degree + 180;

#include "Robot2.pov"

object { Robot2      
         scale <-1,1,1>     
         translate 25*x
         translate 20*z
       } 
       
#declare gear_m = 1;
#declare gear_z = 25;
#declare gear_flank = 2;
#declare gear_alpha = 20;                                  
#version 3.0;
#include "gear.inc"
#version 3.1;
                        
object {       
   difference {
      object {GEAR_OBJ}
      difference {   
         cylinder{ 4.5*y, 0.25*y, 9}      
         sphere { <0, -.5, 0> 2}
      }                           
      difference {   
         cylinder{ -4.5*y, -0.25*y, 9}      
         sphere { <0, .5, 0> 2}
      }
   }                              
   material {
      Aluminum
   }                                  
 bounded_by { cylinder {-2*y, 2*y, 15}} 
 rotate <90,0,main_degree*15/25>
 translate <50, 0, 41.3> }  
                   
#declare R2Degree = main_degree + 90;
cylinder {
   -12.5*x, 12.5*x, 0.4 
   material {Brass_Metal}
   rotate R2Degree * z
   translate 27.9 * z
   translate 50*x
}                            
cylinder {
    0*z, 21.3*z , .8                      
    translate 50*x 
    translate 20*z
    material {Brass_Metal}            
}

#include "Robot2.pov"
object { Robot2     
        
         translate 50*x
         translate 20*z
       }                         
       
#declare R2Degree = main_degree + 270;
#include "Robot2.pov"
object { Robot2           
         translate 50*x
         translate 20*z
       }                                      
       
#declare gear_m = 1;
#declare gear_z = 25;
#declare gear_flank = 2;
#declare gear_alpha = 20;                                  
#version 3.0;
#include "gear.inc"
#version 3.1;
                        
object {       
   difference {
      object {GEAR_OBJ}
      difference {   
         cylinder{ 4.5*y, 0.25*y, 9}      
         sphere { <0, -.5, 0> 2}
      }                           
      difference {   
         cylinder{ -4.5*y, -0.25*y, 9}      
         sphere { <0, .5, 0> 2}
      }
   }                              
   material {
      Aluminum
   }                                  
 bounded_by { cylinder {-2*y, 2*y, 15}} 
 rotate <90,0,90-main_degree*15/25>
 translate <75, 0, 41.3> }  
                   
#declare R2Degree = main_degree;

cylinder {
   -12.5*x, 12.5*x, 0.4 
   material {Brass_Metal}
   rotate -R2Degree * z
   translate 27.9 * z
   translate 75*x
}
cylinder {
    0*z, 21.3*z , .8                      
    translate 75*x 
    translate 20*z
    material {Brass_Metal}            
}
                            

#include "Robot2.pov"

object { Robot2     
         scale <-1, 1, 1>       
         translate 75*x
         translate 20*z
       }                         
       
#declare R2Degree = main_degree + 180;

#include "Robot2.pov"

object { Robot2      
         scale <-1,1,1>     
         translate 75*x
         translate 20*z
       } 
                                                                      
#include "robot3.pov"                                                                      

#include "bridge.pov"