//  Persistance of Vision Raytracer V3.1

//  World definition file.

//

//  Contains 1 lights, 4 materials and 46 primitives.

//

//  This file was generated for POV-Ray V3.1 by

//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar

//



//  Date : 11/10/1999    (10.11.1999)

//



/*

  The text between these two comments is in MorayPOV.INC and is

  automatically included in all POV files that Moray exports.

*/



//

// ********  REFERENCED OBJECTS  *******

//







//

// ********  OBJECTS  *******

//



//a is the angle of the ankle

//b is the angle of the knee

//c is the angle of the hip

#switch (wdegree)

   #range(0,90)

      #declare adegree = 0;

      #declare bdegree = 0;

      #declare cdegree = 10 * (wdegree/90);

      #break

   #range(90,180)

      #declare adegree =  30 * ((wdegree-90)/90);

      #declare bdegree = -45 * ((wdegree-90)/90);

      #declare cdegree =  10 + 35 * ((wdegree-90)/90);

      #break 

   #range(180,270) 

      #declare adegree =  30 + 15 * ((wdegree-180)/90);

      #declare bdegree = -45 - 45 * ((wdegree-180)/90);      

      #declare cdegree = +45 + 15 * ((wdegree-180)/90);

      #break

   #else

      #declare adegree = +45 - 45 * ((wdegree-270)/90);

      #declare bdegree = -90 + 90 * ((wdegree-270)/90);

      #declare cdegree = +60 - 60 * ((wdegree-270)/90);

#end

                                                               

#declare pos_shoulder = vrotate(vrotate(vrotate(<0,0,6>, x * (cdegree)) + <0,0,4.5>, x * (bdegree)) + <0,0,6.3>, x * (adegree));

#declare pos_crank    = vrotate(<0,4,0>, x * (wdegree)) + <0, -7.5, 13.8>;

         

// ok hard part...

// picture shoulder (i), elbow (j), and hand on crank(k) form a triangle. The sides I J K are opposite those vertices         

#declare Jlength = vlength(pos_crank - pos_shoulder); 

// Lengths of I and K are known (part of robot)

// Law of cosines gives us j (the degree to bend elbow)

#declare jdegree = degrees(acos((Jlength*Jlength - 9 - 20.25)/ (-2 * 3 * 4.5)));



// Same law give us i (the degree that the shoulder must bend from k to j)

#declare idegree = degrees(acos((20.25 - Jlength*Jlength -9)/ (-2 * 3 * Jlength))); 

#declare shoulder_degree = - (adegree + bdegree + cdegree)  - 90; //that will keep the upper arm level with ground

#declare shoulder_degree = shoulder_degree + degrees(asin((pos_shoulder.z - pos_crank.z)/Jlength)) + idegree;



// I put all this debug stuff in to make sure that jlength never exceeded the length of the robot's arms

//#debug concat("wdegree = ", str(wdegree,5,0),"\n")

//#debug concat("adegree = ", str(adegree,5,0),"\n")

//#debug concat("bdegree = ", str(bdegree,5,0),"\n")

//#debug concat("cdegree = ", str(cdegree,5,0),"\n")   

//#debug concat("pos_sho = ", str(pos_shoulder.x,2,2), " " , str(pos_shoulder.y,2,2), " ", str(pos_shoulder.z,2,2), "\n")

//#debug concat("pos_cra = ", str(pos_crank.x,2,2), " " , str(pos_crank.y,2,2), " ", str(pos_crank.z,2,2), "\n")

//#debug concat("idegree = ", str(idegree,5,2),"\n")

//#debug concat("jdegree = ", str(jdegree,5,2),"\n")

//#debug concat("Jlength = ", str(Jlength,5,2),"\n")

//#debug concat("sdegree = ", str(shoulder_degree,5,2),"\n")

//#debug "\n\n"





#declare Foot1 = difference {

  cylinder { // Cylndr005

    <0,0,1>, <0,0,0>, 1 

    scale <1.0, 1.0, 1.5>

    translate  -0.5*z

  }

  plane { // Plane003

    z,0

    rotate 90.0*x

  }

  material {

    Aluminum

  }

  rotate <-90.0, 0.0, -90.0>

  translate  3.25*x

}

#declare Foot2 = difference {

  cylinder { // Cylndr006

    <0,0,1>, <0,0,0>, 1 

    scale <1.0, 1.0, 1.5>

    translate  -0.5*z

  }

  plane { // Plane004

    z,0

    rotate 90.0*x

  }

  material {

    Aluminum

  }

  rotate <-90.0, 0.0, -90.0>

  translate  -3.75*x

}

#declare LowerLegGroup1 = union {

  cylinder { // LowerLeg1

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 4.5>

    rotate 180.0*z

  }

  sphere { // Ankle1

    <0,0,0>,1

    material {

      Brass_Metal

    }

    translate  0.0*x

  }

  translate  <3.5, 0.0, 1.8>

}

#declare LowerLegGroup2 = union {

  cylinder { // LowerLeg2

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 4.5>

    rotate 180.0*z

  }

  sphere { // Ankle2

    <0,0,0>,1

    material {

      Brass_Metal

    }

  }

  translate  <-3.5, 0.0, 1.8>

}

#declare UpperLegGroup2 = union {

  cylinder { // UpperLeg2

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 4.5>

    rotate 180.0*z

  }

  sphere { // Knee2

    <0,0,0>,1

    material {

      Brass_Metal

    }

  }

  translate  -3.5*x

}

#declare UpperLegGroup1 = union {

  cylinder { // UpperLeg1

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 4.5>

    rotate 180.0*z

  }

  sphere { // Knee1

    <0,0,0>,1

    material {

      Brass_Metal

    }

  }

  translate  3.5*x

}

#declare HeadMain = union {

  sphere { // RightHead

    <0,0,0>,1

    material {

      Aluminum

    }

    translate  <-2.5, 0.0, 5.0>

  }

  sphere { // LeftHead

    <0,0,0>,1

    material {

      Aluminum

    }

    translate  <2.5, 0.0, 5.0>

  }

  cylinder { // HeadCyl

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <1.0, 1.0, 5.0>

    rotate -90.0*y

    translate  <2.5, 0.0, 5.0>

  }

}

#declare HeadCSG = difference {

  object { HeadMain }

  sphere { // EyeRight

    <0,0,0>,1

    scale 0.5

    translate  <-1.75, -1.0, 5.0>

  }

  sphere { // EyeLeft

    <0,0,0>,1

    scale 0.5

    translate  <1.75, -1.0, 5.0>

  }

  box { // FaceCut1

    <-1, -1, -1>, <1, 1, 1>

    scale <0.7, 0.4, 0.075>

    translate  <0.0, -1.0, 5.4>

  }

  box { // FaceCut2

    <-1, -1, -1>, <1, 1, 1>

    scale <0.7, 0.4, 0.075>

    translate  <0.0, -1.0, 5.0>

  }

  box { // FaceCut3

    <-1, -1, -1>, <1, 1, 1>

    scale <0.7, 0.4, 0.075>

    translate  <0.0, -1.0, 4.6>

  }

  material {

    Aluminum

  }

  translate  -2.0*z

}

#declare WholeHead = union {

  object { HeadCSG }

  sphere { // Eye1

    <0,0,0>,1

    material {

      EyeColor

    }

    scale 0.25

    translate  <-1.75, -0.75, 3.0>

  }

  sphere { // Eye2

    <0,0,0>,1

    material {

      EyeColor

    }

    scale 0.25

    translate  <1.75, -0.75, 3.0>

  }

  sphere { // NeckBottom

    <0,0,0>,1

    material {

      Brass_Metal

    }

    scale 0.7

  }

  cylinder { // Neck

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.4, 0.4, 3.0>

  }

  translate  6.8*z

}

#declare Hand1 = difference {

  cylinder { // Cylndr001

    <0,0,1>, <0,0,0>, 1 

    scale <1.0, 1.0, 0.5>

  }

  cylinder { // Cylndr002

    <0,0,1>, <0,0,0>, 1 

    scale <0.8, 0.8, 1.2>

    translate  -0.1*z

  }

  plane { // Plane001

    z,0

    rotate 90.0*x

  }

  material {

    Aluminum

  }

  rotate <-90.0, 0.0, -90.0>

  translate  <-0.25, 0.0, -4.5>

}

#declare LowerArmGroup1 = union {

  cylinder { // LowerArm1

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.5, 0.5, 3.0>

    rotate <180.0, 0.0, 180.0>

  }

  sphere { // Wrist1

    <0,0,0>,1

    material {

      Brass_Metal

    }

    scale 0.67

    translate  -3.0*z

  }

  object { Hand1 }

  rotate (-180.0+jdegree)*x

  translate  -3.0*z

}

#declare UpperArmGroup1 = union {

  cylinder { // UpperArm1

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.5, 0.5, 3.0>

    rotate <180.0, 0.0, 180.0>

  }

  sphere { // Elbow1

    <0,0,0>,1

    material {

      Brass_Metal

    }

    scale 0.67

    translate  -3.0*z

  }

  object { LowerArmGroup1 }

  rotate shoulder_degree*x

  translate  <3.5, 0.0, 6.0>

}

#declare Hand2 = difference {

  cylinder { // Cylndr003

    <0,0,1>, <0,0,0>, 1 

    scale <1.0, 1.0, 0.5>

  }

  cylinder { // Cylndr004

    <0,0,1>, <0,0,0>, 1 

    scale <0.8, 0.8, 1.2>

    translate  -0.1*z

  }

  plane { // Plane002

    z,0

    rotate 90.0*x

  }

  material {

    Aluminum

  }

  rotate <-90.0, 0.0, -90.0>

  translate  <-0.25, 0.0, -4.5>

}

#declare LowerArmGroup2 = union {

  cylinder { // LowerArm2

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.5, 0.5, 3.0>

    rotate <180.0, 0.0, 180.0>

  }

  sphere { // Wrist2

    <0,0,0>,1

    material {

      Brass_Metal

    }

    scale 0.67

    translate  -3.0*z

  }

  object { Hand2 }

  rotate (-180.0+jdegree)*x

  translate  -3.0*z

}

#declare UpperArmGroup2 = union {

  cylinder { // UpperArm2

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.5, 0.5, 3.0>

    rotate <180.0, 0.0, 180.0>

  }

  sphere { // Elbow2

    <0,0,0>,1

    material {

      Brass_Metal

    }

    scale 0.67

    translate  -3.0*z

  }

  object { LowerArmGroup2 }

  rotate shoulder_degree*x

  translate  <-3.5, 0.0, 6.0>

}

#declare BodyR1 = union {

  sphere { // Hip1

    <0,0,0>,1

    material {

      Brass_Metal

    }

    translate  -3.5*x

  }

  sphere { // Hip2

    <0,0,0>,1

    material {

      Brass_Metal

    }

    translate  3.5*x

  }

  cylinder { // Hip

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 7.0>

    rotate -90.0*y

    translate  3.5*x

  }

  cylinder { // Body

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 6.0>

  }

  sphere { // Shoulder2

    <0,0,0>,1

    material {

      Brass_Metal

    }

    translate  <-3.5, 0.0, 6.0>

  }

  sphere { // Shoulder1

    <0,0,0>,1

    material {

      Brass_Metal

    }

    translate  <3.5, 0.0, 6.0>

  }

  cylinder { // Shoulder

    <0,0,1>, <0,0,0>, 1 

    material {

      Aluminum

    }

    scale <0.75, 0.75, 7.0>

    rotate -90.0*y

    translate  <3.5, 0.0, 6.0>

  }

  object { WholeHead }

  object { UpperArmGroup1 }

  object { UpperArmGroup2 }

  rotate cdegree*x

  translate  4.4*z

}

#declare UpperLegsR1 = union {

  object { UpperLegGroup2 }

  object { UpperLegGroup1 }

  object { BodyR1 }

  rotate bdegree*x

  translate  6.3*z

}

#declare LowerLegsR1 = union {

  object { LowerLegGroup1 }

  object { LowerLegGroup2 }

  object { UpperLegsR1 }

}

#declare FeetR1 = union {

  object { Foot1 }

  object { Foot2 }

  object { LowerLegsR1 }

  rotate adegree*x

}

union { // Robot1

  object { FeetR1 }

  rotate z_robot_rot*z

  translate <x_robot_pos, y_robot_pos, z_robot_pos>

}









