//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Parts of this file generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  and fubar'ed by rjchase

//  Date : 11/14/1999    (Date of last render Robot.mdl)
//
//  - The Robot project has been in the works for a couple weeks now;
//  it would be appropriate to add a few comments.
//  - Thanks again to Moray for modeling and a kool texture editor.
//  - Thanks to ROBOT.mdl included with Moray for robot Wrist_Base.
//  and for not having to reinvent the wheel.
//  - Versions 4 and later use J_Robot.inc, which holds all declares,
//  making the .POV file easier to manage (shorter).
//  - Animation feature added with vers. 4a  11/21/99  rjchase
//  - After a few animation renders:  Thinking of creating separate
//  files for each Robot_Grp, so that they can be animated separately.
//  - Re-introducing Slab from Moray, twice as x and half as y and z.
//  - Animating final touches with J_Rob4c.pov. PovPeopl move independent
//  of Robot_GRP.  Next step is to move Robot_GRPs separately.
//  Clock from 1.0 to 2.0, cyclic animation.  
//  - Incorporated a conditional A_Laser for selected frames 11/28/99  
//  - Separated all refs to J_Robot into an include file. 1/2/00
//  #switch used instead of #declare when referencing Robo_GRP.inc
//  Robot_GRP.inc will be invoked as an include file.  Added RoboClock.
//  - Added WideCam and OrthoCam to camera declares (J_Robot5a) 1/10/00
//
//  "And now, back to our regularly scheduled broadcast...."

//  Standard garbled message follows
//  best to leave these ancient scrawlings alone. ;)
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
/*  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
*/
}

// Includes

#include "j_robtxt.inc" // scene texture file 
#include "person.inc"   //  POV People file
#include "j_robot5a.inc"  //  scene object declares

//          //
//  CAMERA  //
//          //
// edit out cam to render specific view
//
camera {
    //StdCam  // standard view left-hand coords
    //OverView  // looking down y axis   
    //WideCam  // wide angle StdCam
    OrthoCam  // StdCam modified with ortho project
    }                   

//
// *******  L I G H T S *******
//
  // edit out 
  /*
light_source {   // Light1
  <1.986, 17.481, 51.342>
  color rgb <0.3, 0.3, 0.3>
  shadowless
}
  // edit out shadowless light source
*/
light_source {  // Light2
  <1, 0.25, 50> // plus z is out of screen
  color rgb <0.35, 0.35, 0.57>
    }

//
// ********  OBJECTS  *******
//  ta-daaaah!
// edit out while working on Robo_GRP macros
plane { // Floor
  z,0
  material {
    Floor_MAT
  }
  translate 0.1*y
  rotate -90.0*x
  hollow
}

//          //
//  WALL    //
//          //
object { Wall_CSG
  translate <-1, 5, -20> // use -20*y for StdCam
 }

//                  //
// TRANSFORM SLAB   //
//                  //
object { Slab_GRP 
        //scale <2.0, 0.5, 0.3> // from scale <2.0, 0.5, 0.5>
        //rotate 180*y
        translate <0, 1.5, 1>
        }

//              //
//  TRANSFORM   //
// SLAB PEOPLE  //
//              //
#declare SlabPeopleX = -(4*clock);  // move right to left on slab
object { Slab_People
  translate <SlabPeopleX, 0, 0>  // for animation right to left
  }
        
//                  //
//  T'FORM ROBOTS   //
//                  //

#declare RoboClock = clock;  // USE 2 CYCLE CLOCK
//
//  ROBOT 1

#switch (RoboClock)
    #range (0.0, 0.4)
     #declare Laser = false;
      #break
    #range (0.4, 0.7)
     #declare Laser = true;
      #break
    #range (0.7, 2.1)
     #declare Laser = false;
      #break
  #end
#include "Robo_GRP.inc"
object { Robot_GRP  // robot 1  //  center Rob_GRPx.inc
    rotate <0.0, 15+Robot_GrpY, 0.0>  // rotate Robot body
    translate <0, -0.01, -1.5>      //  for animation
} // end ROBOT 1

//  ROBOT 2
#declare RoboClock = clock + 0.5;
#switch (RoboClock)
    #range (0.0, 2.0)
     #declare Laser = false;
      #break
    #range (2.0, 2.37)
     #declare Laser = true;
      #break
    #range (2.37, 2.6)
     #declare Laser = false;
      #break
    #end
#include "Robo_GRP.inc"
object { Robot_GRP  // robot 2  // right Rob_GRPx.inc
    rotate <0.0, 150-Robot_GrpY, 0.0>  //180-Robot_GrpY
    translate <6, -0.01, 3.5>  
    }
    
//  ROBOT 3
#declare RoboClock = clock + 1;

#switch (RoboClock)
    #range (0.0, 1.6)
     #declare Laser = false;
      #break
    #range (1.6, 2.0)
     #declare Laser = true;
      #break
    #range (2.0, 3.0)
     #declare Laser = false;
      #break      
  #end
#include "Robo_GRP.inc"
object { Robot_GRP  // robot 3  // left Rob_GRPx.inc
    rotate <0.0, 150+Robot_GrpY, 0.0>  //180
    translate <-6, -0.01, 3.5>
    }
        
//                      //
// END OF ROBOT5.POV    //
//                      //