//  Declare Objects Include file.
//
// for most versions of J_Robot
//                             
#declare StdCam = camera {  //  StdCam
  location  < 8.000, 2.731, 80>  // from z=80       
  direction < 0.0, 0.0, 5> // Aperture is 0.18 degrees
  sky       < 0.0, 1.0, 0.0> // Use left handed-system (rotated by 150.00 degrees)!
  up        < 0.0, 1.0, 0.0> // Where y is up
  right     < -1.34, 0.0, 0.0> // Aspect ratio
  look_at   < -1, 1.0, 0>
}

#declare OverView = camera {  //  OverView
  location  < 1.000, 100.0, 1.0>       
  direction < 0.0, 0.0, 5> // Aperture is 0.18 degrees 5.6843
  sky       < 0.0, 1.0, 0.0> // Use left handed-system (rotated by 150.00 degrees)!
  up        < 0.0, 1.0, 0.0> // Where y is up
  right     < -1.34, 0.0, 0.0> // Aspect ratio
  look_at   < 1, 1.7, 0>
}

#declare WideCam = camera{ // Wide View 
  panoramic // fisheye | ultra_wide_angle | omnimax | panoramic 
  location  < 0.000, 6, 80>  // from z=80       
  direction < 0.0, 0.0, 30> // Aperture is 0.18 degrees
  up        y
  right     < -1.34, 0.0, 0.0> // Aspect ratio
  angle     90
  sky       < 0.0, 1.0, 0.0> // Use left handed-system (rotated by 150.00 degrees)!
  up        < 0.0, 1.0, 0.0> // Where y is up
  look_at   < -1, 1.0, 0>
}

#declare OrthoCam = camera {  //  StdCam modified with orthographic
  location  < 0, 6, 70>  // from z=80       
  direction < 0.0, 0.0, 5> // Aperture is 0.18 degrees
  sky       < 0.0, 1.0, 0.0> // Use left handed-system (rotated by 150.00 degrees)!
  up        < 0.0, 1.0, 0.0> // Where y is up
  right     < -1.34, 0.0, 0.0> // Aspect ratio
  look_at   < 0, 1.0, -1.0>
  orthographic
}

//
// ********  REFERENCED OBJECTS  *******
//

#declare Slab_Stand1 = lathe {
  linear_spline
  6  // control points
  <1.0, -1.0>,
  <0.948485, -0.735606>,
  <0.290909, -0.622727>,
  <0.454545, 0.484848>,
  <0.8, 0.692424>,
  <0.954545, 1.015152>
  rotate <90,0,90>
  material {
    ChromeTexture
  }
  scale <1.0, 1.0, 0.7>
  rotate -90.0*x
  translate  -0.8*y
  
}

#declare Slab_Roller = object {
  cylinder { // Slab_Roller
    <0,0,1>, <0,0,0>, 1 
    scale -0.1
    translate  1.1*z
    material {
      Aluminum
    }
  }
}

#declare Wall_Panel = prism {  // for Panel_Wall
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  translate  -5.0*x
  hollow
  scale <1.5, 4.0, 2.5>
  translate  <-0.056735, 0.00424, -1.36>
  material {
    LGray
    // Huh?
    }
}

//  OBJECTS *********************** //
//          //
//  WALL    //
//          //

#declare Wall_CSG = difference { // Wall_CSG
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    material {
      RJMarble
    }
    scale <20.0, 5.0, 1.0>
  }
  object { Wall_Panel }
  object { // Wall_Panel3->Wall_Panel
    Wall_Panel
    translate  25.0*x
  }
  object { // Wall_Panel2->Wall_Panel
    Wall_Panel
    translate  20.0*x
  }
  object { // Wall_Panel3->Wall_Panel
    Wall_Panel
    translate  15.0*x
  }
  object { // Wall_Panel2->Wall_Panel
    Wall_Panel
    translate  10.0*x
  }
  object { // Wall_Panel1->Wall_Panel
    Wall_Panel
    translate  5.0*x
  }
  object { // Wall_Panel1->Wall_Panel
    Wall_Panel
    translate  -5.0*x
  }
  object { // Wall_Panel1->Wall_Panel
    Wall_Panel
    translate  -10.0*x
  }
  material {
    RJMarble
  } 
}

//               //
//      SLAB     //
//               //
// What POV_People Sleep on
//
#declare Slab_CSG = union {
  box { // Slab
    <-1, -1, -1>, <1, 1, 1>
    material {
      ChromeTexture
    }
    scale <20.0, 0.25, 1.0>
  }
  object { Slab_Roller }
  object { // Slab_Roller1->Slab_Roller
    Slab_Roller
    translate  -2.0*x
  }
  object { // Slab_Roller2->Slab_Roller
    Slab_Roller
    translate  -4.0*x
  }
  object { // Slab_Roller3->Slab_Roller
    Slab_Roller
    translate  -6.0*x
  }
  object { // Slab_Roller4->Slab_Roller
    Slab_Roller
    translate  -8.0*x
  }
  object { // Slab_Roller5->Slab_Roller
    Slab_Roller
    translate  -10.0*x
  }
  object { // Slab_Roller6->Slab_Roller
    Slab_Roller
    translate  2.0*x
  }
  object { // Slab_Roller7->Slab_Roller
    Slab_Roller
    translate  4.0*x
  }
  object { // Slab_Roller8->Slab_Roller
    Slab_Roller
    translate  6.0*x
  }
  object { // Slab_Roller9->Slab_Roller
    Slab_Roller
    translate  8.0*x
  }
  object { // Slab_Roller10->Slab_Roller
    Slab_Roller
    translate  10.0*x
  }
} //  end Slab_CSG

#declare Slab_GRP = union { // Slab_GRP
  object { // Slab_Stand2->Slab_Stand1
    Slab_Stand1
    translate  <-8.0, -0.0, 0.0>
  }
  object { Slab_Stand1 }
  object { // Slab_Stand3->Slab_Stand1
    Slab_Stand1
    translate  <8.0, -0.0, 0.0>
  }
  object { Slab_CSG }
} // end Slab_GRP

//                   //
//       SLAB           //
//  PEOPLE           //
//               // 
//  five slab people move through clock 1.0 to 2.0
#declare Slab_People = union {
    object { Person
        scale 6.0
        // rotate
        rotate <0, 90, 90>
        translate <-8, 2.0, 1>
        }

    object { Person
        scale 6.0
        // rotate
        rotate <0, 90, 90>
        translate <0, 2.0, 1>
        }
    
    object { Person
        scale 6.0
        // rotate
        rotate <0, 90, 90>
        translate <8.0, 2.0, 1>
        }
    object { Person
        scale 6.0
        // rotate
        rotate <0, 90, 90>
        translate <16.0, 2.0, 1>
        }
    object { Person
        scale 6.0
        // rotate
        rotate <0, 90, 90>
        translate <24.0, 2.0, 1>
        }
 
    } //end union Slab_People

