//  Robot Macro Include file.
//
// contains only references to the actual ROBOT
// All other declares, lights, cams, and objects are in J_Robot5.inc
//                             
//          //
//  ACTION  //
//          //
// Declare Robot animation tforms
// A two-cycle clock is used to move SlabPeopleX
// and the robots.  First cycle: robots raise arms
#switch ( RoboClock ) 
    #range( 0 , 1 ) 
        #declare LFingerX = 60.0 + (30*RoboClock); // 90 open, 60 close 
        #declare WristX = 30 + (15*RoboClock);    // bend wrist down
        #declare WristZ = -15 + (15*RoboClock);    // rotate wrist 
        #declare ForeArmX = 60 + (30*RoboClock);    // bend ForeArm
        #declare RobotArmX = -30 - (30*RoboClock);  // raise-/lower+ 
        #declare Robot_GrpY = -(30*RoboClock);  // rotate robot
     #break
    #range( 1 , 2 )
        #declare RoboClock2 = RoboClock-1; 
        #declare LFingerX = 90 - (30*RoboClock2); 
        #declare WristX = 45 - (15*RoboClock2); 
        #declare WristZ = -(15*RoboClock2);   
        #declare ForeArmX = 90 - (30*RoboClock2); 
        #declare RobotArmX = -60 + (30*RoboClock2);
        #declare Robot_GrpY = -30+(30*RoboClock2);  
     #break
    #range( 2 , 3 )
        #declare RoboClock3 = RoboClock-2;  // return to original position
        #declare LFingerX = 60.0 + (30*RoboClock3); // 90 open, 60 close fingers
        #declare WristX = 30 + (15*RoboClock3);    // bend wrist down
        #declare WristZ = -15 + (15*RoboClock3);    // rotate wrist clockwise
        #declare ForeArmX = 60 + (30*RoboClock3);    // bend ForeArm
        #declare RobotArmX = -30 - (30*RoboClock3);  // raise-/lower+ robot arm
        #declare Robot_GrpY = -(30*RoboClock3);  // rotate robot l to r
     #break
#end

//  REFERENCED OBJECTS

#declare FingerTip = union {  // from TUTOR4C.mdl
  cylinder { 
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 0.5>
  }
  sphere { 
    <0,0,0>,1
    scale 0.08
    translate  0.5*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.16>
    rotate -90.0*y
    translate  0.08*x
  }
  rotate -80.0*x
  translate  0.6*z
}

#declare LeftFinger1 = union {  // from TUTOR4C.mdl
  cylinder { 
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 0.6>
  }
  object { FingerTip }
      material {
        Aluminum
      }   
  rotate <LFingerX, 0.0, 0.0>  // animate fingers
  translate  1.3*z
}             

#declare A_Laser = union {
    cylinder { // Laser_Light
      <0,0,0>, <0,0,2>, 1
      hollow 
      material {
        Ruby_Laser
      }
      scale <0.1, 0.1, 2.0>
      // rotate -90.0*y
      }
    light_source {   // Light1
      <0.000, 0.000, 2.0>
      color rgb <1.000, 0.000, 0.000>
      }
} // end A_Laser


//                    //
//      ROBOT        //
//                  //
// what Picks at POV_People
//
#declare Rob_Stand = lathe {
  linear_spline
  10  // control points
  <0.899975, -1.099404>,
  <0.862562, -0.900685>,
  <0.808737, -0.813477>,
  <0.714529, -0.787527>,
  <0.416126, -0.773162>,
  <0.260297, -0.706254>,
  <0.219016, -0.563922>,
  <0.184231, -0.110731>,
  <0.180106, 0.476563>,
  <0.177403, 1.011584>
  rotate <90,0,90>
  material {
    ChromeTexture
  }
  rotate -90.0*x
  translate  1.0*y
}

#declare WristFront = union {  // purloined from TUTUR4C.mdl
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, -0.3, 0.2>
    translate  1.1*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum 
    }
    scale <0.2, 0.2, 1.0>
  }
  object { LeftFinger1 }
  object { // LeftFinger2->LeftFinger1
    LeftFinger1
    rotate -180.0*z
    translate  0.3*x
  }
  object { // RightFinger->LeftFinger1
    LeftFinger1
    rotate 180.0*z
    translate  -0.3*x
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.5, 0.0, 1.3>
  }

//  conditional for temporary laser light *********

    #if (Laser)
      object {A_Laser}
    #end
  translate  0.1*z
}


#declare WristBase = union {  // from ROBOT4C.mdl
  object { WristFront }
  cylinder { // Wrist_Joint
    <0,0,1>, <0,0,0>, 1 
    scale 0.4
    rotate -90.0*z
  }
  rotate <WristX, 0.0, WristZ > // animate WristBase 
  scale 0.5                 // up and down x, rotate z
  translate  1.25*z
}        

#declare ForeArm_CSG = union {
  cylinder { // Elbow1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.3, 0.2>
    translate  -0.2*z
  }
  cylinder { // Elbow2
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.3, 0.3, 0.15>
    rotate -90.0*y
    translate  0.075*x
  }
  box { // ForeArm
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.1, 0.1, 0.75>
    translate  0.75*z
  }
  object { WristBase }
  rotate <ForeArmX, 0, 0>  // animate ForeArm
  translate  <-0.125, 0.0, 1.5>
}

#declare Upper_Arm_CSG = union {
  cylinder { // Rob_Shoulder
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.5, 0.5, 0.25>
    rotate <0.0, -90.0, 0.0>
  }
  cylinder { // Shoulder2
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale 0.3
    rotate -90.0*y
    translate  0.025*x
  }
  box { // Upper_Arm
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.15, 0.15, 0.5>
    translate  <-0.125, 0.0, 0.75>
  }
  object { ForeArm_CSG }
  cylinder { // Upper_Arm_Cyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.3>
    translate  <-0.125, 0.25, 0.0>
  }
  material {
    Aluminum
  }
  translate  0.125*x
  rotate <RobotArmX, 0, 0,>  // for animation
}

#declare Robot_Arm = object
     { Upper_Arm_CSG
        translate  <0.0, 3.5, 0.75>
        }
     
#declare Robot_GRP = union { // Rob_GRP
  object { Rob_Stand }
  sphere { // Rob_Body
    <0,0,0>,1
    material {
      Rob_Body_TXT
    }
    translate  3.0*y
  }
  object { Robot_Arm }
} // end Robot_GRP                                  
