#include "colors.inc"

#declare EMFWood =
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map {
            [0.0, 0.1 color rgb <0.88, 0.60, 0.4>
                      color rgb <0.88, 0.60, 0.4>]
            [0.1, 0.9 color rgb <0.88, 0.60, 0.4>
                      color rgb <0.60, 0.40, 0.3>]
            [0.9, 1.0 color rgb <0.60, 0.40, 0.3>
                      color rgb <0.60, 0.40, 0.3>]
        }
    }
    finish {
        specular 0.25
        roughness 0.05
        ambient 0.45
        diffuse 0.33
        reflection 0.15
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1>
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map {
            [0.0, 0.1 color rgbf <0.7, 0.6, 0.4, 0.100>
                      color rgbf <0.8, 0.6, 0.3, 0.500>]
            [0.1, 0.9 color rgbf <0.8, 0.6, 0.3, 0.650>
                      color rgbf <0.6, 0.4, 0.2, 0.975>]
            [0.9, 1.0 color rgbf <0.6, 0.4, 0.2, 0.975>
                      color rgbf <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish {
        specular 0.25
        roughness 0.0005
        ambient .1
        diffuse 0.33
    }
}
texture {
    pigment { rgbf <0.75, 0.15, 0.0, 0.95> }
    finish {
        specular 0.25
        roughness 0.01
        ambient 0
        diffuse 0.33
    }
}

#declare T_Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }
 
 #declare T_Grnt3a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.831, 0.631, 0.569, 0.447>
                    color rgbf <0.925, 0.831, 0.714, 0.678>]
    [0.153, 0.297   color rgbf <0.925, 0.831, 0.714, 0.678>
                    color rgbf <0.871, 0.702, 0.659, 0.475>]
    [0.297, 0.441   color rgbf <0.871, 0.702, 0.659, 0.475>
                    color rgbf <0.831, 0.631, 0.569, 0.918>]
    [0.441, 0.763   color rgbf <0.831, 0.631, 0.569, 0.918>
                    color rgbf <0.937, 0.882, 0.820, 0.655>]
    [0.763, 1.001   color rgbf <0.937, 0.882, 0.820, 0.655>
                    color rgbf <0.831, 0.631, 0.569, 0.447>]
   }
 }
 }
 
 #declare T_Grnt20 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color Mica color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]
   }
 }
 }
 
 #declare T_Crack3 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color DarkGreen filter 0.80 color DarkGreen filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }
 
//------------- Dark Brown & Tan swirl Granite with gray undertones
#declare EMFStone1 =
texture{pigment{color Black}}
texture{T_Grnt17a scale <3, 6, 2> rotate <0, 0, 50>}
texture{T_Grnt3a scale <1, 2, 1> rotate <0, 0, -50>
        finish{}
}

//------------- White Marble with gray veining
#declare EMFStone2 =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9}
}
texture{T_Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{}
}

#declare Cloud1 =
pigment {
    wrinkles
    turbulence 0.2
    lambda 2.2
    omega 0.707
    color_map {
        [0.10 color rgb <87/255, 139/255, 217/255> ]
        [0.40 color rgb <97/255, 175/255, 243/255> ]
        [0.65 White*0.89 ]
        [0.80 White*0.92 ]
        [1.00 White ]
    }
    scale <0.5, 0.15, 1>
}

#declare my_ss = sky_sphere {
    pigment { Cloud1 }
    pigment { rgbf < 0, 0, 0, #if (clock<1) 1 #else 1-((clock-1)/2) #end> }
}

//*****************************************************************************************************
//*****************************************************************************************************
#declare myScale = 1

#declare EC = clock

#switch (EC*8)
//********** Path #1 **********
   #range (-0.01,1)
         #declare myClock = EC*8
         #declare myT = myClock
         #declare myX = myT
         #declare myY = 1-(((sin(-(pi/2)+(pi*myT)))+1)/2)
   #break
//********** Path #2 **********
   #range (1,2)
         #declare myClock = (EC*8)-1
         #declare myT = myClock
         #declare myX = 1
         #declare myY = myT
   #break
//********** Path #3 **********
   #range (2,3)
         #declare myClock = (EC*8)-2
         #declare myT = myClock
         #declare myX = 1-myT
         #declare myY = 1-(((sin(-(pi/2)+(pi*myT)))+1)/2)
   #break
//********** Path #4 **********
   #range (3,4)
         #declare myClock = (EC*8)-3
         #declare myT = myClock
         #declare myX = 0
         #declare myY = myT
   #break
//********** Path #5 **********
   #range (4,5)
         #declare myClock = (EC*8)-4
         #declare myT = myClock
         #declare myX = ((sin(-(pi/2)+(pi*myT)))+1)/2
         #declare myY = 1-myT
   #break
//********** Path #6 **********
   #range (5,6)
         #declare myClock = (EC*8)-5
         #declare myT = myClock
         #declare myX = 1-myT
         #declare myY = 0
   #break
//********** Path #7 **********
   #range (6,7)
         #declare myClock = (EC*8)-6
         #declare myT = myClock
         #declare myX = ((sin(-(pi/2)+(pi*myT)))+1)/2
         #declare myY = myT
   #break
//********** Path #8 **********
   #range (7,8.01)
         #declare myClock = (EC*8)-7
         #declare myT = myClock
         #declare myX = 1-myT
         #declare myY = 1
   #break

   #else

#end



#declare myObjLoc = <myX*8,1,myY*8>
#declare myCamLoc = <10,10,-9.5>

camera {
  up <0,1,0>
  right <1.3846,0,0>
  location myCamLoc
  angle 10
  look_at myObjLoc
}

light_source{ <56,200,-100> color rgb <1,1,210/255> }
light_source{ myCamLoc color rgb 0.4*<1,1,1> }

sky_sphere { my_ss }

#declare sScale = 0.5
#declare myStone = texture { checker texture{EMFStone2 scale sScale }, texture{EMFStone1 scale sScale} scale 1.001 }
box{ <0,0,0>  <8,-8/30,8> texture { myStone } scale 1.2 translate <-0.8, 0, -0.8> }

#declare myHFObjLoc = <myX*8,1,myY*8>

#declare wScale = 1/2
#declare myWood = texture{ EMFWood scale 1/2 }
#declare myMaXG = 50
#declare myAcc = 0.001
isosurface{ function {"FMeta4",<myX,1-myY>,library"h_foct"}
                   bounded_by{ box {<-1.1,-1.05,-1.1>,<1.5,1.05,1.1>}}
                   method 2
                   max_gradient myMaXG
                   accuracy myAcc
                   texture { myWood }
                   scale <1,1,-1>
                   rotate <0,0,0>
                   translate myHFObjLoc
       }
