// TOY-Boy.inc -- Definitions for TOY-Boy's body
// Version 1.2 -- Complex controls removed 
// Copyright 1999 Jeffrey D. Shaffer -- All Rights Reserved.

/*           TABLE of Contents
             -----------------
             1) misc. controls
             2) arm
             3) torso
             4) leg_curve_cut
             5) leg
             6) head
             7) hat
             8) head_with_hat
             9) TOY-Boy
*/


#include "metals.inc" 

//
// ----------------- misc. controls --------------------
//

#declare lft = 0;
#declare rt = 1;

//
// ------------------ arms & torso ----------------------
//

#macro Arm (arm, motion)
   union {
      difference {
         superellipsoid {
            <0.75, 0.4>
            scale <0.47, 0.52, 2.7>
            rotate 90*x
            }
         box {
            <0.15, -3, -0.6>, <0.6, -2.2, 0.6>
            }
         box {
            <-0.15, -3, -0.6>, <-10.6, -2.2, 0.6>
            }
         translate -2.3*y
         }
      difference {
         superellipsoid {
            <0.75, 0.4>
            scale <0.47, 0.52, 2>
            rotate 90*x
            }
         box {
            <-0.2, 1.5, -0.6>, <0.2, 2.1, 0.6>
            }
         translate -1.7*y
         rotate 100*motion*x                   // initial angle of elbow
         #if (arm = 0)                  // elbow motion control point
            rotate -10*sin(2*pi*clock*loop)*motion*x
         #else
            rotate 10*sin(2*pi*clock*loop)*motion*x
         #end
         translate -4.83*y
         }
      material {
         texture {
            T_Chrome_5E
            }
         }
      }
   #end


#macro Torso (motion) union {        // torso with arms included
   difference { 
      cylinder {
         <0, -0.75, 0>, <0, 7.25, 0>, 1 
         scale <2, 1, 1>
         }
      box {
         <.8, -0.85, -1.1>, <2.2, 0.75, 1.1>
         }
      box {
         <-2.2, -0.85, -1.1>, <-0.8, 0.75, 1.1>
         }
      material {
         texture {
            T_Chrome_5E
            }
         }
      }
   object { Arm (lft, motion)
      rotate 30*sin(2*pi*clock*loop)*motion*x                  // shoulder rotation point
      translate <2.5, 6.75, 0>
      }
   object { Arm (rt, motion)
      rotate 30*sin(2*pi*(clock+(0.5/loop))*loop)*motion*x     // shoulder rotation point
      translate <-2.5, 6.75, 0>
      }
   }
#end

//
// ----------------------- legs -------------------------
//


#declare leg_curve_cut = prism { // cut away for lower leg
   linear_sweep
   linear_spline
   -1.0,0.0
   8
   <-1.0, -0.607219>,
   <1.0, -0.607219>,
   <1.0, 1.010616>,
   <0.57431, 0.61518>,
   <0.010616, 0.453291>,
   <-0.521231, 0.599257>,
   <-1.0, 1.0>,
   <-1.0, -0.607219>
   scale <0.7, 0.5, 0.6>
   rotate <0, 90, 90>
}

#macro Leg (leg, motion)        // Leg with motion control
   #if (leg = 0) 
      #declare H = -50*sin(2*pi*clock*loop)*motion;  // Hip rotation point
      #declare K = -abs(80*(sin(pi*clock*loop)))*motion; // Knee rotation point
      #declare A = abs(40*sin(pi*clock*loop))*motion; // Ankle rotation point
   #else
      #declare H = -50*sin(2*pi*(clock+(0.5/loop))*loop)*motion;
      #declare K = -abs(80*sin(pi*(clock+(0.5/loop))*loop))*motion;
      #declare A = abs(40*sin(pi*(clock+(0.5/loop))*loop))*motion;
   #end

// start definition
union { 
   union {
      object {  // foot
         difference {
            box { 
               <-.65, -0.5, -2>, <.65, .2, .5>
            }
            box { 
               <-0.25, -0.25, -0.65>, <0.25, 0.25, 0.55>
            }
         }
         material {
            texture {
            T_Chrome_5E
            }
         }
      rotate A*x // foot moves with respect to lower leg
   }
      object { // lower_leg 
         difference { 
         superellipsoid { // Calf
            <0.75, 0.4>
            scale <0.6, 2, 0.6>
         }
         box { 
            <0, 0, 0>, <.4, .7, 1.6>
            translate  <-.2, 1.5, -0.8>
         }
         object { leg_curve_cut 
            translate <-0.65, -1.8, 0>
         }
         object { leg_curve_cut 
            translate <0.15, -1.8, 0>
         }
         translate <0, -1.7, 0>
         material {
            texture {
            T_Chrome_5E
            }
         }
         translate 3.5*y
         }
      }
      translate -3.5*y
      rotate K*x // lower leg moves with respect to upper leg
      translate 3.5*y
   }
   object { 
      difference {
      superellipsoid { 
         <0.75, 0.4>
         scale <0.6, 2.2, 0.6>
      }
      box { 
         <0, 0, 0>, <0.55, 0.7, 1.3>
         translate  <0.2, -2.4, -.62>
      }
      box { 
         <0, 0, 0>, <0.55, 0.7, 1.3>
         translate  <-0.75, -2.4, -.62>
      }
      translate <0, -1.9, 0>
      }
      material {
         texture {
            T_Chrome_5E
            }
      }
      translate  <0, 7.35, 0>
   }
   translate -6.8*y
   rotate H*x // hip moves with respect to torso
   translate 7.5*y
}
#end  // end definition

//
// --------------------- head & hat ------------------------
//


#declare Head = union {
   superellipsoid { // Left Eyebrow
      <1.0, 1.0>
      scale <0.6, 0.125, 0.05>
      translate <-1, 1.5, -2>
   }
   superellipsoid { // Right Eyebrow
      <1.0, 1.0>
      scale <0.6, 0.125, 0.05>
      translate <1, 1.5, -2>
   }
   object { // Left Eye
      sphere { 
         <1, 0.6, -2>,0.5
      }
   }
   object { // Right Eye
      sphere { 
         <-1, 0.6, -2>,0.5
      }
   }
   cone { // Nose
      <0,0,-2.5>, 0.3, <0,0,-4.5>, 0
   }
   sphere { // main part
      <0,0,0>,2.5
   }
   translate <0, 2.5, 0>
   material {
      texture {
            T_Chrome_5E
            }
   }
}

#declare Hat = union {
   cone {  // The Pointy Part
      <0, 0, 0>, 2, <0, 4, 0>, 0
   }
   cylinder { // The Brim
      <0, 0, 0>, <0, 0.1, 0> 3.5
   }
   material {
      texture {
            T_Chrome_5E
            }
   }
}

#declare Head_with_Hat = union {
   object { Hat
      translate <0, 4.4, 0>
   }
   object { Head }
   translate 7.25*y
}
       
//
// ---------------------- Put him all together! ------------------
//
       
#macro TOY_Boy (motion)   union {
   object { Leg (lft, motion)       // commands: which leg, what motion
      translate 1.55*x}
   object { Leg (rt, motion)
      translate -1.55*x}
   object { Torso (motion)  
      rotate -10*x*motion
      translate 7.75*y
      rotate -8*sin(2*pi*clock*loop)*motion*y // body rocks with leg motion
      }
   object { Head_with_Hat
      rotate -10*x*motion
      translate 7.75*y
      }
   translate 0.5*abs(sin(2*pi*clock*loop+0.3))*motion*y // slight bounce when he runs
   }
   #end
   