// saw.inc -- Copyright 1999 Jeffery D. Shaffer
// rotary saw (like a RIP saw), used to chase TOY-Boy in runner.pov

/*alignment: 
        1) blade facing -z
        2) center of base at <0, 1, 0>
        3) y is 0 so that saw is off the table
*/
        

#include "metals.inc"


//
// -------------  SAW: blade and arms ----------------
//

#declare cutter = difference {
   box { <-0.4, -0.3, -0.1>, <0.4, 0.3, 0.1> }
   box { <-1, -0.4, -0.11>, <1, 0.4, 0.11> 
      rotate -40*z
      translate 0.7*x}
   box { <-1, -0.4, -0.11>, <1, 0.4, 0.11> 
      rotate <0, 0, -65>
      translate -0.75*x}
   scale <1.2, 1, 1>
   rotate <0, 0, -6>
   translate 1.85*y
   }

#declare blade = difference {
   cylinder { <0, 0, -0.05>, <0, 0, 0.05> 2
      material { 
         texture {
            T_Chrome_5C
            }
         }
      }
   #declare counter = 0;
   #while (counter < 360)
      object { cutter 
         rotate counter*z
         }
      #declare counter=counter+40;
   #end
   rotate 1800*(360*clock*20)*z // rotation point for blade
   translate -5*x
   }

#declare saw = union {
   union {
      sphere {<0, 0, 0>, 1 }
      cylinder {<-5, 0.25, -0.2>, <0, 0.825, -0.2>, 0.125 }
      cylinder {<-5, -0.25, -0.2>, <0, -0.825, -0.2>, 0.125 }
      cylinder {<-2.5, -0.55, -0.2>, <-2.5, 0.55, -0.2>, 0.125 }
      cylinder {<-1.5, -0.65, -0.2>, <-1.5, 0.65, -0.2>, 0.125 }
      cylinder {<-5, 0.25, 0.2>, <0, 0.825, 0.2>, 0.125 }
      cylinder {<-5, -0.25, 0.2>, <0, -0.825, 0.2>, 0.125 }
      cylinder {<-2.5, -0.55, 0.2>, <-2.5, 0.55, 0.2>, 0.125 }
      cylinder {<-1.5, -0.65, 0.2>, <-1.5, 0.65, 0.2>, 0.125 }
      sphere {<-5, 0, 0>, 0.5 }
      material {
         texture {
            T_Chrome_5C
            pigment { color rgb <0.15, 0.15, 1>}
            }
         }
     } 
   object {blade}
   rotate -12*z
   rotate -90*y
   translate 1*y
   scale 5
   }