//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 17 materials and 325 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 05/16/2000    (16.05.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from XSmallFluoro.mdl:
This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

//
// *******  V A R I A B L E S *******
//                           

#declare duration = 10;
#declare secs = clock * duration;
#declare R1 = seed(75);

//
// *******  M A C R O S *******
//                     

#include "MyMacros.inc"

//
// *******  C A M E R A S *******
//                     

camera {  //  Camera StdCam
  #declare times = array [12] {0,0,1,2,3,4,5,6,7,8,9,10}
  #declare locations = array[12] {<20000,-14000,500>,<18000,-12000,500>,<15000,-10000,450>,<12000,-8000,500>,<9000,-8000,500>,<7000,-6000,400>,<4000,-5000,350>,<3000,-3000,300>,<1500,-2500,200>,<500,-2000,150>,<0,-1500,100>,<0,-550,110>}
  location Bezier(times,locations,secs)
  #debug concat("Camera Location is:","\n",str(Bezier(times,locations,secs).x,5,0),"\n",str(Bezier(times,locations,secs).y,5,0),"\n",str(Bezier(times,locations,secs).z,5,0),"\n")  
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,      100.000>
}
//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight003
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.600>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 0
  media_interaction off
  scale 10000.0
  rotate 45.0*x
  translate  <0.0, -30000.0, 30000.0>
}

#declare starts = array [6] {0,1,3,5,7,9}
#declare ends = array [6] {1,3,5,7,9,11}
#declare colours = array [6] {<1.0, 0.0, 0.0>,<0,0,0>,<1.0, 0.0, 0.0>,<0,0,0>,<1.0, 0.0, 0.0>,<0,0,0>}
#declare Arealight001 = light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb Position(starts,ends,colours,secs)*2.0000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 2, 2
  adaptive 1
  fade_distance  200.0
  fade_power 5.0
  media_interaction off
  translate  286.0*z
}


#declare Arealight002 = light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.900>
  area_light <0.100, 0.000, 0.000>, <0.000, 2.000, 0.000>, 1, 7
  adaptive 1
  fade_distance  1000.0
  fade_power 2.0
  media_interaction off
  scale <0.5, 3.0, 1.0>
  rotate <0.0, -45.0, -0.0>
}



//
// ********  MATERIALS  *******
//

#include "approach.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//



union { // Sky
  sphere { // Horizon
    <0,0,0>,1
    material {
      Snow
    }
    scale 12000.0
    translate  -12000.04*z
  }
  sphere { // LowCloud
    <0,0,0>,1
    material {
      T_Cloud2
    }
    no_shadow
    hollow
    scale 12020.0
    translate  -12000.04*z
  }
  sphere { // MediumCloud
    <0,0,0>,1
    material {
      Stormy_Cloud_Sky
    }
    no_shadow
    hollow
    scale 12050.0
    translate  -12000.04*z
  }
  sphere { // HighCloud
    <0,0,0>,1
    material {
      nimrod
    }
    no_shadow
    hollow
    scale 12070.0
    translate  -12000.04*z
  }
  no_shadow
  hollow
  scale 1000.0
}


blob { // Blob_Snow
  threshold 0.5
  sphere { // Sphere001
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <-2.75, 0.25, 0.0>
  }
  sphere { // Sphere002
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <0.25, 2.25, 0.0>
  }
  sphere { // Sphere003
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <2.75, 0.5, 0.0>
  }
  sphere { // Ground
    <0,0,0>,1,1
    scale <2,2,2>
    scale <100.0, 100.0, 1.0>
    translate  -1.2*z
  }
  sphere { // Sphere004
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.25, 0.25, 0.0>
  }
  sphere { // Sphere005
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.5, 1.5, 0.0>
  }
  sphere { // Sphere006
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.5, 1.25, 0.0>
  }
  sphere { // Sphere007
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.5, -1.0, -0.5>
  }
  sphere { // Sphere008
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.25, -1.25, -0.5>
  }
  sphere { // Sphere009
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-2.5, 2.5, -0.5>
  }
  sphere { // Sphere010
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <3.0, 3.0, -0.5>
  }
  sphere { // Sphere011
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <0.0, 4.0, 0.5>
  }
  sphere { // Sphere012
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.75, 1.5, 0.5>
  }
  sphere { // Sphere013
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <2.0, 1.25, 0.5>
  }
  sphere { // Sphere014
    <0,0,0>,1,1
    scale <2,2,2>
    scale <1.0, 0.5, 0.5>
    rotate -55.0*z
    translate  <-1.0, 1.75, 0.25>
  }
  sphere { // Sphere015
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.75, -0.75, -0.5>
  }
  sphere { // Sphere016
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.0, -2.25, -0.75>
  }
  sphere { // Sphere017
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-2.5, -1.25, -0.75>
  }
  sphere { // Sphere018
    <0,0,0>,1,1
    scale <2,2,2>
    scale <1.0, 1.0, 0.5>
    translate  <0.25, 1.75, 0.75>
  }
  sphere { // Sphere019
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 2.0>
    translate  <-15.5, -11.0, -1.0>
  }
  sphere { // Sphere020
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-14.5, 8.5, -3.25>
  }
  sphere { // Sphere021
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-22.0, 0.0, -1.0>
  }
  sphere { // Sphere022
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-7.0, -1.0, -0.5>
  }
  sphere { // Sphere023
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 2.0>
    translate  <8.5, 15.0, -1.5>
  }
  sphere { // Sphere024
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-8.0, 16.25, -1.0>
  }
  sphere { // Sphere025
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-3.5, 9.25, -1.25>
  }
  sphere { // Sphere026
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-12.0, -33.25, -1.0>
  }
  sphere { // Sphere027
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <28.0, 15.5, -1.0>
  }
  sphere { // Sphere028
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <39.0, -10.0, -1.0>
  }
  sphere { // Sphere029
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <22.25, -6.5, -4.5>
  }
  sphere { // Sphere030
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-1.0, -25.5, -3.0>
  }
  sphere { // Sphere031
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <53.5, -24.0, -4.5>
  }
  sphere { // Sphere032
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <42.5, -48.0, -3.0>
  }
  sphere { // Sphere033
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <20.25, -46.0, -1.0>
  }
  sphere { // Sphere034
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-28.75, -15.75, -3.0>
  }
  sphere { // Sphere035
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <7.0, 28.25, -3.0>
  }
  sphere { // Sphere036
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-8.25, 36.75, -1.25>
  }
  sphere { // Sphere037
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-33.25, 21.5, -1.25>
  }
  sphere { // Sphere038
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-4.75, -10.75, -1.5>
  }
  sphere { // Sphere039
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <-6.5, -6.0, -0.75>
  }
  sphere { // Sphere040
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <10.0, 3.75, -1.25>
  }
  sphere { // Sphere041
    <0,0,0>,1,1
    scale <2,2,2>
    scale <5.0, 5.0, 1.0>
    translate  <7.5, -12.25, -1.5>
  }
  sphere { // Sphere042
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <9.0, -1.0, -1.25>
  }
  sphere { // Sphere043
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <8.0, 2.5, -1.25>
  }
  sphere { // Sphere044
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <5.75, 1.0, -0.5>
  }
  sphere { // Sphere045
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <-4.25, -1.0, -1.0>
  }
  sphere { // Sphere046
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.5, 0.2, 0.05>
    rotate -15.0*z
    translate  <0.25, -0.15, 1.0>
  }
  sphere { // Sphere047
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.5, 0.3, 0.075>
    translate  <0.0, 0.25, 1.0>
  }
  sphere { // Sphere048
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.25, 0.1, 0.025>
    translate  <-0.5, -0.25, 1.0>
  }
  sphere { // Sphere049
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.3, 0.3, 0.075>
    translate  <0.0, 0.75, 1.0>
  }
  material {
    Snow
  }
  scale 250.0
  translate  -20.0*z
}


#declare Pillars = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-100.0, -100.0, 100.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 0.0, 100.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 100.0, 100.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 0.0, 100.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 100.0, 100.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 200.0, 100.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 200.0, 100.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, -100.0, 100.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, -100.0, 100.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Beams = union {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, 215.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, 200.0, 215.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    translate  <200.0, 200.0, -15.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, -15.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, -15.0>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, -15.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, 215.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, 215.0>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    translate  <-200.0, 200.0, -15.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG001 = difference {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 12.0, 127.0>
    translate  <0.0, -100.0, 100.0>
  }
  box { // Door_Spacer
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 20.0, 81.0>
    translate  <50.0, -100.0, 81.0>
  }
}
#declare CSG002 = difference {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 167.0, 12.0>
    translate  <0.0, 50.0, -15.0>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 170.0, 30.0>
    translate  <0.0, 70.0, -15.0>
  }
}
#declare Walls = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <200.0, 50.0, 100.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <-200.0, 50.0, 100.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 167.0, 12.0>
    translate  <0.0, 50.0, 215.0>
  }
  object { CSG001 }
  object { CSG002 }
  material {
    Aluminum
  }
}
#declare Slab = difference {
  box { // Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <230.0, 180.0, 12.0>
    translate  <0.0, 50.0, -30.0>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 170.0, 30.0>
    translate  <0.0, 70.0, -15.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG003 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
}
#declare CSG004 = difference {
  object { CSG003 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
}
#declare CSG005 = intersection {
  object { CSG004 }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Door = union {
  object { CSG005 }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  material {
    T_Chrome_1A
  }
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG006 = union {
  object { TransSweep001 }
  object { TransSweep002 }
}
#declare CSG007 = difference {
  object { CSG006 }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Parts = union {
  object { CSG007 }
  material {
    Black_Rubber
  }
  // All transformations fixed
}
#declare Doorway = union {
  object { Door }
  object { Parts }
  material {
    T_Chrome_1A
  }
  translate  <50.0, -100.0, 0.0>
}
#declare Parts1 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 180.0>
    translate  240.0*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 90.0>
    translate  240.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 0.0>
    translate  240.0*z
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, -90.0>
    translate  240.0*z
  }
  sphere { // Sphere050
    <0,0,0>,1
    translate  240.0*z
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 45.0>
    translate  240.0*z
  }
  sphere { // Sphere051
    <0,0,0>,1
    material {
      Bulb
    }
    hollow
    scale 1.5
    translate  286.0*z
  }
  object { Arealight001 }
  sphere { // Glow
    <0,0,0>,1
    material {
      RedGlow
    }
    hollow
    scale 50.0
    translate  286.0*z
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  translate  5.0*z
}
#declare CSG008 = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG009 = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG010 = union {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG011 = union {
  object { CSG008 }
  object { CSG009 }
  object { CSG010 }
}
#declare CSG012 = union {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG013 = union {
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG014 = union {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG015 = union {
  object { CSG012 }
  object { CSG013 }
  object { CSG014 }
  scale 0.875
  translate  30.0*z
}
#declare CSG016 = union {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG017 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG018 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG019 = union {
  object { CSG016 }
  object { CSG017 }
  object { CSG018 }
  scale <0.765625, 0.76562, 0.76562>
  translate  56.25*z
}
#declare CSG020 = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG021 = union {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG022 = union {
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG023 = union {
  object { CSG020 }
  object { CSG021 }
  object { CSG022 }
  scale <0.669925, 0.66992, 0.669917>
  translate  79.21875*z
}
#declare CSG024 = union {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG025 = union {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG026 = union {
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG027 = union {
  object { CSG024 }
  object { CSG025 }
  object { CSG026 }
  scale <0.586185, 0.58618, 0.586177>
  translate  99.316406*z
}
#declare CSG028 = union {
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG029 = union {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG030 = union {
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG031 = union {
  object { CSG028 }
  object { CSG029 }
  object { CSG030 }
  scale <0.512915, 0.51291, 0.512904>
  translate  116.901855*z
}
#declare CSG032 = union {
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG033 = union {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG034 = union {
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG035 = union {
  object { CSG032 }
  object { CSG033 }
  object { CSG034 }
  scale <0.448801, 0.4488, 0.448794>
  translate  132.289123*z
}
#declare CSG036 = union {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG037 = union {
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG038 = union {
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG039 = union {
  object { CSG036 }
  object { CSG037 }
  object { CSG038 }
  scale <0.392701, 0.3927, 0.392695>
  translate  145.752983*z
}
#declare CSG040 = union {
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG041 = union {
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG042 = union {
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG043 = union {
  object { CSG040 }
  object { CSG041 }
  object { CSG042 }
  scale <0.343611, 0.34361, 0.343608>
  translate  157.533861*z
}
#declare CSG044 = union {
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG045 = union {
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG046 = union {
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG047 = union {
  object { CSG044 }
  object { CSG045 }
  object { CSG046 }
  scale <0.300661, 0.30066, 0.300654>
  translate  167.842129*z
}
#declare CSG048 = union {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG049 = union {
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG050 = union {
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG051 = union {
  object { CSG048 }
  object { CSG049 }
  object { CSG050 }
  scale <0.263077, 0.26308, 0.263074>
  translate  176.861865*z
}
#declare CSG052 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG053 = union {
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG054 = union {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG055 = union {
  object { CSG052 }
  object { CSG053 }
  object { CSG054 }
  scale <0.230187, 0.23019, 0.230188>
  translate  184.754134*z
}
#declare CSG056 = union {
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG057 = union {
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG058 = union {
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG059 = union {
  object { CSG056 }
  object { CSG057 }
  object { CSG058 }
  scale <0.201411, 0.20141, 0.201408>
  translate  191.65987*z
}
#declare CSG060 = union {
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG061 = union {
  object { CSG060 }
  scale <0.176232, 0.17623, 0.176228>
  translate  197.702388*z
}
#declare Struts = union {
  object { CSG011 }
  object { CSG015 }
  object { CSG019 }
  object { CSG023 }
  object { CSG027 }
  object { CSG031 }
  object { CSG035 }
  object { CSG039 }
  object { CSG043 }
  object { CSG047 }
  object { CSG051 }
  object { CSG055 }
  object { CSG059 }
  object { CSG061 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  translate  5.0*z
}
#declare CSG062 = difference {
  sphere { // Sphere052
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere053
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar = union {
  object { CSG062 }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere054
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Translation fixed
  translate  240.0*z
}
#declare CSG063 = difference {
  sphere { // Sphere055
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere056
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar1 = union {
  object { CSG063 }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere057
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-30.0 to   0.0)
  // Translation fixed
  rotate <-30.0, 0.0, -120.0>
  translate  240.0*z
}
#declare CSG064 = difference {
  sphere { // Sphere058
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere059
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar2 = union {
  object { CSG064 }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere060
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Translation fixed
  rotate <15.0, 0.0, 120.0>
  translate  240.0*z
}
#declare Radars = union {
  object { Radar }
  object { Radar1 }
  object { Radar2 }
  material {
    T_Chrome_3E
  }
  // All transformations fixed
  translate  5.0*z
}
#declare Antenna = union {
  box { // Base
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <40.0, 40.0, 5.0>
    translate  5.0*z
  }
  object { Parts1 }
  object { Struts }
  object { Radars }
  translate  <-140.0, -40.0, 225.0>
}
#declare CSG065 = difference {
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    translate  <4.5, 0.1, -2.5>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 2.0, 0.8>
    translate  <4.5, 0.25, -2.5>
  }
  material {
    Black_Rubber
  }
}
#declare CSG066 = union {
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <6.0, 1.0, 3.0>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-5.0, -1.0, 3.0>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <5.0, -1.0, -3.0>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-5.0, -1.0, -3.0>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <5.0, -1.0, 3.0>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <5.0, 1.0, 4.0>
  }
}
#declare CSG067 = difference {
  object { CSG066 }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <1.0, 0.5, 1.0>
    translate  <4.0, 1.0, 2.0>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-3.5, 1.0, -2.5>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-2.0, 1.0, -2.5>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-0.5, 1.0, -2.5>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <1.0, 1.0, -2.5>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <2.5, 1.0, -2.5>
  }
  material {
    Aluminum
  }
}
#declare CardReader = union {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <2.1, 0.35, 0.5>
    translate  <-1.75, 1.25, -0.5>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <2.0, 0.05, 1.5>
    translate  <-1.75, 1.5, 0.75>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale 0.5
    translate  <-3.5, 1.0, -2.5>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <6.5, 0.75, 4.5>
    translate  -0.25*y
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <2.0, 0.05, 1.5>
    translate  <-1.75, 1.25, 0.75>
  }
  object { CSG065 }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Galaxy
    }
    scale <0.9, 0.05, 0.9>
    translate  <4.5, 1.0, -2.5>
  }
  object { CSG067 }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      RedLight
    }
    hollow
    scale <1.0, 0.5, 1.0>
    translate  <4.0, 1.0, 2.0>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale 0.5
    translate  <-2.0, 1.0, -2.5>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale 0.5
    translate  <-0.5, 1.0, -2.5>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale 0.5
    translate  <1.0, 1.0, -2.5>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale 0.5
    translate  <2.5, 1.0, -2.5>
  }
  scale <3.0, -3.0, 3.0>
  translate  <-50.0, -112.0, 115.0>
}
#declare SmallFluoro = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      FluoroTube
    }
    hollow
    scale <1.0, 1.0, 10.0>
    rotate 90.0*x
    translate  5.0*y
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*x
    translate  <0.0, -4.0, 0.75>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate -90.0*x
    translate  <0.0, 4.0, 0.75>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 1.0>
    translate  1.75*z
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate -90.0*x
    translate  <0.0, 4.5, 0.75>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <0.0, -4.5, 0.75>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 6.5, 1.0>
    translate  1.75*z
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass
    }
    scale <2.25, 2.25, 0.5>
    rotate -90.0*x
    translate  <0.0, 4.75, 0.75>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass
    }
    scale <2.25, 2.25, 0.5>
    rotate -90.0*x
    translate  <0.0, -5.25, 0.75>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 5.25, 0.25>
    translate  1.75*z
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 0.25, 1.125>
    translate  <0.0, -5.0, 1.875>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 0.25, 1.125>
    translate  <0.0, 5.0, 1.875>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    material {
      Thin_Glass
    }
    hollow
    scale <1.9, 1.9, 10.0>
    rotate 90.0*x
    translate  <0.0, 5.0, 0.75>
  }
  object { Arealight002 }
  material {
    T_Chrome_1A
  }
  hollow
  scale 3.0
  rotate <90.0, -270.0, 180.0>
  translate  <50.0, -121.0, 193.0>
}
union { // Hut
  object { Pillars }
  object { Beams }
  object { Walls }
  box { // Step
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <75.0, 20.0, 15.0>
    translate  <50.0, -125.0, -27.0>
  }
  object { Slab }
  object { Doorway }
  object { Antenna }
  object { CardReader }
  object { SmallFluoro }
  material {
    T_Chrome_1A
  }
  hollow
}


