
		/*
		Here's the problem:  In the first 1/6 of the camera movement, the viewing
		angle goes from 0.5 to 65 and the camera moves about 15,000 units.  I 
		found it very hard to keep the buildings properly in frame and with the 
		proper zoom on the camera.  It's like flying in on a jet fighter from a mile
		away and zooming the camera out from 100X zoom to 1X zoom in the span of 
		about 5 seconds.  I tried just using all kinds of functions to take the
		angle from .5 to 65, but I found it to be too much of a change to control.
		So I devised the method below which basically calculates what the camera
		angle should be in order to keep the width of the screen about the same at
		the center point of the structures (the lookat point).  I use the triangle 
		formed by the line between the lookat and the camera, the edge of the 
		screen at the lookat point and the camera, and the lookat point and the 
		edge of the screen at the lookat point.  
		The width of the screen does change some, but, the change is much easier to 
		control because it's less change.  The width of the screen changes by about 
		100% while the angle changes about 13000%.
		*/

		// This tells me the start and end points for the width of the screen at the
		// start and end of the opening movement.  These values were calculated
		// by hand after finding the proper starting and ending positions and angles                 
                #declare view_plane_start_width=126.8742645;
                #declare view_plane_end_width=238.3781269;
                
		// just need to declare these in the proper scope                
                #declare distance_to_focal_point=5;
                #declare view_plane_width=5;
                #declare camera_angle=65;

		// If we're coming in (the beginning of the animation, see the camera path
		// code for definition of the current_segment and segment increment variables)
                #if ( current_segment = 0 )
                        // calculate viewing plane width.  Just a linear interpolation 
			// of the start and end widths.
                        #declare view_plane_width=view_plane_start_width+((view_plane_end_width_0-view_plane_start_width_0)*segment_increment));
                        // calculate the distance from the focal point.  Nothin but 
			// good old geometry, specifically, the formula for the distance
			// between to points: d=((x1-x2)^2+(y1-y2)^2+(z1-z2)^2)^(1/2)
                        #declare distance_to_focal_point=sqrt(pow((abs(lookat_start_positions[current_segment].x)-abs(camera_position.x)),2)+pow((abs(lookat_start_positions[current_segment].y)-abs(camera_position.y)),2)+pow((abs(lookat_start_positions[current_segment].z)-abs(camera_position.z)),2));
                        // now calculate the angle.  More geometry,
			// actually trig: a=tan(opposite/adjacent)
                        #declare camera_angle=degrees(atan2(view_plane_width/distance_to_focal_point,1));                                                           
                #end
   
		/*
		Now just put the camera_angle variable in as the angle identifier variable 
		for you camera object and voila.  I acutally tweaked the angle change with
		a sin wave for smoother transitions, but I didn't include that here.  For
		the end of the animation, I basically just did the same as above, but in the
		opposite direction, i.e., the screen width got smaller instead of bigger
		*/



