		/*
		You must first divide the camera path into segments with key control points
		which mark the end of one segment and the beginning of the next.  First,
		declare how many segments you're going to have (you'll have one more control
		point than your total number of segments)
		*/

                #declare number_of_segments=6;

		/*
		Each element of this array is the start time of each segment, represented
		by the fraction of the entire movie at which that start point occurs.  For
		example, the start of the third segment will occur at 2/6 of the way into 
		the movie
		*/
                #declare start_times = array[number_of_segments]
                {              
                        0,
                        1/number_of_segments,
                        2/number_of_segments,
                        3/number_of_segments,
                        4/number_of_segments,
                        5/number_of_segments
                }
		/*
		Same deal as above, except this is for the end point of each segment.  Note
		that the endpoint of a segment needs to be the same as the beginning of the
		next segment
		*/        
                #declare end_times = array[number_of_segments]
                {       
                        1/number_of_segments,
                        2/number_of_segments,
                        3/number_of_segments,
                        4/number_of_segments,
                        5/number_of_segments,
                        1
                }
	
		// This just gives us an easy way to remember which segment we're in         
                #declare current_segment=floor(number_of_segments*(new_clock));

		// This if for the special case where the last frame will result in 
		// current_segment being 6 when it should be 5
                #if ( current_segment = number_of_segments )
                        #declare current_segment=5;
                #end

		// This is to easily reference what our start time for the current segment 
		// is
                #declare start_time=start_times[current_segment];
		// Same for the end time
                #declare end_time=end_times[current_segment];
        
		// This will give us a clock variable which is normalized for the current 
		// segment, i.e. segement_increment will progress from 0 to 1 during the 
		// current segment, even though the clock does not.
                #declare segment_increment=(clock-start_time)/(end_time-start_time);   
                
                #declare segment_increment_for_camera=segment_increment;
                
                #if ( current_segment = number_of_segments-1 )
                        #declare segment_increment_for_camera=pow(segment_increment,(3))+((-pow((2*(segment_increment-0.5)),2)+1)*0.05);
                #end
                
		/*
		Here is where you define the control points for each segment.  This
		particular array lists the xyz coordinates of the starting points for each
		segment.
		*/
                #declare start_positions = array[number_of_segments]
                {              
                        <10000,3400,-10000>,
                        <110,45,0>,
                        <0,20,130>,
                        <-170,20,170>,
                        <-70,55,40>,
                        <-70,15,-120>
                }
		/*
		And this array defines the xyz coordinates of the end points for each
		segment.  Note again that every endpoint should be the start point of the
		next segment.
		*/
                #declare end_positions = array[number_of_segments]
                {              
                        <110,45,0>,
                        <0,20,130>,
                        <-170,20,170>,
                        <-70,55,40>,
                        <-70,15,-120>,
                        <10000,3400,-10000>
                } 
		/*
		This part is a little wierd.  These arrays have alot to do with how the
		spline will curve (or not curve) in order to pass through all the points.
		Honestly, I just guess at initial values and then played with them until 
		they worked.  The term 'velocities' might be a bit misleading as I believe
		these values have more to do with the curvature of the spline than the 
		actual velocity of the camera through the spline.
		/*
                #declare start_velocities = array[number_of_segments]
                {              
                        <-1,-.34,1>,
                        <0,-10,100>,
                        <-100,0,20>,   
                        <-2,2,-10>,
                        <0,-1,-10>,
                        <100,34,-100>
                }
		/* 
		These values don't necessarily have to match the start values for good
		pathing, but I recommend doing that first and then tweaking them (these are
		pre tweaked).
		*/                    
                #declare end_velocities = array[number_of_segments]
                {              
                        <0,-1000,10000>,
                        <-100,0,20>, 
                        <-2,2,-10>,
                        <0,-1,-10>,
                        <100,34,-100>
                        <0.1,0.034,-0.1>,
                }                    
                
		// Just some easy ways to remember important info about the current segment
                #declare start_position=start_positions[current_segment];
                #declare end_position=end_positions[current_segment];
                #declare start_velocity=start_velocities[current_segment];
                #declare end_velocity=end_velocities[current_segment];
                                                                  
                /*
		Here is the actual spline building part.  This is the part I don't fully
		understand, but the nice part is that I don't really have to.  It just kind
		of works :-)
		*/

                #declare U=segment_increment;
                #declare u2=(U*U);
                #declare u3=(u2*U);
                #declare a0=((2*u3)-(3*u2)+1);
                #declare a1=((-2*u3)+(3*u2));
                #declare a2=(u3-(2*u2)+U);
                #declare a3=(u3-u2);
                
		// And voila, a spline path for the camera.  Just use this variable as your
		// cameras positions and it will be placed appropriately for each frame.
                #declare camera_position=(a0*start_position+a1*end_position+a2*start_velocity+a3*end_velocity);

		/* 
		I tweaked this path quite a bit with sin waves and such in order to get 
		appropriate acceleration and deceleration of the camera at the beginning 
		and end of the camera movement.  I didn't include this tweaking, but feel 
		free to email me if you'd like to discuss it.  If you want to see the above 
		code at work, I recommend using camera_position for the position of a ball
		or something and put the camera somewhere static so you can watch the ball
		move instead of the camera.  The nice thing is that this code is very
		configurable. just point in as many control points as you wish with
		appropriate values in all the arrays and you're set!
		*/                
