
	// Just some variable initialization
        #declare ball_counter=0; 
        #declare random_offset_delta=0;       

	// The waterfall is basically a parabolic funcion with some randomness
        #declare waterfall = blob
        {       
                threshold 0.29

		// These are to inject the needed randomness for a waterfall
                #declare random_offset = seed(1324);
                #declare random_arc = seed(5431);
                // This is the position where all the balls in the blob start from
		// (i.e., the point in the parabola where balls start)
		#declare x_pos = -3.8;
		// the counter so we know when to stop making balls
                #declare stream_counter = 0;         
		// So the falls go from -3.8 to -13.1     
                #while ( x_pos > -13.1 )
			// waterfall_clock is a normalized clock for this particular segment
                        #declare z_pos = 12.297 - 31*clock;
                        #declare arc_noise = (rand(random_arc)/4)+1;
                        #declare place_ball=1;
                        #declare random_offset_delta=0;   
                        //This makes it more efficient, plus, I have to do this since I have
                        //to use a ball counter, other wise, 256 values of z_pos don't always
                        //lie within the range of the waterfall existance
                        #declare z_pos_no_rand = z_pos;
                        #declare ball_counter=0;
                        #declare stream_counter = stream_counter+1;
                        #declare stream_offset = seed(stream_counter);
                        //I have to use a ball counter because the random_offset MUST be 
                        //randomized exactly the same number of times for each frame.  I 
                        //have to reseed it for every stream but it doesn't seem to stay 
                        //constant if you call it several thousand times.  So I split it up
                        //into streams so that each seed only gets randomized 256 times
                        #while ( ball_counter < 550 )            
                                #declare z_pos=z_pos_no_rand-random_offset_delta;
                                #if ( z_pos <= 0 )
                                         #if ( ((arc_noise*0.8*-.011763*(pow(z_pos, 4))) + 41.85 ) > -20 )
                                                sphere
                                                {
                                                	<x_pos,(arc_noise*0.8*-.011763*(pow(z_pos, 4))),(z_pos)>,0.6 ,1
                                        	}
                                	#end
                                #end          
                                #declare ball_counter = ball_counter + 1;    
                                #declare random_offset_delta= rand(random_offset);
                                #declare z_pos_no_rand=z_pos_no_rand-0.04166;
                        #end
                        #declare x_pos=x_pos-0.2-(rand(stream_offset)/5);    
                #end
		// this cylinder helps smooth out the top of the falls
                cylinder
                {
                        <-3.8,0,0>,<-13.1,0,0>, 0.6 , 1
                }       
                texture
                {       
                        waterfall_texture
                }  
                interior
                {
                        ior 1.01
                }
        }    
  