// Persistence of Vision Ray Tracer Scene Description File
// File: c.pov
// Vers: 3.1
// Desc: Alien Invasion - IRTC Anim 10/00 (Aliens)
// Date: 10.10.00
// Auth: Uwe Post, up@upcenter.de
// Take: C. Farbiger betritt Bhne

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

#include "typ.pov"

#declare clock1=clock;
//#declare clock1=2;

// ----------------------------------------
camera
{
  location  <0.0, 1, -4.0>   //0,1,-4
  direction 1.5*z
  right     4/3*x
  angle 20          // 35...20
  look_at   <0.4, 1,  0.0>  // 0,1,0 ... -0.4,...
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 2, -4> // <x y z> position of light
  point_at <0, 1, 0>      // direction of spotlight
  radius 9                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 11               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-1, 2, -4> // <x y z> position of light
  point_at <1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <1, 2, -4> // <x y z> position of light
  point_at <-1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}


// Bhne ----------------------------------------
plane { -y, 0 
 clipped_by { plane { -z,0 } }
 pigment {color rgb <0.7,0.5,0.3>}
}

plane { z, 0 
 clipped_by { plane { y,0 } }
 pigment {color rgb <0.7,0.4,0.3>}
}

// Vorhangumrandung
polygon {
    9,
    <-1.2, 0.0>, <-1.15, 1.85>,
    <0,1.9>,<1.15,1.85>,
    <1.2,0>,
    <3,0>,<3,3333>,
    <-3,3333>,<-3,0>
    pigment { color rgb <1, 0, 0> }
 }



// Vorhang
#declare Vorhang1 = texture
{
  pigment
  {
    gradient x
    turbulence 0.1  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency 15
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1
    turbulence 0.1
    frequency 30
    scale <0.1, 0.4, 0.1>
  }
}
#declare Vorhang2 = texture
{
  pigment
  {
    gradient x
    turbulence 0.11  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency 15
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1.01
    turbulence 0.11
    frequency 30
    phase 10
    scale <0.1, 0.41, 0.1>
  }
}

// Der eigentliche Vorhang
#declare vorh_auf=1.1; // ganz auf: 1.1

plane {
 z,0.05
 clipped_by { plane {x,0} }
 texture { Vorhang1 }
 translate -vorh_auf*x
}

plane {
 z,0.051
 clipped_by { plane {-x,0} }
 texture { Vorhang2 }
 translate vorh_auf*x
}
 


// Der Hintergrund

plane
{ z,2.4
 hollow
 pigment
 {
 // texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map
{
  sys "hgr1.bmp" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  once
} 
 translate <-0.5,-0.3,0>
 scale 4
 
 }
}


#declare typ3x=0;
#declare typ3y=0;
#if (clock1<=3)
 #declare typ3x=2-clock1/2;
 #declare typ3y=abs(sin(clock1*10))*0.02;
//#else
// #declare typ3x=2;
// #declare typ3y=abs(sin(20))*0.02;
#end 



// Farbiger
union
{
 object {   rumpf3  }
 object {   arm3  }
 object {   kopf3  }
 object {   gesicht  }
 scale <-0.45,0.5,0.5> 
 translate z
 translate (typ3x-1)*x*1.6
 translate y*typ3y
}


