// Persistence of Vision Ray Tracer Scene Description File
// File: e.pov
// Vers: 3.1
// Desc: Alien Invasion - IRTC Anim 10/00 (Aliens)
// Date: 10.10.00
// Auth: Uwe Post, up@upcenter.de
// Take: E. Kamerafahrt durch Typ 1, Keulenschlag, Kamerafahrt zurck

#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

#include "typ.pov"

#declare clock1=clock;
//#declare clock1=2;



// ----------------------------------------

//#declare cam_z=-4; // -4 bis 2.4 (6.4)
//#declare cam_z=-4+clock1*(2.1); // -4 bis 2.4

// zwischen 0 und 3 fhrt die Kamera nach hinten
// zwischen 5 und 8 zurck

#declare cam_x=0;

#if (clock1<3)
 #declare cam_z=-0.8-3.2*cos(clock1*pi/3);
 #declare cam_x=-0.8*sin(clock1*pi/3);
 #declare cam_angle=25;
 #if (clock1>2)
   #declare cam_angle=25+(clock1-2)*25
 #end
#end
#if (clock1>=3)
 #if (clock1<5)
  #declare cam_z=2.4;
  #declare cam_angle=50;
 #end
#end
#if (clock1>=5)
 #declare cam_z=-0.8-3.2*cos((clock1-5)*pi/3+pi);
 #declare cam_x= 0.5*sin((clock1-5)*pi/3);
 #declare cam_angle=25;
 #if (clock1<6)
   #declare cam_angle=25+(6-clock1)*25
 #end
#end


camera
{
  location  <cam_x, 1, cam_z>   //0,1,-4
  direction 1.5*z
  right     4/3*x
  angle cam_angle          // 35
  look_at   <0.0, 1,  1>  // 0,1,0
}

// Lichteffekte

#declare camera_location = < cam_x,1,cam_z> ; 
#declare camera_look_at = < 0,1,1> ; 
#declare effect_scale = .75;
#declare effect_location = < -2, 3, -4> ; 
#declare effect_type = "Spotlight" 
#include "Lens.inc" 
#declare effect_location = < 2, 3, -4> ; 
#declare effect_type = "Spotlight" 
#include "Lens.inc" 



sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb 0] [1.0 color rgb 0.1] }
  }
}


// Zuschauerraum
// Boden
plane { y, -1
 hollow
 pigment {color rgb <0.2,0.0,0.0>}
 normal {bumps 10 scale 0.2}
}

// Decke
plane { y, 3
 hollow
 pigment {color rgb <0.1,0.1,0.0>}
 normal {wood scale <0.1,0.1,5>}
}

// Wand hinten
plane { z, -20
 hollow
 pigment {color rgb <0.8,0.1,0.0>}
 normal {bumps 10 scale <0.05,1,0.05>}
}

// Wand rechts
plane { x, 5
 hollow
 pigment {color rgb <0.8,0.1,0.0>}
 normal {bumps 10 scale <0.05,1,0.05>}
}

// Wand links
plane { x, -5
 hollow
 pigment {color rgb <0.8,0.1,0.0>}
 normal {bumps 10 scale <0.05,1,0.05>}
}


// Zuschauer

#declare rs1=seed(84576);
#declare zux=-6;
#while (zux<6)
 #declare zuz=-1;
 #while (zuz>-20)
  
  sphere { 0,0.5+0.5*rand(rs1)
   pigment { color rgb <0,0,0> }
   scale <0.2,1,0.01>
   translate <zux,-0.5,zuz>
  }
  
  #declare zuz=zuz-2;
 #end
 #declare zux=zux+0.5;

#end





// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 2, -4> // <x y z> position of light
  point_at <0, 1, 0>      // direction of spotlight
  radius 9                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 11               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-1, 2, -4> // <x y z> position of light
  point_at <1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <1, 2, -4> // <x y z> position of light
  point_at <-1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}


// Bhne ----------------------------------------
plane { -y, 0 
 hollow
 clipped_by { plane { -z,0 } }
 pigment {color rgb <0.7,0.5,0.3>}
}

plane { z, 0 
 hollow
 clipped_by { plane { y,0 } }
 pigment {color rgb <0.7,0.4,0.3>}
}

// Vorhangumrandung
polygon {
    9,
    <-1.2, 0.0>, <-1.15, 1.85>,
    <0,1.9>,<1.15,1.85>,
    <1.2,0>,
    <3,0>,<3,3333>,
    <-3,3333>,<-3,0>
    pigment { color rgb <1, 0, 0> }
 }



// Vorhang
#declare Vorhang1 = texture
{
  pigment
  {
    gradient x
    turbulence 0.1  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency 15
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1
    turbulence 0.1
    frequency 30
    scale <0.1, 0.4, 0.1>
  }
}
#declare Vorhang2 = texture
{
  pigment
  {
    gradient x
    turbulence 0.11  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency 15
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1.01
    turbulence 0.11
    frequency 30
    phase 10
    scale <0.1, 0.41, 0.1>
  }
}

// Der eigentliche Vorhang
#declare vorh_auf=1.1; // ganz auf: 1.1

plane {
 z,0.05
 clipped_by { plane {x,0} }
 texture { Vorhang1 }
 translate -vorh_auf*x
}

plane {
 z,0.051
 clipped_by { plane {-x,0} }
 texture { Vorhang2 }
 translate vorh_auf*x
}
 


// Der Hintergrund

plane
{ z,2.4
 hollow
 pigment
 {
 // texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map
{
  sys "hgr1.bmp" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  once
} 
 translate <-0.5,-0.3,0>
 scale 4
 
 }
}


 #declare typ3x=1.3;
 #declare typ3y=abs(sin(2*10))*0.02;
//#else
// #declare typ3x=2;
// #declare typ3y=abs(sin(20))*0.02;



// Farbiger
union
{
 object {   rumpf3  }
 object {   arm3  }
 object {   kopf3  }
 object {   kopf3 scale -z }
 object {   gesicht  }
 object {   gesicht translate 0.0002 }
 scale <-0.45,0.5,0.5> 
 translate z
 translate (typ3x-1)*x*1.6
 translate y*typ3y
}



#declare typ1x=1;
#declare typ1y=abs(sin(20))*0.02;


#declare oarm=0;
#declare uarm=0;
#declare wkeule=0;

#if (clock1>=3)
 #if (clock1<=4) // ausholen
  #declare uarm=110*(clock1-3);
  #declare oarm=105*(clock1-3);
 #else
  #if (clock1<=4.4) // zuschlagen
   #declare uarm=110-220*(clock1-4);
   #declare oarm=105- 20*(clock1-4);
   #declare wkeule= -180*(clock1-4);    // diesen Frame mehrmals
  #else
   #if (clock1<=4.8) // ausholen
    #declare uarm=22+220*(clock1-4.4);
    #declare oarm=97+ 20*(clock1-4.4);
    #declare wkeule= -72*(clock1-4.4);
   #else
    #if (clock1<=5.2)
     #declare uarm=110-220*(clock1-4.8);
     #declare oarm=105- 20*(clock1-4.8);
     #declare wkeule= -180*(clock1-4.8);
     
    #end
   #end
  #end
 #end
#end


#declare keule = union
{ polygon
  { 4
   <   0,0>,
   < 0.75,0.1>,
   < 0.9,0>,
   < 0.75,-0.1>
  }
  rotate wkeule*z
  translate -0.4*y
  pigment
  { color rgb <1,1,0>
  }
}


#declare armb = union
{
  union
  {
    object { oberarm }
    object { 
     union
     { object{unterarm }
#if (clock1>1)
 #if (clock1<7)
       object{keule}
 #end
#end
     } 
     rotate uarm*z 
    }
  }
  translate -0.3*y
  rotate oarm*z
  translate -0.4*x+1.1*y
}



// Typ
union
{
 object {   rumpf  }
 object {   arm  }
 object {   kopf   }
 object {   kopf  scale -z }
 object {   gesicht   }
 object {   gesicht2   }
 object { armb translate +0.0002*z }
 scale 0.5 
 translate z
 translate (typ1x-1)*x*1.6
 translate y*typ1y
}


