// Persistence of Vision Ray Tracer Scene Description File
// File: f.pov
// Vers: 3.1
// Desc: Alien Invasion - IRTC Anim 10/00 (Aliens)
// Date: 10.10.00
// Auth: Uwe Post, up@upcenter.de
// Take: F. Farbiger sagt welcome, Typ 1 wird rot, tritt vor, gibt Hand, Vorhang
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

#include "typ.pov"

#declare clock1=clock;
//#declare clock1=6

// ----------------------------------------
camera
{
  location  <0.0, 1, -4.0>   //0,1,-4
  direction 1.5*z
  right     4/3*x
#if (clock1<2)
  angle 15          // 35
  look_at   <0.25, 0.9,  0.0>  // 0,1,0
#else
  angle 15+(clock1-2)*5
  look_at   <0.25-0.25*(clock1-2)/4, 0.9+0.1*(clock1-2)/4,  0.0>  // 0,1,0
#end
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 2, -4> // <x y z> position of light
  point_at <0, 1, 0>      // direction of spotlight
  radius 9                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 11               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-1, 2, -4> // <x y z> position of light
  point_at <1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <1, 2, -4> // <x y z> position of light
  point_at <-1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}


// Bhne ----------------------------------------
plane { -y, 0 
 clipped_by { plane { -z,0 } }
 pigment {color rgb <0.7,0.5,0.3>}
}

plane { z, 0 
 clipped_by { plane { y,0 } }
 pigment {color rgb <0.7,0.4,0.3>}
}

// Vorhangumrandung
polygon {
    9,
    <-1.2, 0.0>, <-1.15, 1.85>,
    <0,1.9>,<1.15,1.85>,
    <1.2,0>,
    <3,0>,<3,3333>,
    <-3,3333>,<-3,0>
    pigment { color rgb <1, 0, 0> }
 }

#declare vfreq=10;

#if (clock1>=5)
 #declare vfreq=10-(clock1-5)*5 ;
#end

// Vorhang
#declare Vorhang1 = texture
{
  pigment
  {
    gradient x
    turbulence 0.1  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency vfreq
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1
    turbulence 0.1
    frequency vfreq*2
    scale <0.1, 0.4, 0.1>
  }
}
#declare Vorhang2 = texture
{
  pigment
  {
    gradient x
    turbulence 0.11  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency vfreq
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1.01
    turbulence 0.11
    frequency vfreq*2
    phase 10
    scale <0.1, 0.41, 0.1>
  }
}

// Der eigentliche Vorhang
#declare vorh_auf=1.1; // ganz auf: 1.1
#if (clock1>5)
 #declare vorh_auf=1.1-1.1*(clock1-5);
#end

plane {
 z,0.05
 clipped_by { plane {x,0} }
 texture { Vorhang1 }
 translate -vorh_auf*x
}

plane {
 z,0.051
 clipped_by { plane {-x,0} }
 texture { Vorhang2 }
 translate vorh_auf*x
}
 


// Der Hintergrund

plane
{ z,2.4
 hollow
 pigment
 {
 // texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map
{
  sys "hgr1.bmp" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  once
} 
 translate <-0.5,-0.3,0>
 scale 4
 
 }
}


 #declare typ3x=1.3;
 #declare typ3y=abs(sin(2*10))*0.02;
//#else
// #declare typ3x=2;
// #declare typ3y=abs(sin(20))*0.02;

#declare armsy=0;
#if (clock1>2)
 #if (clock1<3)
  #declare armsy=(clock1-2)*0.3;
 #else
  #declare armsy=0.3;
 #end
#end

#declare armsy1=0;
#if (clock1>3)
 #if (clock1<4)
  #declare armsy1=(clock1-3)*0.3;
 #else
  #declare armsy1=0.3;
 #end
#end

#declare arm3 = union
{
 polygon
 { 4
  <0.2,0.5+armsy>,
  <0.3,0.7+armsy>,
  <-0.4,1.2>,
  <-0.5,1>
 }
  pigment
  { kleidung1
  }
  translate -0.02*z
}

#declare arm = union
{
  polygon
  { 4
   <0.2,0.5+armsy1>,
   <0.3,0.7+armsy1>,
   <-0.4,1.2>,
   <-0.5,1>
  }
  pigment
  { color rgb 0
  }
  translate -0.02*z
}       

// Farbiger
union
{
 object {   rumpf3  }
 object {   arm3  }
 object {   kopf3  }
 object {   gesicht  }
 scale <-0.45,0.5,0.5> 
 translate z
 translate (typ3x-1)*x*1.6
 translate y*typ3y
}



#declare typ1x=1;
#declare typ1y=abs(sin(20))*0.02;

#if (clock1>3)
 #if (clock1<4)
  #declare typ1x=1+(clock1-3)*0.15;
 #else
  #declare typ1x=1.15;
 #end
#end



#declare kopf=
union
{
 polygon
 { 6 
  <-0.6,1.3>,
  <-0.5,1.9>,
  <-0.1,2.1>,
  <0.2, 1.7>,
  <-0.2,1.5>,
  <-0.2,1.3> 
  pigment
  { 
#if (clock1<1)  
  color rgb <1,1,0.9>
#else
 #if (clock1<2)
  #declare blush=(clock1-1);
  color rgb <1,1-(blush)*0.7,0.9-0.7*(blush)>
 #else
  color rgb <1,0.3,0.2>
 #end
#end
  }
 }
 // Umrandung
 union
 {
  polygon
  { 4 
   <-0.6,1.3>,
   <-0.5,1.9>,
   <-0.45,1.9>,
   <-0.55,1.3>
  }
  polygon
  { 4
   <-0.5,1.9>,
   <-0.1,2.1>,
   <-0.05,2.08>,
   <-0.45,1.88>
  }
  polygon
  { 4
   <-0.1,2.1>,
   <0.2, 1.7>,
   <0.15,1.72>,
   <-0.15,2.12>
  }
  polygon
  { 4
   <0.2, 1.7>,
   <-0.2,1.5>,
   <-0.25,1.52>,
   <0.15,1.72>
  }
  polygon
  { 4
   <-0.2,1.5>,
   <-0.2,1.3>,
   <-0.15,1.3>,
   <-0.15,1.5>
  }
  polygon
  { 4
   <-0.6,1.3>,
   <-0.2,1.3>,
   <-0.2,1.35>,
   <-0.6,1.35>
  }  
  polygon
  { 4
  <-0.5,1.9>,
  <-0.2,1.5>,
  <-0.15,1.52>
  <-0.45,1.92>
  }
  pigment
  { color rgb 0
  }
  translate -0.01*z
 }
}


#declare gessy=0;
#if (clock1<1)  
 #declare gessy=0;
#else
 #if (clock1<2)
  #declare gessy=0.1*(clock1-1);
 #else
  #declare gessy=0.1;
 #end
#end


#declare gesicht=
union
{
  polygon
  { 4
   <0,1.6>,
   <-0.2,1.7-gessy>,
   <-0.2,1.75-gessy>,
   <0,1.65>
  }
  polygon
  { 4
    <0,1.8>,
    <0,1.9>,
    <-0.1,1.9>,
    <-0.1,1.8>
  }
  pigment
  { color rgb 0
  }
  
  translate -0.01*z
}


// Typ
union
{
 object {   rumpf  }
 object {   arm  }
 object {   kopf   }
 object {   gesicht  }
 scale 0.5 
 translate z
 translate (typ1x-1)*x*1.6
 translate y*typ1y
}


#macro letter(let,ti)
// create a TrueType text shape
#declare tra=0;
#if (ti>0.65)
 #declare tra=(ti-0.65)/0.35;
#end
text
{
  ttf             // font type (only TrueType format for now)
  "arib____.ttf",  // Microsoft Windows-format TrueType font file name
  let,
  0.1,
  0
  pigment
  { color rgbt <0.1,0.4,0.0,tra>
  }
  finish
  { ambient 1
  }
  no_shadow
  scale 0.25
  rotate z*10*sin(ti*10)
  translate <0.2,1,0> 
  translate -x*ti*0.4
  translate y*ti*0.25
#if(ti<0)
 translate -x*1000
#end
#if(ti>1)
 translate -x*1000
#end
}
#end



object
{
 letter("w",clock1-0.05)
}
object
{
 letter("e",clock1-0.30)
}
object
{
 letter("l",clock1-0.5)
}
object
{
 letter("c",clock1-0.60)
}
object
{
 letter("o",clock1-0.8)
}
object
{
 letter("m",clock1-1)
}
object
{
 letter("e",clock1-1.35)
}
