/* alien.pov - potential IRTC "Alien Invasion" model
Created:     2000.07.20.13.35
Last edited: 2000.07.21.11.35
By:          William de Beaumont
*/
#include "colors.inc"
background {color White}

camera
{
 location <0,10,1>
 look_at <0,0,0>
/* location <-5,0,-5>
 look_at <0,0,0>
*/
}
light_source {<-100,100,-100> color White}

plane 
{ y,-1 
  texture
  {
   finish {reflection .2 ambient 2}
   pigment {checker color Red, color Green translate z*clock*2}
  }
}

union //head
{
 union
 {
  /*
  cone {<0,.5,0>,.7,<0,.3,0>,.653 scale <1,1,.4>}
  cone {<0,.3,0>,.653,<0,.1,0>,.6 scale <1,1,.4>}
  cone {<0,.1,0>,.6,<0,-.2,0>,.45 scale <1,1,.4>}
  cone {<0,-.2,0>,.45,<0,-.5,0>,.2 scale <1,1,.4>}
  */
  intersection
  {
   sphere {<0,0,0>,.7 scale <1,1.43,.4> translate y*.5}
   box {<-1,.5,-1>,<1,-2,1>}
  }
  intersection
  {
   sphere {<0,.5,0>,.7 scale <1,1,.4>}
   box {<-1,.5,-1>,<1,2,1>}
  }
  //antennae
  #declare cnt=0;
  #while (cnt<120)
   cone {<1,0,0>,.02,<1,.1,0>.03 rotate z*cnt translate <-1.1,.7,.3> rotate <-30,-20,0>}
   cone {<-1,0,0>,.02,<-1,.1,0>.03 rotate -z*cnt translate <1.1,.7,.3> rotate <-30,20,0>}
   #declare cnt=cnt+5;
  #end
  //mandibles
  difference
  {
   sphere {<0,0,0>,.2 scale <1,1,.3>}
   sphere {<0,0,0>,.2 translate x*.1}
   translate <-.1,-.6,0>
  }
  difference
  {
   sphere {<0,0,0>,.2 scale <1,1,.3>}
   sphere {<0,0,0>,.2 translate x*-.1}
   translate <.1,-.6,0>
  }
  texture
  {
   finish {phong 1 reflection .1}
   pigment {color Gray40}
  }
 }
 union //eyes
 {
  sphere {<-.3,0,0>,.4 scale <1,1.3,.5> translate <0,.6,-.1>}
  sphere {<.3,0,0>,.4 scale <1,1.3,.5> translate <0,.6,-.1>}
  texture
  {
   finish {phong 1 reflection .1}
   normal{hexagon rotate x*90 scale .01}  
   pigment {color rgb <.5,0,0>}
  }
 }
 rotate x*30
 translate z*-1.5
}
union //thorax and abdomen
{
 sphere  
 { <0,0,0>,.5
   scale <1,1,2>
   translate y*.5
 }
 sphere  
 { <0,0,0>,.7
   scale <1,1,2>
   translate <0,.5,2.2>
 }
/* d=distance between joints                
   (x1,y1) given foot point (hip assumed (0,0))
   (x2,y2) calculated middle joint point
                      /        ____________    \
                     / 2   / -/x1^2 + y1^2  \ 2 \
                     |d  - |----------------|   |{yx}1
         {xy}1       \     \        2       /  /
{xy}2 = ------- {-+} --------------------------------
           2                  __________
                            -/x1^2 + y1^2
*/
 #declare x1=1.75-sin(clock*6.28)/4;
 #declare y1=-.8-sin(clock*6.28)*.2;
 #declare z1=-cos(clock*6.28)*.45;
 #declare x2=(x1/2) - ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*y1)/sqrt(x1*x1+y1*y1+z1*z1);
 #declare y2=(y1/2) + ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*x1)/sqrt(x1*x1+y1*y1+z1*z1);
 #declare z2=z1/2;
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  translate z*.5
 } 
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  scale <-1,1,1>
  translate z*-.5
 }
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  scale <-1,1,1>
  translate z*1.5
 }
 #declare x1=1.75+sin(clock*6.28)/4;
 #declare y1=-.8+sin(clock*6.28)*.2;
 #declare z1=cos(clock*6.28)*.45;
 #declare x2=(x1/2) - ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*y1)/sqrt(x1*x1+y1*y1+z1*z1);
 #declare y2=(y1/2) + ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*x1)/sqrt(x1*x1+y1*y1+z1*z1);
 #declare z2=z1/2;
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  translate z*-.5
 } 
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  translate z*1.5
 } 
 union
 {
  cylinder {<x2,y2,z2>,<0,0,0>,.1} 
  cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
  sphere {<x2,y2,z2>,.1} 
  scale <-1,1,1>
  translate z*.5
 } 
 texture
 {
  finish {phong 1 reflection .1}
  pigment {color Gray40}
 }
} 
/*
cylinder {<-100,0,0>,<100,0,0>,.01 pigment {color Red}}
cylinder {<0,-100,0>,<0,100,0>,.01 pigment {color Green}}
cylinder {<0,0,-100>,<0,0,100>,.01 pigment {color Blue}}
  */
