/* alien0.pov - the alien ship approaching earth
Created:     2000.10.08.21.10
Last edited: 2000.10.09.16.50
By:          William de Beaumont
*/

#include "colors.inc"

camera
{
 scale <1,2/3,1>
 location <30,0,clock*200-50>
 look_at <0,0,0>
}
light_source {<1000,1000,-3000> color White}

#declare dees=seed(5424527482);
#declare stars=0;
#while (stars<5000)
 sphere 
 { <0,0,5000>,8+rand(dees)*2
   rotate <rand(dees)*360,rand(dees)*360,rand(dees)*360>
   texture
   {
    finish {ambient 1}
    #declare offs=rand(dees)*.8;
    pigment {color rgb <offs+rand(dees)/5,offs+rand(dees)/5,offs+rand(dees)/5>}
   }
 }
 #declare stars=stars+1;
#end

sphere {<0,0,-2000>,100 pigment{color Blue}}
sphere {<0,200,-2000>,50 pigment{color White}}

blob
{
 threshold .5
 #declare ship=-10;
 #while (ship<10)
  sphere {<0,0,ship>,sin((ship+10)/20*3.1415)*5, 2.66}
  #declare ship=ship+1;
 #end   
 texture
 {
  finish {reflection .3 phong 1}
  pigment {color rgb<.5,.5,.5>}
 }
 translate z*3
}
union
{
 intersection
 {
  difference
  {
   torus
   { 5,6.01
    rotate x*90
    scale <1,1,2>
   }
   torus
   { 5,6
    rotate x*90
    scale <1,1,2>
   }
  }
  plane {z,0}
 }
 intersection
 {
  difference
  {
   torus
   { 5,6.01
    rotate x*90
    scale <1,1,4>
   }
   torus
   { 5,6
    rotate x*90
    scale <1,1,4>
   }
  }
  plane {-z,0}
 }
 texture
 {
  finish {ambient 1}
  pigment
  { cylindrical
    color_map
    {
     [0.0 rgbt<.3,0,.5,1>]
     [0.5 rgbt<.3,0,.5,.92>]
     [1.0 rgbt<.6,0,1,.88>]
    }
    rotate x*90
    scale 8
  }
 }
 texture
 {
  finish {ambient .8}
  pigment
  { bozo
    color_map
    {
     [0.0 rgbt<.4,0,.5,1>]
     [0.5 rgbt<.4,0,.5,.92>]
     [1.0 rgbt<.8,0,1,.88>]
    }
    scale 2
    translate z*clock*200
  }
 }
}
