// Persistence of Vision Ray Tracer Include File
// File: Hincor.inc
// Vers: 3.1
// Desc: Hinosten frigate
// Date: 5/8/2000 
// Auth: Tom York 

#include "hfmetals.inc"

#ifndef(HN_COR_weap) #declare HN_COR_weap = 1.0; #end
#ifndef(HN_COR_thrust) #declare HN_COR_thrust = 1.0; #end
#ifndef(HN_COR_reactor) #declare HN_COR_reactor = 1.0; #end

#declare AMB_TEST = 0.0; 
 
#declare HN_COR_hull = texture {
          material_map {
                gif "hfhull1.gif"
                map_type 2
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture { 
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }
               }
         
//         rotate <90, 0, 0>
        }

#declare HN_COR_hull2 = texture {
          material_map {
                gif "hfhull1.gif"
                map_type 0
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture { 
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }
               }
         
         rotate <90, 0, 0>
        }

#declare HN_COR_hull3 = texture {
          material_map {
                gif "hfhull1.gif"
                map_type 5
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture { 
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }
               }
        }

#declare HN_COR_pc_glow = texture {
         pigment { colour rgb <0, 1, 1> }
         
         finish { 
                 ambient (<0, 0.5, 1.0> + <1.0, 1.0, 1.0>*HN_COR_weap)                 
                 diffuse 0.0 
                }
        }             

#declare HN_COR_internals = texture {
         material_map {
                gif "hfhull1.gif"
                map_type 0
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture { 
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }
               }
         
         rotate <90, 0, 0>
         
         scale <0.1, 1, 0.1>
        }

#declare HN_COR_thruster = texture {
         pigment { colour rgb <1, 1, 1> }
         
         finish {
                 diffuse 0.0
                 ambient HN_COR_thrust
                } 
        }

#declare HN_COR_reactor = texture {
         pigment { colour rgb <1, 0, 0> }
         
         finish {
                 diffuse 0.0
                 ambient HN_COR_reactor
                } 
        }

/* Objects */        
             
#declare HN_COR_command = difference {
            sphere {
                    <0, 0, 0>,
                    1
        
                    scale <0.5, 0.1, 1>  
                    
                    texture { HN_COR_hull }
                   } 
            
            box {
                 <-0.1, 1, -0.2>,
                 <0.1, -1, 0.2>
                 
                 rotate <60, 0, 0>
                 translate <0, 0, -1.3>
                 
                 texture { HN_COR_hull }
                }                 
                
            box {
                 <-0.1, -1, 0.2>,
                 <0.1, 1, -0.2>
                 
                 rotate <-60, 0, 0>  
                 translate <0, 0, -1.3>
                 
                 texture { HN_COR_hull }
                }                 
                
            box {
                 <-0.05, -1, -0.85>,
                 <0.05, 1, -1.2> 

                 texture { HN_COR_hull }
                }   
                
            box {
                 <-0.03, 0.015, -1.2>,
                 <0.03, -0.015, -0.83>                 
                 
                 texture { HN_COR_pc_glow }
                }
                
            cylinder {
                      <0, 1, 0>,
                      <0, 0.02, 0>,
                      0.25
                      
                      texture { HN_COR_internals }
                      
                      scale <0.5, 1, 1>
                     }

            cylinder {
                      <0, -1, 0>,
                      <0, -0.02, 0>,
                      0.25
                      
                      texture { HN_COR_internals }
                      
                      scale <0.5, 1, 1>
                     }
                     
            cylinder {
                      <-1, 0.35, 0.75>,
                      <1, 0.35, 0.75>,                              
                      0.333
                      
                      texture { HN_COR_hull }
                     } 
                     
            cylinder {
                      <-1, -0.35, 0.75>,
                      <1, -0.35, 0.75>,                              
                      0.333
                      
                      texture { HN_COR_hull }
                     }          
            
            torus {
                   1,
                   0.01                    
                   
                   texture { HN_COR_hull3 }
                   
                   scale <0.5, 1, 1>
                  }         
           }
         
           
#declare HN_COR_lifeboat = difference {
         
         superellipsoid {
                         <1, 0.25>
                         
                         rotate <90, 0, 0>                                                 
                         
                         texture { HN_COR_hull }
                        }
                        
         box {
              <-2, 0, -2>,
              <2, -2, 2>
              
              texture { HN_COR_hull }
             }
             
         cylinder {
                   <0, -1, 0.25>,
                   <0, 0.03, 0.25>,
                   0.125
                   
                   texture { HN_COR_thruster }
                  } 
         
         cylinder {
                   <0, -1, -0.25>,
                   <0, 0.03, -0.25>,
                   0.125
                   
                   texture { HN_COR_thruster }
                  } 
         
         cylinder {
                   <0.25, -1, 0>,
                   <0.25, 0.03, 0>,
                   0.125
                   
                   texture { HN_COR_thruster }
                  } 
         
         cylinder {
                   <-0.25, -1, 0>,
                   <-0.25, 0.03, 0>,
                   0.125
                   
                   texture { HN_COR_thruster }
                  } 
                       
         scale <0.125, 0.05, 0.25>                        
         translate <0, 0.05, 0>               
        }
         
         
#declare HN_COR_reactor = difference {
         sphere {
                 <0, 0, 0>,
                 1
                 
                 texture { HN_COR_hull }
                 
                 scale <0.21, 0.14, 0.21>
                }
         
         #local loop = 0;        
         #while(loop<10)
         box {
              <-0.01, 1, 0.18>,
              <0.01, -1, 1.00> 
              
              texture { HN_COR_reactor }
              
              rotate <0, 36 * loop, 0>
             }
             
         box {
              <-0.01, 1, 0.181>,
              <0.01, -1, 1.00> 
              
              texture { HN_COR_hull }
              
              rotate <0, 36 * loop, 0>
             }        
         
         #local loop = loop + 1;    
         #end
        }           

#declare HN_COR_arm_left = difference {
         lathe {
                cubic_spline     
                5,
        
                <1, 0.5>, <1.1, 0.5>, <1.1, -0.5>, <1.0, -0.5>, <1, 0.5>                                                
               }          
       
         box {
              <-1.6,  1.8, 0>,
              <1.6, -1.8, 1.6>
             }
                                    
         rotate <0, 0, 90>
         rotate <0, -90, 0>                             
         
         texture { HN_COR_hull2 }
         
         scale <0.70, 0.1, 0.4>  
                             
         matrix < 1, 0, -0.4,
                  0, 1, 0,                       
                  0, 0, 1,
                  0, 0, 0 >  
        }

#declare HN_COR_arm_right = difference {
         lathe {
                cubic_spline     
                5,
        
                <1, 0.5>, <1.1, 0.5>, <1.1, -0.5>, <1.0, -0.5>, <1, 0.5>                                                
               }          
       
         box {
              <-1.6,  1.8, 0>,
              <1.6, -1.8, 1.6>
             }
                                    
         rotate <0, 0, 90>
         rotate <0, -90, 0>                             
         
         texture { HN_COR_hull2 }
         
         scale <0.70, 0.1, 0.4>  
                             
         matrix < -1, 0, -0.4,
                  0, 1, 0,                       
                  0, 0, 1,
                  0, 0, 0 >  
        }

#declare HN_CORVETTE = union {
         
         object { HN_COR_command }
                                      
         object { HN_COR_lifeboat }

         object { HN_COR_lifeboat rotate <180, 0, 0> }
         
         object { HN_COR_reactor translate <0, 0, 0.7> }

         object { HN_COR_arm_left translate <0, 0, 0.65> }
         
         object { HN_COR_arm_right translate <0, 0, 0.65> }
        }
