/*

Entry of the Hinosten fleet into the planetary system, via thru-space.

History:
        Power-up of weapons; HFpc_glow modified
        Fixed camera-object collision  
        Fixed non-singular lens (replaced point mass with SIS model)
        
        Increase number of frames from 160 to 210, for frame rate of 24 vs. 18 fps. ???
        Held lens open until aft cleared
        
        Added corvette group 1, changed camera motion, added main fleet

*/

/* Lighting, camera and VFX */
  /*
#macro perturb(in, shake_rate, gamma, start_speed, start_clock, end_clock, amplitude)
#if(clock>start_clock & clock<end_clock) 
#local fx_clock = (clock-start_clock)/(end_clock-start_clock);
#else #local fx_clock = 0.0; #end
#local fx_alpha = sqrt(shake_rate*shake_rate - 0.25*gamma*gamma);
#local vary = amplitude*start_speed*exp(-0.5*gamma*fx_clock)*sin(fx_alpha*fx_clock)/fx_alpha;
(vary+in)
#end
*/

#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end


#if(clock<=1) 
#declare camera_location = <0.25*clock, 0.1*clock, 7>;
//#declare camera_look_at = perturb(<0, 0, 0>, 15.0, 1.8, 13.0, 0.0, 2.0, <-0.08, -0.08, -0.08>);
#declare camera_look_at = lissajous(<0, 0, 0>, 0.05, 0.25, 0.05, 3, 0, 2);
#else
#declare camera_location = <0.25*clock, 0.1, 7>;
//#declare camera_look_at = perturb(<0, 0.1*sin(clock*pi), (cos(clock*pi)+1)*20>, 15.0, 1.8, 13.0, 0.0, 2.0, <-0.08, -0.08, -0.08>);        
#declare camera_look_at = lissajous(<0, 0.1*sin(clock*pi), (cos(clock*pi)+1)*20>, 0.05, 0.25, 0.05, 3, 0, 2);
#end

//#declare camera_look_at = perturb(camera_look_at, 15.0, 1.8, 13.0, 0.0, 2.0, <-0.08, 0.08, 0.0>);    
#declare camera_location = camera_location + 0.1 * vturbulence (4, 0.15, 2, camera_location);
//#declare camera_look_at = camera_look_at + 0.1 * vturbulence (2, 0.50, 5, camera_look_at);

camera {        
        location camera_location 
        look_at camera_look_at 
       }      

light_source {
              <0, 0, -128>
              <1, 1, 1>               
             }              


/* Background star-scape */

#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_pattern_origin = <clock*0.1, clock*0.1, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 5000;
#declare debug_options = true;                          
#include "galaxy\galaxy.inc"

global_settings { max_trace_level 100 }


/* Objects */

/* Hin. frigate 1 (TS exit) */

#if(clock<0.5) #declare hf_weapons_level = 0;
#else #if(clock<1.5) #declare hf_weapons_level = clock - 0.5; #end
#end

#include "hinfri.inc"

object {
        Hin_frigate
        
        #if(clock<0.5) scale <clock+0.0001, clock+0.0001, clock+0.0001>
        #else scale <0.5, 0.5, 0.5>
        #end
        
        rotate <0, 180, 0>
        translate <0, 0, -4.7056 + 9.4112*clock>            
       }

/* Corvette group 1 (TS exit) */
       
#include "hincor.inc"

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <0, clock*5, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <0, 1, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -4.25 + 10*clock>
       }

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <0, -clock*5, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <0, -1, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -4.6 + 10.1*clock>
       }
       
object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <clock*10, 0, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <2.0, 0, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -5 + 9.8*clock>
       }         

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <-clock*10, 0, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <-2.0, 0, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -5.2 + 9.7*clock>
       }         

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <-3.75*clock, 3.75*clock, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <-0.75, 0.75, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -5.7 + 10.5*clock>
       }         

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <3.75*clock, 3.75*clock, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <0.75, 0.75, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -4.7 + 9.5*clock>
       }         

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <-3.75*clock, -3.75*clock, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <-0.75, -0.75, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -5.1 + 10.4*clock>
       }         

object {
        HN_CORVETTE
        
        #if(clock<0.2) 
        scale <clock+0.0001, clock+0.0001, clock+0.0001>
        translate <3.75*clock, -3.75*clock, 0>        
        #else 
        scale <0.2, 0.2, 0.2>
        translate <0.75, -0.75, 0>
        #end
        
        rotate <0, 180, 0>                
        translate <0, 0, -4.8 + 10.2*clock>
       }                

/* Main fleet (3 frigates, 24 corvettes) */

#if(clock>=1.0)
object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        rotate <0, 30, 0>
        translate <-6, 0.25, 18>            
       }

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        rotate <0, 120, 0>
        translate <-1.8, 0.75, 21>            
       }

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        rotate <0, 80, 0>
        translate <-8, 1.75, 16>            
       }

#declare R1 = seed(666);
#declare R2 = seed(999);
#declare loop = 0;    
#while(loop<24) 

        object {
                HN_CORVETTE
        
                scale <0.2, 0.2, 0.2>                        
                rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>                
                translate <20 * rand(R2) - 10, 6 * rand(R2) - 3, 7 * rand(R2) - 3.5>                               
                translate <-3, 1.00, 18>
               }         

        #declare loop = loop + 1;
#end        

#end

/* TS exit point */

cone { 
      <0, 0, -2.382>, 60
      <0, 0, 2.382>, 0.0

      pigment { colour rgbt <1, 1, 1, 1> }
       
      interior { 
                #if(clock<0.5) ior (1.0 + sin(pi*clock)) 
                #else ior 2.0
                #end                
               }
      
      scale <0.2, 0.2, 1.0>      
     }
            