// Lighting, camera and cfx

#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <-1, 0.12, -4>;
#declare camera_look_at = lissajous(<1.0*sin(clock*pi), 1.0*sin(clock*pi), 10 - 60*clock>, 0.01, 0.25, 0.05, 3, 0, 1);

camera {        
        location camera_location
        look_at  camera_look_at
       }

#declare light_loc = <-20, 2, -128>;
#declare flare_scale = <0.55, 0.55, 0.55>;
#declare flare_colour = <0.7, 1.1, 0.9>;
#declare bar_colour = <1.1, 0.9, 0.9>;
//#declare flare_location = <-20, 2, -128>;
#declare flare_location = <-1.038, 0.12376, -4.248>;
#declare flare_brightness = 1.3;

#include "tlens.inc"   

#declare options_only = false;    // protect galaxy inc from lens setting

light_source {              
              light_loc
              <1, 1, 1>
             }

/* Background */

#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_pattern_origin = <clock*0.4, clock*0.4, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 5000;

#include "galaxy\galaxy.inc"
                         

/* Hin. fleet */

#include "hinfri.inc"

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        
        rotate <0, 0, 0>
        
        translate <-3, 1.5, 3-20*clock>                
       }

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        
        rotate <0, 0, 0>
        
        translate <0, 1.25, -20*clock>                
       }

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        
        rotate <0, 0, 0>
        
        translate <-2.6, 0.15, 1-21*clock>                
       }

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>        
        
        rotate <0, 0, 0>
        
        translate <1, -0.4, -0.5-22*clock>                
       }

#include "hincor.inc"

#declare R1 = seed(666);
#declare R2 = seed(999);
#declare loop = 0;    
#while(loop<32) 

        object {
                HN_CORVETTE
        
                scale <0.2, 0.2, 0.2>                                        
                translate <8 * rand(R2) - 4, 8 * rand(R2) - 4, 20 * rand(R2) - 10>                               
                translate <0, 0, -(20 + 5*rand(R1))*clock>                 
               }         

        #declare loop = loop + 1;
#end   

/* Planet */

#include "colors.inc"

#declare Clouds1 = pigment {
      bozo
      turbulence 1
      color_map {
        [0.0 color White filter 0.9]
        [0.5 color White]
        [1.0 color White filter 0.9]
       }
     }

#declare Clouds2 = pigment {
    agate
    turbulence 1
    color_map {
      [0.0 color White filter 0.9]
      [0.5 color White]
      [1.0 color White filter 0.9]
     }
   }

#declare Cl = pigment { colour rgbf <1, 1, 0.8, 0.8> }

#declare CloudArea = texture {
    pigment {
      bozo
      
      scale <0.4, 0.4, 0.4> 
      rotate <90, 180, 0>
      pigment_map {        
        [0.30 Cl]
        [0.85 Clouds1]
        [0.95 Clouds2 ]
      }
    }
  }
  
#declare LandArea = texture {
      pigment {
        crackle
        turbulence 1
        lambda 1.5
        omega .8
        octaves 8
        color_map {
          [0.00 color rgb <.3, .75, .35>]
          [0.33 color rgb <.5, .5, .2>]
          [0.86 color rgb <.6, .6, .2>]
          [1.00 color rgb <.1, .65, .35>]
        }
      }
    }

#declare OceanArea = texture {
      pigment {
        bozo
        turbulence .5
        lambda 2
        color_map {
          [0.00, 0.33 color rgb <0, 0.4, 1>
                      color rgb <0, 0.6, 1>]
          [0.33, 0.66 color rgbt <1, 1, 1, 1>
                      color rgbt <1, 1, 1, 1>]
          [0.66, 1.00 color rgb <0, 0.4, 0.8>
                      color rgb <0, 0.6, 0.8>]
        }
      }
    }
          

union { 
       sphere {
               <0, 0, 0>,
               0.5     
                
               texture { LandArea }
               texture { OceanArea }
        
               finish {
                       ambient 0.03
                       diffuse 0.27
                      }                          
              }
 
       sphere {
               <0, 0,  0>,
               0.55 
                
               texture { CloudArea }        
              }

       scale <3, 3, 3>
       translate <15, 7, -48>           
      }       

