#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <4, 0.3, 1.5 + 0.5 * clock>;
#declare camera_look_at = lissajous(<0, 0, 0>, 0.04, 0.25, 0.05, 3, 0, 1);

camera {        
        location camera_location
        look_at  camera_look_at
       }

#declare light_loc = <20, 2, 4>;
#declare flare_scale = <0.55, 0.55, 0.55>;
#declare flare_colour = <0.7, 1.1, 0.9>;
#declare bar_colour = <1.1, 0.9, 0.9>;
//#declare flare_location = <-20, 2, -128>;
#declare flare_location = <-1.21, 0.1388, -5.32>;
#declare flare_brightness = 1.3;

//#include "tlens.inc"   

light_source {              
              light_loc
              <1, 1, 1>
             }

/* --------Nebula background---------- */       

#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_distance = 50003;
#declare galaxy_pattern_origin = <clock*0.4, clock*0.4, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 50000;

#include "galaxy\galaxy.inc"

global_settings {max_trace_level 30}

#include "deldes.inc"

#if(clock<0.4)
object {
        Del_frigate 
        
        rotate <0, 180, 0>
        translate <1.0, 0, 1.0>
       }
#else

#declare explode_object = object {
        Del_frigate 
        
        rotate <0, 180, 0>
        translate <1.0, 0, 1.0>
       }
                                 
#declare object_corner1 = <3.5, -0.7, -1>;
#declare object_corner2 = <-1, 0.7, 3>;
#declare object_hollow = false;
#declare particle_res = <4, 3, 3>;
#declare particle_texture = texture { pigment {
                                               colour rgb <1, 1, 1> 
                                              } 
                                              
                                     finish { ambient 3 diffuse 0.0 }         
                                    }
#declare exp_strength = 0.3;
#declare exp_falloff = 20;
#declare exp_spin = 0.1;
#declare exp_turb = 0.5;
#declare explode_clock = (clock - 0.268)/0.732;
#include "explode\explode.inc"
#end
 
/* Deltori shield */     

#declare s_shield_colour = <0.7, 1.2, 1.2> + <-0.7, -1.2, -1.2>*((clock-0.1)/0.31);
#declare s_shot_colour = <1.2, 1.2, 1.2> + <-1.2, -1.2, -1.2>*((clock-0.1)/0.31);
#declare s_scale = <3.0, 1.3, 2.0>;
#declare s_shot_dir = <-1, 0, 0>;
#declare s_centre = <0.1, 0.0, 1.0>;
#declare s_decay = 1.1; 
#declare s_cstart = 0.1;
#declare s_cend = 0.32;
#declare s_coverage = 1.00;
#declare s_shield_intensity = 1.0;  
#declare s_shot_intensity = 1.0;
#declare s_shield_grain = <0.1, 0.1, 0.1>;
#declare s_scramble = <-9000, 0, 0>;
#declare s_turbulence = <0.2, 0.2, 0.2>;
#declare s_shield_style = "lightening"                      
//#declare s_create = false;     
       
//#include "shield\shield.inc"   
       
/* Deltori fires   */

#declare dlweap_start = 0.01;
#declare dlweap_stop = 0.099; 
#declare dlweap_src = <0.3, 0.15, 1>;
#declare dlweap_trg = <16, 5, -1 + (clock-0.01) * 30>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;
#declare DW_scale = 1;

#include "delweap.inc"

#if(clock>0.01 & clock<0.099)
light_source {
              <0.3, 0.3, 1>
              <0.3, 1.0 + 0.5*cos(clock*20), 0.3>
             }
#end

/* Incoming Hinosten shots + resulting damage bursts */   


/* Pulse cannon (lower) */

#declare dlweap_start = 0.01;
#declare dlweap_stop = 0.2687; 
#declare dlweap_src = <16, 0.0, 2>;
#declare dlweap_trg = <0.3, 0.0, 1>;
#declare DW_colour = <0.5, 0.5, 0.9>;
#declare DW_bright = 90;
#declare dlweap_mode = 1;
#declare DW_scale = 0.5;

#include "delweap.inc" 

#declare TP_speed = 17;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <3.3, 0, 1>;  
#declare TP_particles = 1000;
#declare TP_glowscale = <0.125, 0.125, 0.125>;

#declare TP_start = 0.2675;
#declare TP_end = 0.8;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
#declare TP_glowenable = false;
                                  
#include "texplode.inc"

#declare dlweap_start = 0.02;
#declare dlweap_stop = 0.2787; 
#declare dlweap_src = <16, 0.0, 2>;
#declare dlweap_trg = <0.3, -0.1, 0.9>;

#include "delweap.inc"

#declare dlweap_start = 0.03;
#declare dlweap_stop = 0.2887; 
#declare dlweap_src = <16, 0.0, 2>;
#declare dlweap_trg = <0.3, 0.0, 1.1>;

#include "delweap.inc"

#declare dlweap_start = 0.04;
#declare dlweap_stop = 0.2987; 
#declare dlweap_src = <16, 0.0, 2>;
#declare dlweap_trg = <0.3, 0.1, 1.2>;

#include "delweap.inc"

/* Pulse cannon (upper) */

#declare dlweap_start = 0.015;
#declare dlweap_stop = 0.2737; 
#declare dlweap_src = <16, 0.5, 2>;
#declare dlweap_trg = <0.6, 0.05, 0.5>;

#include "delweap.inc"

#declare dlweap_start = 0.025;
#declare dlweap_stop = 0.2837; 
#declare dlweap_src = <16, 0.5, 2>;
#declare dlweap_trg = <0.6, 0.01, 0.6>;
                         
#include "delweap.inc"

#declare dlweap_start = 0.035;
#declare dlweap_stop = 0.2937; 
#declare dlweap_src = <16, 0.5, 2>;
#declare dlweap_trg = <0.6, -0.03, 0.7>;

#include "delweap.inc"

#declare dlweap_start = 0.045;
#declare dlweap_stop = 0.3037; 
#declare dlweap_src = <16, 0.5, 2>;
#declare dlweap_trg = <0.6, -0.09, 0.8>;

#include "delweap.inc"

#declare TP_speed = 17;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <3.3, 0, 0.8>;  
#declare TP_particles = 1000;
#declare TP_glowscale = <0.125, 0.125, 0.125>;

#declare TP_start = 0.2675;
#declare TP_end = 0.8;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
#declare TP_glowenable = false;
                                  
#include "texplode.inc"

#declare TP_speed = 3;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <3.0, 0, 1.8>;  
#declare TP_particles = 100;
//#declare TP_glowscale = <0.125, 0.125, 0.125>;
#declare TP_glowenable = true;
#declare TP_glowscatter = 1.0;

#declare TP_start = 0.400;
#declare TP_end = 1.00;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
                                  
#include "texplode.inc"


/* stbd plasma cannon */

#declare dlweap_start = 0.025;
#declare dlweap_stop = 0.4037; 
#declare dlweap_src = <16, 0.0, 3>;
#declare dlweap_trg = <0.6, 0.0, 1.8>;
#declare DW_colour = <0.9, 0.8, 1.1>;
#declare DW_bright = 30;
#declare dlweap_mode = 2;
#declare DW_scale = 1.0;

#include "delweap.inc"

#declare TP_speed = 17;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <2.0, 0, 1.0>;  
#declare TP_particles = 1000;
#declare TP_glowscale = <0.125, 0.125, 0.125>;
#declare TP_glowenable = false;

#declare TP_start = 0.3000;
#declare TP_end = 1.01;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
                                  
#include "texplode.inc"
