#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <0, 1, 0>;
#if(clock<0.5)
#declare camera_look_at = lissajous(<cos(clock*pi), 1 + (14 * clock), 4.0>, 0.04, 0.25, 0.05, 3, 0, 1);
#else
#declare camera_look_at = lissajous(<0.0, 8 - (clock-0.5)*14, 4.0>, 0.04, 0.25, 0.05, 3, 0, 1);
#end

light_source {
              <0, 10, 0>
              <1, 1, 1>
             } 



camera {
        location camera_location
        look_at camera_look_at
       }
       
sky_sphere {          
        pigment {
                gradient y                
                color_map {                           
                        [ 0.0  colour <0.4, 0.1, 0.1> ]              
                        [ 0.1  colour <0.1, 0.0, 0.1> ]
                        [ 0.3  colour <0.0, 0.0, 0.3> ]
                        [ 1.0  colour <0.0, 0.0, 0.5> ]
                        }
                }   
              /*
         pigment {
                bozo      
                turbulence 0.5
                octaves 7
                omega 0.7
                lambda 2
                                
                color_map {  
                        [0.0 0.05 colour rgb <1.00, 1.00, 1.00>
                                  colour rgb <1.00, 1.00, 1.00>]
                        [0.05 0.5 colour rgb <1.00, 1.00, 1.00>
                                  colour rgbt <1, 1, 1, 1>]
                        [0.5 1.0  colour rgbt <1, 1, 1, 1>
                                  colour rgbt <1, 1, 1, 1>]
                        }
                                         
                scale <0.5, 0.2, 0.5>
                
                translate 0
                } */                                          
        }

#declare sky_texture_1 = pigment {
                bozo      
                turbulence 0.5
                octaves 7
                omega 0.7
                lambda 2
                                
                color_map {  
                        [0.0 0.05 colour rgb <1.00, 1.00, 1.00>
                                  colour rgb <1.00, 1.00, 1.00>]
                        [0.05 0.5 colour rgb <1.00, 1.00, 1.00>
                                  colour rgbt <1, 1, 1, 1>]
                        [0.5 1.0  colour rgbt <1, 1, 1, 1>
                                  colour rgbt <1, 1, 1, 1>]
                        }
                                         
                scale <30, 12, 30>
                
                translate 0
               }

#declare sky_texture_2 = pigment {
                 cylindrical
                 colour_map {
                        [0.0 colour rgbt <1, 0.7, 0.7, 5.0>]                        
                        [0.4 colour rgbt <1, 1.0, 1.0, 2.0>]                        
                        [1.0 colour rgbt <1, 1.0, 1.0, 2.0>]
                        }
                        
                        
                scale <1200, 1200, 1200>       
                }
                
                
plane { 
       <0, -1, 0>,
       -25
       
        pigment {
                 average
                 pigment_map {
                              [1.0 sky_texture_1]
                              [1.0 sky_texture_2]
                             } 
                }
                                               
        finish {
                ambient 0.2
               }       
       }         
  
plane {
       <0, 1, 0>,
       0
       
       pigment { 
                agate 
                colour_map {
                        [0.0 colour rgb <0, 0, 0> ]
                        [0.5 colour rgb <0, 0.3, 0> ]
                        [1.0 colour rgb <0, 0.2, 0.3> ]
                       }
               }
      }

// The city               

#declare city_ring = torus {
                        1.5, 0.5
                        
                        scale <1, 0.2, 1>
                                                
                        texture {
                                pigment {
                                         crackle
                                         form <1, 0, 0>
                                         colour_map {
                                                [0.0 colour rgb <0, 0.1, 0>]
                                                [0.5 colour rgb <0, 0.3, 0>]
                                                [1.0 colour rgb <0, 0.3, 1>]
                                               }        
                                         
                                         scale 0.1       
                                        }
                                
                                normal {
                                  crackle 1.5
                                  scale <0.1, 0.1, 0.1>
                                 }
                                  
                                finish {
                                  metallic 1.0 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01
                                  ambient 0.1
                                 }
                               }      
                       }
                       
#declare spacer = union {
                         #local loop = 1;
                         #while(loop<=5)
                                difference {
                                        torus {
                                               1.5, 0.4                                                
                                               
                                               rotate <90, 0, 0>
                                              }
                                        
                                        box {
                                             <-2, -1.8, 2>,
                                             <2, 0, -2>                                             
                                            }
                                        
                                        box {   
                                             <-2, 1.8, 2>,
                                             <2, 1.0, -2>                                             
                                            }
                                            
                                        rotate <0, loop * 72, 0>
                                       }       
                                       
                                #local loop = loop + 1;
                         #end
                         
                         texture {
                                pigment {
                                         crackle
                                         form <1, 0, 0>
                                         colour_map {
                                                [0.0 colour rgb <0, 0.1, 0>]
                                                [0.5 colour rgb <0, 0.3, 0>]
                                                [1.0 colour rgb <0, 0.3, 1>]
                                               }        
                                         
                                         scale 0.1       
                                        }
                                
                                normal {
                                  crackle 1.5
                                  scale <0.1, 0.1, 0.1>
                                 }
                                  
                                finish {
                                  metallic 1.0 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01
                                  ambient 0.1
                                 }
                               }
                        }        
                                               

#declare city_tower = union {
                             #local loop = 1;
                             #while(loop<=5)                                 
                                object { city_ring scale (1-loop*0.025) translate <0, loop, 0> } 
                                #if(loop!=5) object { spacer scale <(1-loop*0.1), 1, (1-loop*0.1)> translate <0, loop, 0> }#end 
                                #local loop = loop + 1;                                
                             #end                            
                             
                             object { city_ring scale <1.0, 2, 1.0> translate <0, 2, 0> }
                                   
                                   
                            } 
                       

object { city_tower translate <0, -1, 15> }
object { city_tower translate <-5, -1, 8> }
object { city_tower translate <3, -1, 5> }
object { city_tower translate <1, -1, 10> }

#declare fish = cylinder {
          <0, 0.25, -1>,
          <0, 0.25, 1>,
          0.25
          
          texture {
                                pigment {
                                         crackle
                                         form <1, 0, 0>
                                         colour_map {
                                                [0.0 colour rgb <0, 0.1, 0>]
                                                [0.5 colour rgb <0, 0.3, 0>]
                                                [1.0 colour rgb <0, 0.3, 1>]
                                               }        
                                         
                                         scale 0.1       
                                        }
                                
                                normal {
                                  crackle 1.5
                                  scale <0.1, 0.1, 0.1>
                                 }
                                  
                                finish {
                                  metallic 1.0 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01
                                  ambient 0.1
                                 }
                               }
         
         rotate <0, 90, 0>
         scale <2, 0.5, 1>
        }
        
object { fish translate <0, 0, 4> }
object { fish translate <-2, 0, 4> }
object { fish rotate <0, 45, 0>  translate <0, 0, 2> }
object { fish rotate <0, 45, 0>  translate <-2, 0, 4> }

fog {        
     fog_type 2
     distance 20   
     color rgb <1, 1.2, 1>
     fog_offset 0.5
     fog_alt 1
     turbulence 0.1
     up <0, 1, 0>
    } 
     

#include "droppod.inc"

object {
        HN_droppod    
        
        scale <0.15, 0.15, 0.15>        
                
        rotate <90, 0, 0>
        rotate <0, 720 * clock, 0>
        translate <0, 15 - clock * 14, 4>
       } 
     