#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <-1-clock, 0, clock>;
#declare camera_look_at = lissajous(<0.0, -14, 0.0>, 0.04, 0.25, 0.05, 3, 0, 1);


camera {
        location camera_location
        look_at camera_look_at
       } 

#declare PG_centre = <0, -120, 0>;
#declare PG_scale = 140;
#declare PG_atmosdisc = false;
#declare PG_atmosthick = 0.1;
#declare PG_atmoscol1 = <4, 4, 4>;
#declare PG_atmoscol2 = <1, 1, 1>;
#declare PG_rotate = <0, 0, 40>;

#include "plangen.inc"

/* --------Planetary light--------- */
   
light_source {
              <15, 150, 0>,
              <1, 1, 1> 
              
              groups "planetary"
             }

#include "hinfri.inc"
 
object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>
        rotate <0, 0, -90*clock>
        rotate <0, -90, 0>
        translate <-7 + 14 * clock, -4, 0>
        
        light_group "!planetary"
       }


#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_distance = 50003;
#declare galaxy_pattern_origin = <clock*0.4, clock*0.4, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 50000;

#include "galaxy\galaxy.inc"

light_source {              
              <28, 5, 28>
              <1, 1, 1> 
             }

#if(clock>=0.2)
#declare blastfade = ((clock - 0.2) / 0.8);                      

disc {
                       <0, 0, 0>,
                       (camera_location-camera_look_at),  
                       1.0
                       
                       hollow
                       no_shadow
      
                       pigment {                                
                                onion               
                                frequency 0.5
                                scallop_wave 
                                //phase 0.25                        
                                                                
                                colour_map {
                                        [0.0 color rgb <1, 1, 0.6> transmit 1.0]           
                                        [0.5 color rgb <1, 1, 1> transmit (-1+2*blastfade)]
                                        [1.0 color rgb <1, 1, 0.6> transmit 1.0]                                        
                                        }                     
                                 
                                
                                } 
      
                      finish {
                        ambient 1.0
                        diffuse 0.0
                        }
                        
                      scale (sqrt(2*blastfade) + 1)                                               
                      translate <10, -50, -5>
                     } 
#end

#declare blastfade = clock;                      

disc {
                       <0, 0, 0>,
                       (camera_location-camera_look_at),  
                       1.0
                       
                       hollow
                       no_shadow
      
                       pigment {                                
                                onion               
                                frequency 0.5
                                scallop_wave 
                                                                
                                colour_map {
                                        [0.0 color rgb <1, 1, 0.6> transmit 1.0]           
                                        [0.5 color rgb <1, 1, 1> transmit (-1+2*blastfade)]
                                        [1.0 color rgb <1, 1, 0.6> transmit 1.0]                                        
                                        }                     
                                 
                                
                                } 
      
                      finish {
                        ambient 1.0
                        diffuse 0.0
                        }
                        
                      scale (sqrt(2*blastfade) + 1)                                               
                      translate <0, -50, -5>
                     } 

#if(clock>=0.1)
#declare blastfade = ((clock - 0.1) / 0.9);                      

disc {
                       <0, 0, 0>,
                       (camera_location-camera_look_at),  
                       1.0
                       
                       hollow
                       no_shadow
      
                       pigment {                                
                                onion               
                                frequency 0.5
                                scallop_wave 
                                                                
                                colour_map {
                                        [0.0 color rgb <1, 1, 0.6> transmit 1.0]           
                                        [0.5 color rgb <1, 1, 1> transmit (-1+2*blastfade)]
                                        [1.0 color rgb <1, 1, 0.6> transmit 1.0]                                        
                                        }                     
                                 
                                
                                } 
      
                      finish {
                        ambient 1.0
                        diffuse 0.0
                        }
                        
                      scale (sqrt(2*blastfade) + 1)                                               
                      translate <3, -50, -10>
                     } 

#end