// Lightening shield file

// Speedups

#if(s_decay!=0) #local decay = exp(-s_decay*sclock);
#else #local decay = 1.0;
#end

// Colours/Materials

#declare s_plas1 = pigment {                           
                           wrinkles                                              
                           rotate (s_scramble*sclock)
                           scale s_shield_grain  
                                                                 
                           colour_map {                                                                         
                                       [0.3 color rgb s_shot_colour transmit 1.0]                                                  
                                       [1.0 color rgb s_shield_colour transmit (1-(s_shot_intensity*(1-sclock)))]
                                      }
                          }
                          
#declare s_plas2 = pigment {                           
                           colour rgbt <8, 8, 12, 0.5 + (0.5 * sclock)>
                          }

#declare s_plas = pigment {                          
                           agate
                           translate sclock*0.05
                                                      
                           pigment_map {                                                                         
                                        [0.995 s_plas1]                                                  
                                        [1.0 s_plas2]
                                      }
                          }
                          
                          
#declare s_bubble = pigment { color rgb s_shield_colour transmit 1.0 } 
                             
#declare s_shield_texture = texture {
                                     pigment {
                                              gradient y 
                                              turbulence s_turbulence
                                              pigment_map {                                                                         
                                                           [0.0 s_plas]                                                  
                                                           [(s_coverage*decay) s_bubble]
                                                          }
                                              
                                             }            
                                     
                                     finish {
                                             diffuse 0.0
                                             ambient (s_shield_intensity)
                                            } 
                                    } 