//Alien.inc

//#version unofficial MegaPov 0.5a;  // version number may be different

#macro Displace(Radius, Current, Total)
<cos(radians((360/Total) * Current)), 0, sin(radians((360/Total) * Current))> * Radius
#end

#macro Alien(ATexture, Radius, CylTop, CylBottom, FootCenter)
  merge
  {
    sphere { CylTop + (Radius * y), Radius }
    cylinder { CylTop, CylBottom, Radius }
    cone { CylBottom, Radius, FootCenter + Displace(Radius, 1, 3), 0 }
    cone { CylBottom, Radius, FootCenter + Displace(Radius, 2, 3), 0 }
    cone { CylBottom, Radius, FootCenter + Displace(Radius, 3, 3), 0 }
    texture { pigment { ATexture } }
  }
#end

#declare BasicAlien =
Alien(pigment { color rgb 1 }, 1, <0, 5, 0>, <0, 2.25, 0>, <0, 0, 0>)

#declare MyGround = 
difference
{
  box
  {
    <-1000, -50, -1000>
    <1000, 0, 1000>
  }
  
  cone
  {
    <0, -10, 0>, 10,
    <0, 1, 0>, 15
  }
  pigment {color rgb <0.7,0.5,0.3>}
}

#macro AlienCircle(MaxCount, Texture1, Texture2, AlienRadius, AlienElev)
  #declare Count = 0;
  #while (Count < MaxCount)
    object 
    {
      BasicAlien 
      #if (mod(Count, 2))
        pigment { Texture1 }
      #else
        pigment { Texture2 }
      #end
      
      translate AlienRadius*z
      rotate (360/MaxCount)*Count*y
      translate <0, AlienElev, 0>
    }
    #declare Count = Count + 1;
  #end
#end

#macro PowerWeave(MaxCount, Texture1, Texture2, AlienRadius, AlienElev, WidthBig, WidthSml, PowerBig, PowerSml)
  union {
  #declare Count = 0;
  #declare Unit = 360/MaxCount;
  #while (Count < MaxCount)
    #declare BeamNum = -1;
    union {
      #while (BeamNum <= 1)
        #declare StartAngle = Unit * Count;
        #declare EndAngle = (StartAngle + 180) + (BeamNum * Unit * 2);
    
        cylinder
        {
          <AlienRadius * cos(radians(StartAngle)), AlienElev, AlienRadius * sin(radians(StartAngle))>,
          <AlienRadius * cos(radians(EndAngle)), AlienElev, AlienRadius * sin(radians(EndAngle))>,
          #if (BeamNum = 0)
            WidthBig
          #else
            WidthSml
          #end            
          
          pigment { color rgbt 1 }
          no_shadow
          hollow
                
          interior 
          { media 
            { 
              emission 
              #if (mod(Count, 2))
                Texture2
              #else
                Texture1
              #end
              *
              #if (BeamNum = 0)
                PowerBig
              #else
                PowerSml
              #end
            }
          }
        }
        #declare BeamNum = BeamNum + 1;
      #end    
    }
    #declare Count = Count + 1;
  #end
  }
  
#end
