//AlienGather.pov

//#version unofficial MegaPov 0.5a;  // version number may be different

#include "colors.inc"
#include "Alien.inc"
#include "planet.inc"

#declare TClock = (clock * 0.7) - 0.05; //-0.5 <= EClock <= 0.65
//#declare TClock = 0.5;                //for Test renders

camera
{
  location  <0.0, 10, -20.0>
  look_at   <0.0, -5,  0.0>
}

object
{
  MyGround
  normal
  {
    bumps
    scale 0.5
  }
}

light_source
{
  <0, -5, 0>
  color rgb <0.5, 0.5, 0.9>
  looks_like 
  {
    sphere {0, 1 texture {pigment {radial frequency 8} finish{specular 1} } }
  }
}

//The Aliens
#declare AlienDist = 8.5;
#declare NumAliens = 12;

#declare FClock = abs(0.3 - TClock); //For Transporter
#declare EndTransportTime = 0.6;
#declare TransportMidTime = 0.3;
#declare BeginAlienTime = 0.1;

#declare AlienElev = -10;

//The circle of 12
#if (TClock > BeginAlienTime)
  #if (TClock < TransportMidTime)
    #declare Texture1 = pigment { color rgbt<0, 0, 1, 1- (0.2 -  FClock) * (1/0.3)> }
    #declare Texture2 = pigment { color rgbt<1, 0, 0, 1- (0.2 -  FClock) * (1/0.3)> }
  #else
    #declare Texture1 = pigment { color rgb<0, 0, 1> }
    #declare Texture2 = pigment { color rgb<1, 0, 0> }
  #end
  AlienCircle(NumAliens, Texture1, Texture2, AlienDist, AlienElev)
#end

  
//The Transport Beams
#if (TClock > 0)
  #if (TClock < EndTransportTime)
    #declare MaxCount = 12;
    #declare Count = 0;
    
    #while (Count < MaxCount)
      cylinder
      {
        <0, 7.1, 0>, <0, -0.1, 0>, 1.1
        #if (mod(Count, 2))
          #declare PigMod = color Blue; 
        #else
          #declare PigMod = color Red;
        #end

        pigment { color Clear }

        hollow
        interior
        {
          media{ emission PigMod * (0.3 -  FClock) * (1/0.3) * 5}
        }

        translate AlienDist*z
        rotate (360/MaxCount)*Count*y
        translate <0, -10, 0>
      }
      #declare Count = Count + 1;
    #end
  #end
#end