//AlienPsi.pov

#version unofficial MegaPov 0.5;  // version number may be different

#declare POSTER = false;

#include "colors.inc"
#include "Alien.inc"
#include "planet.inc"

#declare EClock = clock * 1.5;
//#declare EClock = 1.5;      //for Test Renders

camera
{
  location  <0.0, 10, -20.0>
  look_at   <0.0, -5,  0.0>
}

object
{
  MyGround
  normal
  {
    bumps
    scale 0.5
  }
}

#init_3d_spline
{
  "BallPos",
  <0, -5, 0>,
  <0, -7, 0>
  <0, -9, 0>,
  <0, -3.75, 0>
}

//plane { y, -4 }
#declare Light_Spot = eval_3d_spline("BallPos", EClock / 1.5);


//The following 3 spheres were used to test the position of the Light's looks_like sphere.
/*sphere { 
  eval_3d_spline("BallPos", 1)
  //<0, -4, 0>
  , 1.01 }
sphere { eval_3d_spline("BallPos", 0), 1.01}
sphere { <0, -5, 0>, 1.01}
*/

//sphere { Light_Spot, 1.1 }



light_source
{
  Light_Spot
  color rgb <0.5, 0.5, 0.9>
  #if (POSTER = false)
    looks_like 
    {
      //NOTE: looks_like coordinates are -RELATIVE- to the Light!
      sphere { 0, 1 texture {pigment {radial frequency 8} finish{specular 1} } }
    }
  #end
}

//The Aliens
#declare AlienDist = 8.5;
#declare NumAliens = 12;
#declare AlienElev = -10;
#declare Texture1 = pigment { color rgb<0, 0, 1> }
#declare Texture2 = pigment { color rgb<1, 0, 0> }
#declare Emis1 = color rgb<0, 0.5, 1>;
#declare Emis2 = color rgb<1, 0.5, 0>;

AlienCircle(NumAliens, Texture1, Texture2, AlienDist, AlienElev)

#init_3d_spline
{
  "MajorRad",
  <0, 0, 0>,
  <0.25, 0, 0>,
  <0.55, 0, 0>,
  <0.60, 0, 0>,
  <0.65, 0, 0>
}

#init_3d_spline
{
  "MinorRad",
  <0, 0, 0>,
  <0.25, 0, 0>,
  <0.35, 0, 0>,
  <0.25, 0, 0>,
  <0, 0, 0>
}
                                                             
#init_3d_spline
{
  "MajorPwr",
  <0, 0, 0>,
  <0.5, 0, 0>,
  <1, 0, 0>,
  <1.25, 0, 0>,
  <2, 0, 0>
}

#init_3d_spline
{
  "MinorPwr",
  <0, 0, 0>,
  <0.5, 0, 0>,
  <1, 0, 0>,
  <0.75, 0, 0>,
  <0, 0, 0>
}


object { PowerWeave(NumAliens, Emis1, Emis2, AlienDist, AlienElev + 6,
  eval_3d_spline("MajorRad", EClock / 1.5).x, 
  eval_3d_spline("MinorRad", EClock / 1.5).x,
  eval_3d_spline("MajorPwr", EClock / 1.5).x,
  eval_3d_spline("MinorPwr", EClock / 1.5).x)
  pigment { color rgbt 1 }
}